/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.base;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.imsdk.v2.V2TIMTextElem;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.AudioPlayer;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatLayoutUI;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatProvider;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatProvider;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.input.InputLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageListAdapter;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public abstract class AbsChatLayout
extends ChatLayoutUI
implements IChatLayout {
    protected MessageListAdapter mAdapter;
    private AnimationDrawable mVolumeAnim;
    private Runnable mTypingRunnable = null;
    private ChatProvider.TypingListener mTypingListener = new ChatProvider.TypingListener(){

        @Override
        public void onTyping() {
            final String oldTitle = AbsChatLayout.this.getTitleBar().getMiddleTitle().getText().toString();
            AbsChatLayout.this.getTitleBar().getMiddleTitle().setText(R.string.typing);
            if (AbsChatLayout.this.mTypingRunnable == null) {
                AbsChatLayout.this.mTypingRunnable = new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.getTitleBar().getMiddleTitle().setText((CharSequence)oldTitle);
                    }
                };
            }
            AbsChatLayout.this.getTitleBar().getMiddleTitle().removeCallbacks(AbsChatLayout.this.mTypingRunnable);
            AbsChatLayout.this.getTitleBar().getMiddleTitle().postDelayed(AbsChatLayout.this.mTypingRunnable, 3000L);
        }
    };

    public AbsChatLayout(Context context) {
        super(context);
    }

    public AbsChatLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AbsChatLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void initListener() {
        this.getMessageLayout().setPopActionClickListener(new MessageLayout.OnPopActionClickListener(){

            @Override
            public void onCopyClick(int position, MessageInfo msg) {
                ClipboardManager clipboard = (ClipboardManager)AbsChatLayout.this.getContext().getSystemService("clipboard");
                if (clipboard == null || msg == null) {
                    return;
                }
                if (msg.getMsgType() == 0) {
                    V2TIMTextElem textElem = msg.getTimMessage().getTextElem();
                    String copyContent = textElem == null ? (String)msg.getExtra() : textElem.getText();
                    ClipData clip = ClipData.newPlainText((CharSequence)"message", (CharSequence)copyContent);
                    clipboard.setPrimaryClip(clip);
                }
            }

            @Override
            public void onSendMessageClick(MessageInfo msg, boolean retry) {
                AbsChatLayout.this.sendMessage(msg, retry);
            }

            @Override
            public void onDeleteMessageClick(int position, MessageInfo msg) {
                AbsChatLayout.this.deleteMessage(position, msg);
            }

            @Override
            public void onRevokeMessageClick(int position, MessageInfo msg) {
                AbsChatLayout.this.revokeMessage(position, msg);
            }
        });
        this.getMessageLayout().setLoadMoreMessageHandler(new MessageLayout.OnLoadMoreHandler(){

            @Override
            public void loadMore() {
                AbsChatLayout.this.loadMessages();
            }
        });
        this.getMessageLayout().setEmptySpaceClickListener(new MessageLayout.OnEmptySpaceClickListener(){

            @Override
            public void onClick() {
                AbsChatLayout.this.getInputLayout().hideSoftInput();
            }
        });
        this.getMessageLayout().addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                if (e.getAction() == 1) {
                    View child = rv.findChildViewUnder(e.getX(), e.getY());
                    if (child == null) {
                        AbsChatLayout.this.getInputLayout().hideSoftInput();
                    } else if (child instanceof ViewGroup) {
                        ViewGroup group = (ViewGroup)child;
                        int count = group.getChildCount();
                        float x = e.getRawX();
                        float y = e.getRawY();
                        View touchChild = null;
                        for (int i = count - 1; i >= 0; --i) {
                            View innerChild = group.getChildAt(i);
                            int[] position = new int[2];
                            innerChild.getLocationOnScreen(position);
                            if (!(x >= (float)position[0]) || !(x <= (float)(position[0] + innerChild.getMeasuredWidth())) || !(y >= (float)position[1]) || !(y <= (float)(position[1] + innerChild.getMeasuredHeight()))) continue;
                            touchChild = innerChild;
                            break;
                        }
                        if (touchChild == null) {
                            AbsChatLayout.this.getInputLayout().hideSoftInput();
                        }
                    }
                }
                return false;
            }

            public void onTouchEvent(RecyclerView rv, MotionEvent e) {
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
        this.getInputLayout().setChatInputHandler(new InputLayout.ChatInputHandler(){

            @Override
            public void onInputAreaClick() {
                AbsChatLayout.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.scrollToEnd();
                    }
                });
            }

            @Override
            public void onRecordStatusChanged(int status) {
                switch (status) {
                    case 1: {
                        this.startRecording();
                        break;
                    }
                    case 2: {
                        this.stopRecording();
                        break;
                    }
                    case 3: {
                        this.cancelRecording();
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.stopAbnormally(status);
                        break;
                    }
                }
            }

            private void startRecording() {
                AbsChatLayout.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AudioPlayer.getInstance().stopPlay();
                        AbsChatLayout.this.mRecordingGroup.setVisibility(0);
                        AbsChatLayout.this.mRecordingIcon.setImageResource(R.drawable.recording_volume);
                        AbsChatLayout.this.mVolumeAnim = (AnimationDrawable)AbsChatLayout.this.mRecordingIcon.getDrawable();
                        AbsChatLayout.this.mVolumeAnim.start();
                        AbsChatLayout.this.mRecordingTips.setTextColor(-1);
                        AbsChatLayout.this.mRecordingTips.setText((CharSequence)TUIKit.getAppContext().getString(R.string.down_cancle_send));
                    }
                });
            }

            private void stopRecording() {
                AbsChatLayout.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.mVolumeAnim.stop();
                        AbsChatLayout.this.mRecordingGroup.setVisibility(8);
                    }
                }, 500L);
            }

            private void stopAbnormally(final int status) {
                AbsChatLayout.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.mVolumeAnim.stop();
                        AbsChatLayout.this.mRecordingIcon.setImageResource(R.drawable.ic_volume_dialog_length_short);
                        AbsChatLayout.this.mRecordingTips.setTextColor(-1);
                        if (status == 4) {
                            AbsChatLayout.this.mRecordingTips.setText((CharSequence)TUIKit.getAppContext().getString(R.string.say_time_short));
                        } else {
                            AbsChatLayout.this.mRecordingTips.setText((CharSequence)TUIKit.getAppContext().getString(R.string.record_fail));
                        }
                    }
                });
                AbsChatLayout.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.mRecordingGroup.setVisibility(8);
                    }
                }, 1000L);
            }

            private void cancelRecording() {
                AbsChatLayout.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.mRecordingIcon.setImageResource(R.drawable.ic_volume_dialog_cancel);
                        AbsChatLayout.this.mRecordingTips.setText((CharSequence)TUIKit.getAppContext().getString(R.string.up_cancle_send));
                    }
                });
            }
        });
    }

    @Override
    public void initDefault() {
        this.getTitleBar().getLeftGroup().setVisibility(0);
        this.getTitleBar().setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AbsChatLayout.this.getContext() instanceof Activity) {
                    ((Activity)AbsChatLayout.this.getContext()).finish();
                }
            }
        });
        this.getInputLayout().setMessageHandler(new InputLayout.MessageHandler(){

            @Override
            public void sendMessage(MessageInfo msg) {
                AbsChatLayout.this.sendMessage(msg, false);
            }
        });
        this.getInputLayout().clearCustomActionList();
        if (this.getMessageLayout().getAdapter() == null) {
            this.mAdapter = new MessageListAdapter();
            this.getMessageLayout().setAdapter(this.mAdapter);
        }
        this.initListener();
    }

    @Override
    public void setParentLayout(Object parentContainer) {
    }

    public void scrollToEnd() {
        this.getMessageLayout().scrollToEnd();
    }

    public void setDataProvider(IChatProvider provider) {
        if (provider != null) {
            ((ChatProvider)provider).setTypingListener(this.mTypingListener);
        }
        if (this.mAdapter != null) {
            this.mAdapter.setDataSource(provider);
            this.getChatManager().setLastMessageInfo(this.mAdapter.getItemCount() > 0 ? this.mAdapter.getItem(1) : null);
        }
    }

    public abstract ChatManagerKit getChatManager();

    @Override
    public void loadMessages() {
        this.loadChatMessages(this.mAdapter.getItemCount() > 0 ? this.mAdapter.getItem(1) : null);
    }

    public void loadChatMessages(final MessageInfo lastMessage) {
        this.getChatManager().loadChatMessages(lastMessage, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                if (lastMessage == null && data != null) {
                    AbsChatLayout.this.setDataProvider((ChatProvider)data);
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
                if (lastMessage == null) {
                    AbsChatLayout.this.setDataProvider(null);
                }
            }
        });
    }

    protected void deleteMessage(int position, MessageInfo msg) {
        this.getChatManager().deleteMessage(position, msg);
    }

    protected void revokeMessage(int position, MessageInfo msg) {
        this.getChatManager().revokeMessage(position, msg);
    }

    @Override
    public void sendMessage(MessageInfo msg, boolean retry) {
        this.getChatManager().sendMessage(msg, retry, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AbsChatLayout.this.scrollToEnd();
                    }
                });
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    @Override
    public void exitChat() {
        this.getTitleBar().getMiddleTitle().removeCallbacks(this.mTypingRunnable);
        AudioPlayer.getInstance().stopRecord();
        AudioPlayer.getInstance().stopPlay();
        if (this.getChatManager() != null) {
            this.getChatManager().destroyChat();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.exitChat();
    }
}

