/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.NoticeLayout;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.input.InputLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageLayout;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;

public abstract class ChatLayoutUI
extends LinearLayout
implements IChatLayout {
    protected NoticeLayout mGroupApplyLayout;
    protected View mRecordingGroup;
    protected ImageView mRecordingIcon;
    protected TextView mRecordingTips;
    private TitleBarLayout mTitleBar;
    private MessageLayout mMessageLayout;
    private InputLayout mInputLayout;
    private NoticeLayout mNoticeLayout;
    private ChatInfo mChatInfo;
    private TextView mChatAtInfoLayout;

    public ChatLayoutUI(Context context) {
        super(context);
        this.initViews();
    }

    public ChatLayoutUI(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public ChatLayoutUI(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    private void initViews() {
        ChatLayoutUI.inflate((Context)this.getContext(), (int)R.layout.chat_layout, (ViewGroup)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.chat_title_bar);
        this.mMessageLayout = (MessageLayout)this.findViewById(R.id.chat_message_layout);
        this.mInputLayout = (InputLayout)this.findViewById(R.id.chat_input_layout);
        this.mInputLayout.setChatLayout(this);
        this.mRecordingGroup = this.findViewById(R.id.voice_recording_view);
        this.mRecordingIcon = (ImageView)this.findViewById(R.id.recording_icon);
        this.mRecordingTips = (TextView)this.findViewById(R.id.recording_tips);
        this.mGroupApplyLayout = (NoticeLayout)this.findViewById(R.id.chat_group_apply_layout);
        this.mNoticeLayout = (NoticeLayout)this.findViewById(R.id.chat_notice_layout);
        this.mChatAtInfoLayout = (TextView)this.findViewById(R.id.chat_at_text_view);
        this.init();
    }

    protected void init() {
    }

    @Override
    public InputLayout getInputLayout() {
        return this.mInputLayout;
    }

    @Override
    public MessageLayout getMessageLayout() {
        return this.mMessageLayout;
    }

    @Override
    public NoticeLayout getNoticeLayout() {
        return this.mNoticeLayout;
    }

    @Override
    public ChatInfo getChatInfo() {
        return this.mChatInfo;
    }

    @Override
    public TextView getAtInfoLayout() {
        return this.mChatAtInfoLayout;
    }

    @Override
    public void setChatInfo(ChatInfo chatInfo) {
        this.mChatInfo = chatInfo;
        this.mInputLayout.setChatInfo(chatInfo);
        if (chatInfo == null) {
            return;
        }
        String chatTitle = chatInfo.getChatName();
        this.getTitleBar().setTitle(chatTitle, ITitleBarLayout.POSITION.MIDDLE);
    }

    @Override
    public void exitChat() {
    }

    @Override
    public void initDefault() {
    }

    @Override
    public void loadMessages() {
    }

    @Override
    public void sendMessage(MessageInfo msg, boolean retry) {
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
    }
}

