/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.base;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMAdvancedMsgListener;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMFriendInfo;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageReceipt;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMSendCallback;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatProvider;
import com.tencent.qcloud.tim.uikit.modules.chat.base.OfflineMessageBean;
import com.tencent.qcloud.tim.uikit.modules.chat.base.OfflineMessageContainerBean;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.modules.message.MessageRevokedManager;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ChatManagerKit
extends V2TIMAdvancedMsgListener
implements MessageRevokedManager.MessageRevokeHandler {
    protected static final int MSG_PAGE_COUNT = 20;
    protected static final int REVOKE_TIME_OUT = 6223;
    private static final String TAG = ChatManagerKit.class.getSimpleName();
    protected ChatProvider mCurrentProvider;
    protected boolean mIsMore;
    private boolean mIsLoading;
    private MessageInfo mLastMessageInfo;

    protected void init() {
        this.destroyChat();
        V2TIMManager.getMessageManager().addAdvancedMsgListener((V2TIMAdvancedMsgListener)this);
        MessageRevokedManager.getInstance().addHandler(this);
    }

    public void destroyChat() {
        this.mCurrentProvider = null;
    }

    public abstract ChatInfo getCurrentChatInfo();

    public void setCurrentChatInfo(ChatInfo info) {
        if (info == null) {
            return;
        }
        this.mCurrentProvider = new ChatProvider();
        this.mIsMore = true;
        this.mIsLoading = false;
    }

    public void onReadReport(List<V2TIMMessageReceipt> receiptList) {
        TUIKitLog.i(TAG, "onReadReport:" + receiptList.size());
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "onReadReport unSafetyCall");
            return;
        }
        if (receiptList.size() == 0) {
            return;
        }
        V2TIMMessageReceipt max = receiptList.get(0);
        for (V2TIMMessageReceipt msg : receiptList) {
            if (!TextUtils.equals((CharSequence)msg.getUserID(), (CharSequence)this.getCurrentChatInfo().getId()) || max.getTimestamp() >= msg.getTimestamp()) continue;
            max = msg;
        }
        this.mCurrentProvider.updateReadMessage(max);
    }

    public void onRecvNewMessage(V2TIMMessage msg) {
        TUIKitLog.i(TAG, "onRecvNewMessage msgID:" + msg.getMsgID());
        int elemType = msg.getElemType();
        if (elemType == 2) {
            if (MessageInfoUtil.isTyping(msg.getCustomElem().getData())) {
                this.notifyTyping();
                return;
            }
            if (MessageInfoUtil.isOnlineIgnoredDialing(msg.getCustomElem().getData())) {
                TUIKitLog.i(TAG, "ignore online invitee message");
                return;
            }
        }
        this.onReceiveMessage(msg);
    }

    private void notifyTyping() {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "notifyTyping unSafetyCall");
            return;
        }
        this.mCurrentProvider.notifyTyping();
    }

    public void notifyNewFriend(List<V2TIMFriendInfo> timFriendInfoList) {
        if (timFriendInfoList == null || timFriendInfoList.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TUIKit.getAppContext().getString(R.string.and_and));
        for (V2TIMFriendInfo v2TIMFriendInfo : timFriendInfoList) {
            stringBuilder.append(v2TIMFriendInfo.getUserID()).append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(TUIKit.getAppContext().getString(R.string.be_friend));
        ToastUtil.toastLongMessage(stringBuilder.toString());
    }

    protected void onReceiveMessage(V2TIMMessage msg) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "onReceiveMessage unSafetyCall");
            return;
        }
        this.addMessage(msg);
    }

    protected abstract boolean isGroup();

    protected void addMessage(V2TIMMessage msg) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "addMessage unSafetyCall");
            return;
        }
        List<MessageInfo> list = MessageInfoUtil.TIMMessage2MessageInfo(msg);
        if (list != null && list.size() != 0) {
            ChatInfo chatInfo = this.getCurrentChatInfo();
            boolean isGroupMessage = false;
            String groupID = null;
            String userID = null;
            if (!TextUtils.isEmpty((CharSequence)msg.getGroupID())) {
                if (chatInfo.getType() == 1 || !chatInfo.getId().equals(msg.getGroupID())) {
                    return;
                }
                isGroupMessage = true;
                groupID = msg.getGroupID();
            } else if (!TextUtils.isEmpty((CharSequence)msg.getUserID())) {
                if (chatInfo.getType() == 2 || !chatInfo.getId().equals(msg.getUserID())) {
                    return;
                }
                userID = msg.getUserID();
            } else {
                return;
            }
            this.mCurrentProvider.addMessageInfoList(list);
            for (MessageInfo msgInfo : list) {
                msgInfo.setRead(true);
                this.addGroupMessage(msgInfo);
            }
            if (isGroupMessage) {
                V2TIMManager.getMessageManager().markGroupMessageAsRead(groupID, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TAG, "addMessage() markGroupMessageAsRead failed, code = " + code + ", desc = " + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.i(TAG, "addMessage() markGroupMessageAsRead success");
                    }
                });
            } else {
                V2TIMManager.getMessageManager().markC2CMessageAsRead(userID, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TAG, "addMessage() markC2CMessageAsRead failed, code = " + code + ", desc = " + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.i(TAG, "addMessage() markC2CMessageAsRead success");
                    }
                });
            }
        }
    }

    protected void addGroupMessage(MessageInfo msgInfo) {
    }

    public void deleteMessage(final int position, MessageInfo messageInfo) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "deleteMessage unSafetyCall");
            return;
        }
        ArrayList<V2TIMMessage> msgs = new ArrayList<V2TIMMessage>();
        msgs.add(this.mCurrentProvider.getDataSource().get(position).getTimMessage());
        V2TIMManager.getMessageManager().deleteMessages(msgs, new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.w(TAG, "deleteMessages code:" + code + "|desc:" + desc);
            }

            public void onSuccess() {
                TUIKitLog.i(TAG, "deleteMessages success");
                ChatManagerKit.this.mCurrentProvider.remove(position);
                ConversationManagerKit.getInstance().loadConversation(null);
            }
        });
    }

    public void revokeMessage(int position, final MessageInfo messageInfo) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "revokeMessage unSafetyCall");
            return;
        }
        V2TIMManager.getMessageManager().revokeMessage(messageInfo.getTimMessage(), new V2TIMCallback(){

            public void onError(int code, String desc) {
                if (code == 6223) {
                    ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.send_two_mins));
                } else {
                    ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.hold_say) + code + "=" + desc);
                }
            }

            public void onSuccess() {
                if (!ChatManagerKit.this.safetyCall()) {
                    TUIKitLog.w(TAG, "revokeMessage unSafetyCall");
                    return;
                }
                ChatManagerKit.this.mCurrentProvider.updateMessageRevoked(messageInfo.getId());
                ConversationManagerKit.getInstance().loadConversation(null);
            }
        });
    }

    public void sendMessage(final MessageInfo message, boolean retry, final IUIKitCallBack callBack) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "sendMessage unSafetyCall");
            return;
        }
        if (message == null || message.getStatus() == 1) {
            return;
        }
        message.setSelf(true);
        message.setRead(true);
        this.assembleGroupMessage(message);
        OfflineMessageContainerBean containerBean = new OfflineMessageContainerBean();
        OfflineMessageBean entity = new OfflineMessageBean();
        entity.content = message.getExtra().toString();
        entity.sender = message.getFromUser();
        entity.nickname = TUIKitConfigs.getConfigs().getGeneralConfig().getUserNickname();
        entity.faceUrl = TUIKitConfigs.getConfigs().getGeneralConfig().getUserFaceUrl();
        containerBean.entity = entity;
        String userID = "";
        String groupID = "";
        boolean isGroup = false;
        if (this.getCurrentChatInfo().getType() == 2) {
            groupID = this.getCurrentChatInfo().getId();
            isGroup = true;
            entity.chatType = 2;
            entity.sender = groupID;
        } else {
            userID = this.getCurrentChatInfo().getId();
        }
        V2TIMOfflinePushInfo v2TIMOfflinePushInfo = new V2TIMOfflinePushInfo();
        v2TIMOfflinePushInfo.setExt(new Gson().toJson((Object)containerBean).getBytes());
        v2TIMOfflinePushInfo.setAndroidOPPOChannelID("tuikit");
        V2TIMMessage v2TIMMessage = message.getTimMessage();
        String msgID = V2TIMManager.getMessageManager().sendMessage(v2TIMMessage, isGroup ? null : userID, isGroup ? groupID : null, 0, false, v2TIMOfflinePushInfo, (V2TIMSendCallback)new V2TIMSendCallback<V2TIMMessage>(){

            public void onProgress(int progress) {
            }

            public void onError(int code, String desc) {
                TUIKitLog.v(TAG, "sendMessage fail:" + code + "=" + desc);
                if (!ChatManagerKit.this.safetyCall()) {
                    TUIKitLog.w(TAG, "sendMessage unSafetyCall");
                    return;
                }
                if (callBack != null) {
                    callBack.onError(TAG, code, desc);
                }
                message.setStatus(3);
                ChatManagerKit.this.mCurrentProvider.updateMessageInfo(message);
            }

            public void onSuccess(V2TIMMessage v2TIMMessage) {
                TUIKitLog.v(TAG, "sendMessage onSuccess:" + v2TIMMessage.getMsgID());
                if (!ChatManagerKit.this.safetyCall()) {
                    TUIKitLog.w(TAG, "sendMessage unSafetyCall");
                    return;
                }
                if (callBack != null) {
                    callBack.onSuccess(ChatManagerKit.this.mCurrentProvider);
                }
                message.setStatus(2);
                message.setMsgTime(v2TIMMessage.getTimestamp());
                ChatManagerKit.this.mCurrentProvider.updateMessageInfo(message);
            }
        });
        TUIKitLog.i(TAG, "sendMessage msgID:" + msgID);
        message.setId(msgID);
        if (message.getMsgType() < 256) {
            message.setStatus(1);
            if (retry) {
                this.mCurrentProvider.resendMessageInfo(message);
            } else {
                this.mCurrentProvider.addMessageInfo(message);
            }
        }
    }

    protected void assembleGroupMessage(MessageInfo message) {
    }

    public void getAtInfoChatMessages(long atInfoMsgSeq, V2TIMMessage lastMessage, final IUIKitCallBack callBack) {
        final ChatInfo chatInfo = this.getCurrentChatInfo();
        if (atInfoMsgSeq == -1L || lastMessage == null || lastMessage.getSeq() <= atInfoMsgSeq) {
            return;
        }
        if (chatInfo.getType() == 2) {
            V2TIMManager.getMessageManager().getGroupHistoryMessageList(chatInfo.getId(), (int)(lastMessage.getSeq() - atInfoMsgSeq), lastMessage, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMMessage>>(){

                public void onError(int code, String desc) {
                    TUIKitLog.e(TAG, "loadChatMessages getGroupHistoryMessageList failed, code = " + code + ", desc = " + desc);
                }

                public void onSuccess(List<V2TIMMessage> v2TIMMessages) {
                    ChatManagerKit.this.processHistoryMsgs(v2TIMMessages, chatInfo, callBack);
                }
            });
        }
    }

    public void loadChatMessages(MessageInfo lastMessage, final IUIKitCallBack callBack) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "loadLocalChatMessages unSafetyCall");
            return;
        }
        if (this.mIsLoading) {
            return;
        }
        this.mIsLoading = true;
        if (!this.mIsMore) {
            this.mCurrentProvider.addMessageInfo(null);
            callBack.onSuccess(null);
            this.mIsLoading = false;
            return;
        }
        V2TIMMessage lastTIMMsg = null;
        if (lastMessage == null) {
            this.mCurrentProvider.clear();
        } else {
            lastTIMMsg = lastMessage.getTimMessage();
        }
        final ChatInfo chatInfo = this.getCurrentChatInfo();
        if (chatInfo.getType() == 1) {
            V2TIMManager.getMessageManager().getC2CHistoryMessageList(chatInfo.getId(), 20, lastTIMMsg, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMMessage>>(){

                public void onError(int code, String desc) {
                    ChatManagerKit.this.mIsLoading = false;
                    callBack.onError(TAG, code, desc);
                    TUIKitLog.e(TAG, "loadChatMessages getC2CHistoryMessageList failed, code = " + code + ", desc = " + desc);
                }

                public void onSuccess(List<V2TIMMessage> v2TIMMessages) {
                    ChatManagerKit.this.processHistoryMsgs(v2TIMMessages, chatInfo, callBack);
                }
            });
        } else {
            V2TIMManager.getMessageManager().getGroupHistoryMessageList(chatInfo.getId(), 20, lastTIMMsg, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMMessage>>(){

                public void onError(int code, String desc) {
                    ChatManagerKit.this.mIsLoading = false;
                    callBack.onError(TAG, code, desc);
                    TUIKitLog.e(TAG, "loadChatMessages getGroupHistoryMessageList failed, code = " + code + ", desc = " + desc);
                }

                public void onSuccess(List<V2TIMMessage> v2TIMMessages) {
                    ChatManagerKit.this.processHistoryMsgs(v2TIMMessages, chatInfo, callBack);
                }
            });
        }
    }

    private void processHistoryMsgs(List<V2TIMMessage> v2TIMMessages, ChatInfo chatInfo, IUIKitCallBack callBack) {
        this.mIsLoading = false;
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "getLocalMessage unSafetyCall");
            return;
        }
        if (chatInfo.getType() == 1) {
            V2TIMManager.getMessageManager().markC2CMessageAsRead(chatInfo.getId(), new V2TIMCallback(){

                public void onError(int code, String desc) {
                    TUIKitLog.e(TAG, "processHistoryMsgs setReadMessage failed, code = " + code + ", desc = " + desc);
                }

                public void onSuccess() {
                    TUIKitLog.d(TAG, "processHistoryMsgs setReadMessage success");
                }
            });
        } else {
            V2TIMManager.getMessageManager().markGroupMessageAsRead(chatInfo.getId(), new V2TIMCallback(){

                public void onError(int code, String desc) {
                    TUIKitLog.e(TAG, "processHistoryMsgs markC2CMessageAsRead failed, code = " + code + ", desc = " + desc);
                }

                public void onSuccess() {
                    TUIKitLog.d(TAG, "processHistoryMsgs markC2CMessageAsRead success");
                }
            });
        }
        if (v2TIMMessages.size() < 20) {
            this.mIsMore = false;
        }
        ArrayList<V2TIMMessage> messages = new ArrayList<V2TIMMessage>(v2TIMMessages);
        Collections.reverse(messages);
        List<MessageInfo> msgInfos = MessageInfoUtil.TIMMessages2MessageInfos(messages, this.isGroup());
        this.mCurrentProvider.addMessageList(msgInfos, true);
        for (int i = 0; i < msgInfos.size(); ++i) {
            MessageInfo info = msgInfos.get(i);
            if (info.getStatus() != 1) continue;
            this.sendMessage(info, true, null);
        }
        callBack.onSuccess(this.mCurrentProvider);
    }

    @Override
    public void handleInvoke(String msgID) {
        if (!this.safetyCall()) {
            TUIKitLog.w(TAG, "handleInvoke unSafetyCall");
            return;
        }
        TUIKitLog.i(TAG, "handleInvoke msgID = " + msgID);
        this.mCurrentProvider.updateMessageRevoked(msgID);
    }

    protected boolean safetyCall() {
        return this.mCurrentProvider != null && this.getCurrentChatInfo() != null;
    }

    public void setLastMessageInfo(MessageInfo mLastMessageInfo) {
        this.mLastMessageInfo = mLastMessageInfo;
    }

    public MessageInfo getLastMessageInfo() {
        return this.mLastMessageInfo;
    }
}

