/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.base;

import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMMessageReceipt;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatProvider;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageListAdapter;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import java.util.ArrayList;
import java.util.List;

public class ChatProvider
implements IChatProvider {
    private ArrayList<MessageInfo> mDataSource = new ArrayList();
    private MessageListAdapter mAdapter;
    private TypingListener mTypingListener;

    @Override
    public List<MessageInfo> getDataSource() {
        return this.mDataSource;
    }

    @Override
    public boolean addMessageList(List<MessageInfo> msgs, boolean front) {
        boolean flag;
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        for (MessageInfo info : msgs) {
            if (this.checkExist(info)) continue;
            list.add(info);
        }
        if (front) {
            flag = this.mDataSource.addAll(0, list);
            this.updateAdapter(2, list.size());
        } else {
            flag = this.mDataSource.addAll(list);
            this.updateAdapter(3, list.size());
        }
        return flag;
    }

    private boolean checkExist(MessageInfo msg) {
        if (msg != null) {
            String msgId = msg.getId();
            for (int i = this.mDataSource.size() - 1; i >= 0; --i) {
                if (!this.mDataSource.get(i).getId().equals(msgId) || this.mDataSource.get(i).getUniqueId() != msg.getUniqueId() || !TextUtils.equals((CharSequence)this.mDataSource.get(i).getExtra().toString(), (CharSequence)msg.getExtra().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean deleteMessageList(List<MessageInfo> messages) {
        block0: for (int i = 0; i < this.mDataSource.size(); ++i) {
            for (int j = 0; j < messages.size(); ++j) {
                if (!this.mDataSource.get(i).getId().equals(messages.get(j).getId())) continue;
                this.mDataSource.remove(i);
                this.updateAdapter(5, i);
                continue block0;
            }
        }
        return false;
    }

    @Override
    public boolean updateMessageList(List<MessageInfo> messages) {
        return false;
    }

    public boolean addMessageInfoList(List<MessageInfo> msg) {
        if (msg == null || msg.size() == 0) {
            this.updateAdapter(1, 0);
            return true;
        }
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        for (MessageInfo info : msg) {
            if (this.checkExist(info)) {
                this.updateTIMMessageStatus(info);
                continue;
            }
            list.add(info);
        }
        if (list.size() == 0) {
            return false;
        }
        boolean flag = this.mDataSource.addAll(list);
        this.updateAdapter(0, 0);
        return flag;
    }

    public boolean addMessageInfo(MessageInfo msg) {
        if (msg == null) {
            this.updateAdapter(1, 0);
            return true;
        }
        if (this.checkExist(msg)) {
            return true;
        }
        boolean flag = this.mDataSource.add(msg);
        this.updateAdapter(3, 1);
        return flag;
    }

    public boolean deleteMessageInfo(MessageInfo msg) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!this.mDataSource.get(i).getId().equals(msg.getId())) continue;
            this.mDataSource.remove(i);
            this.updateAdapter(5, -1);
            return true;
        }
        return false;
    }

    public boolean resendMessageInfo(MessageInfo message) {
        boolean found = false;
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!this.mDataSource.get(i).getId().equals(message.getId())) continue;
            this.mDataSource.remove(i);
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        return this.addMessageInfo(message);
    }

    public boolean updateMessageInfo(MessageInfo message) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!this.mDataSource.get(i).getId().equals(message.getId())) continue;
            this.mDataSource.remove(i);
            this.mDataSource.add(i, message);
            this.updateAdapter(4, i);
            return true;
        }
        return false;
    }

    public boolean updateTIMMessageStatus(MessageInfo message) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!this.mDataSource.get(i).getId().equals(message.getId()) || this.mDataSource.get(i).getStatus() == message.getStatus()) continue;
            this.mDataSource.get(i).setStatus(message.getStatus());
            this.updateAdapter(4, i);
            return true;
        }
        return false;
    }

    public boolean updateMessageRevoked(String msgId) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            MessageInfo messageInfo = this.mDataSource.get(i);
            if (!messageInfo.getId().equals(msgId)) continue;
            messageInfo.setMsgType(275);
            messageInfo.setStatus(275);
            this.updateAdapter(4, i);
        }
        return false;
    }

    public void updateReadMessage(V2TIMMessageReceipt max) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            MessageInfo messageInfo = this.mDataSource.get(i);
            if (messageInfo.getMsgTime() > max.getTimestamp()) {
                messageInfo.setPeerRead(false);
                continue;
            }
            if (messageInfo.isPeerRead()) continue;
            messageInfo.setPeerRead(true);
            this.updateAdapter(4, i);
        }
    }

    public void notifyTyping() {
        if (this.mTypingListener != null) {
            this.mTypingListener.onTyping();
        }
    }

    public void setTypingListener(TypingListener l) {
        this.mTypingListener = l;
    }

    public void remove(int index) {
        this.mDataSource.remove(index);
        this.updateAdapter(5, index);
    }

    public void clear() {
        this.mDataSource.clear();
        this.updateAdapter(1, 0);
    }

    private void updateAdapter(int type, int data) {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSourceChanged(type, data);
        }
    }

    @Override
    public void setAdapter(MessageListAdapter adapter) {
        this.mAdapter = adapter;
    }

    public static interface TypingListener {
        public void onTyping();
    }
}

