/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.input;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.tencent.liteav.SelectContactActivity;
import com.tencent.liteav.login.UserModel;
import com.tencent.liteav.trtcaudiocalldemo.ui.TRTCAudioCallActivity;
import com.tencent.liteav.trtcvideocalldemo.ui.TRTCVideoCallActivity;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.AudioPlayer;
import com.tencent.qcloud.tim.uikit.component.face.Emoji;
import com.tencent.qcloud.tim.uikit.component.face.FaceFragment;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import com.tencent.qcloud.tim.uikit.component.video.CameraActivity;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.base.BaseInputFragment;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.input.InputLayoutUI;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.input.TIMMentionEditText;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.inputmore.InputMoreFragment;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.PermissionUtils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputLayout
extends InputLayoutUI
implements View.OnClickListener,
TextWatcher {
    private static final String TAG = InputLayout.class.getSimpleName();
    private static final int STATE_NONE_INPUT = -1;
    private static final int STATE_SOFT_INPUT = 0;
    private static final int STATE_VOICE_INPUT = 1;
    private static final int STATE_FACE_INPUT = 2;
    private static final int STATE_ACTION_INPUT = 3;
    private FaceFragment mFaceFragment;
    private ChatInputHandler mChatInputHandler;
    private MessageHandler mMessageHandler;
    private FragmentManager mFragmentManager;
    private InputMoreFragment mInputMoreFragment;
    private IChatLayout mChatLayout;
    private boolean mSendEnable;
    private boolean mAudioCancel;
    private int mCurrentState;
    private int mLastMsgLineCount;
    private float mStartRecordY;
    private String mInputContent;
    private onStartActivityListener mStartActivityListener;
    private Map<String, String> atUserInfoMap = new HashMap<String, String>();
    private String displayInputString;

    public InputLayout(Context context) {
        super(context);
    }

    public InputLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public InputLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void init() {
        this.mAudioInputSwitchButton.setOnClickListener((View.OnClickListener)this);
        this.mEmojiInputButton.setOnClickListener((View.OnClickListener)this);
        this.mMoreInputButton.setOnClickListener((View.OnClickListener)this);
        this.mSendTextButton.setOnClickListener((View.OnClickListener)this);
        this.mTextInput.addTextChangedListener(this);
        this.mTextInput.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                InputLayout.this.showSoftInput();
                return false;
            }
        });
        this.mTextInput.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                return false;
            }
        });
        this.mTextInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                return false;
            }
        });
        this.mSendAudioButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                TUIKitLog.i(TAG, "mSendAudioButton onTouch action:" + motionEvent.getAction());
                if (!InputLayout.this.checkPermission(2)) {
                    TUIKitLog.i(TAG, "audio record checkPermission failed");
                    return false;
                }
                switch (motionEvent.getAction()) {
                    case 0: {
                        InputLayout.this.mAudioCancel = true;
                        InputLayout.this.mStartRecordY = motionEvent.getY();
                        if (InputLayout.this.mChatInputHandler != null) {
                            InputLayout.this.mChatInputHandler.onRecordStatusChanged(1);
                        }
                        InputLayout.this.mSendAudioButton.setText((CharSequence)TUIKit.getAppContext().getString(R.string.release_end));
                        AudioPlayer.getInstance().startRecord(new AudioPlayer.Callback(){

                            @Override
                            public void onCompletion(Boolean success) {
                                InputLayout.this.recordComplete(success);
                            }
                        });
                        break;
                    }
                    case 2: {
                        if (motionEvent.getY() - InputLayout.this.mStartRecordY < -100.0f) {
                            InputLayout.this.mAudioCancel = true;
                            if (InputLayout.this.mChatInputHandler != null) {
                                InputLayout.this.mChatInputHandler.onRecordStatusChanged(3);
                            }
                        } else {
                            if (InputLayout.this.mAudioCancel && InputLayout.this.mChatInputHandler != null) {
                                InputLayout.this.mChatInputHandler.onRecordStatusChanged(1);
                            }
                            InputLayout.this.mAudioCancel = false;
                        }
                        InputLayout.this.mSendAudioButton.setText((CharSequence)TUIKit.getAppContext().getString(R.string.release_end));
                        break;
                    }
                    case 1: 
                    case 3: {
                        InputLayout.this.mAudioCancel = motionEvent.getY() - InputLayout.this.mStartRecordY < -100.0f;
                        if (InputLayout.this.mChatInputHandler != null) {
                            InputLayout.this.mChatInputHandler.onRecordStatusChanged(2);
                        }
                        AudioPlayer.getInstance().stopRecord();
                        InputLayout.this.mSendAudioButton.setText((CharSequence)TUIKit.getAppContext().getString(R.string.hold_say));
                        break;
                    }
                }
                return false;
            }
        });
        this.mTextInput.setOnMentionInputListener(new TIMMentionEditText.OnMentionInputListener(){

            @Override
            public void onMentionCharacterInput(String tag) {
                if (tag.equals("@") && InputLayout.this.mChatLayout.getChatInfo().getType() == 2) {
                    InputLayout.this.mStartActivityListener.onStartGroupMemberSelectActivity();
                }
            }
        });
    }

    public void updateInputText(String names, String ids) {
        if (names == null || ids == null || names.isEmpty() || ids.isEmpty()) {
            return;
        }
        this.updateAtUserInfoMap(names, ids);
        if (this.mTextInput != null) {
            this.mTextInput.setText(this.mTextInput.getText() + this.displayInputString);
            this.mTextInput.setSelection(this.mTextInput.getText().length());
        }
    }

    private void updateAtUserInfoMap(String names, String ids) {
        this.displayInputString = "";
        if (ids.equals("__kImSDK_MesssageAtALL__")) {
            this.atUserInfoMap.put(names, ids);
            this.displayInputString = this.displayInputString + names;
            this.displayInputString = this.displayInputString + " ";
            this.displayInputString = this.displayInputString + "@";
        } else {
            String[] listId;
            String[] listName = names.split(" ");
            boolean isListName = listName.length >= (listId = ids.split(" ")).length;
            int i = 0;
            if (isListName) {
                for (i = 0; i < listId.length; ++i) {
                    this.atUserInfoMap.put(listName[i], listId[i]);
                    this.displayInputString = this.displayInputString + listName[i];
                    this.displayInputString = this.displayInputString + " ";
                    this.displayInputString = this.displayInputString + "@";
                }
            } else {
                for (i = 0; i < listName.length; ++i) {
                    this.atUserInfoMap.put(listName[i], listId[i]);
                    this.displayInputString = this.displayInputString + listName[i];
                    this.displayInputString = this.displayInputString + " ";
                    this.displayInputString = this.displayInputString + "@";
                }
            }
        }
        if (!this.displayInputString.isEmpty()) {
            this.displayInputString = this.displayInputString.substring(0, this.displayInputString.length() - 1);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTextInput.removeTextChangedListener(this);
        this.atUserInfoMap.clear();
    }

    @Override
    protected void startSendPhoto() {
        TUIKitLog.i(TAG, "startSendPhoto");
        if (!this.checkPermission(4)) {
            TUIKitLog.i(TAG, "startSendPhoto checkPermission failed");
            return;
        }
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        String[] mimetypes = new String[]{"image/*", "video/*"};
        intent.putExtra("android.intent.extra.MIME_TYPES", mimetypes);
        this.mInputMoreFragment.setCallback(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                TUIKitLog.i(TAG, "onSuccess: " + data);
                if (data == null) {
                    TUIKitLog.e(TAG, "data is null");
                    return;
                }
                String uri = data.toString();
                if (TextUtils.isEmpty((CharSequence)uri)) {
                    TUIKitLog.e(TAG, "uri is empty");
                    return;
                }
                String videoPath = FileUtil.getPathFromUri((Uri)data);
                String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)videoPath);
                String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension);
                if (mimeType != null && mimeType.contains("video")) {
                    MessageInfo msg = InputLayout.this.buildVideoMessage(FileUtil.getPathFromUri((Uri)data));
                    if (msg == null) {
                        TUIKitLog.e(TAG, "start send video error data: " + data);
                    } else if (InputLayout.this.mMessageHandler != null) {
                        InputLayout.this.mMessageHandler.sendMessage(msg);
                        InputLayout.this.hideSoftInput();
                    }
                } else {
                    MessageInfo info = MessageInfoUtil.buildImageMessage((Uri)data, true);
                    if (InputLayout.this.mMessageHandler != null) {
                        InputLayout.this.mMessageHandler.sendMessage(info);
                        InputLayout.this.hideSoftInput();
                    }
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.i(TAG, "errCode: " + errCode);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
        this.mInputMoreFragment.startActivityForResult(intent, 1012);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageInfo buildVideoMessage(String mUri) {
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        try {
            MessageInfo msg;
            mmr.setDataSource(mUri);
            String sDuration = mmr.extractMetadata(9);
            Bitmap bitmap = mmr.getFrameAtTime(0L, 1);
            if (bitmap == null) {
                TUIKitLog.e(TAG, "buildVideoMessage() bitmap is null");
                MessageInfo messageInfo = null;
                return messageInfo;
            }
            String imgPath = FileUtil.saveBitmap("JCamera", bitmap);
            String videoPath = mUri;
            int imgWidth = bitmap.getWidth();
            int imgHeight = bitmap.getHeight();
            long duration = Long.valueOf(sDuration);
            MessageInfo messageInfo = msg = MessageInfoUtil.buildVideoMessage(imgPath, videoPath, imgWidth, imgHeight, duration);
            return messageInfo;
        }
        catch (Exception ex) {
            TUIKitLog.e(TAG, "MediaMetadataRetriever exception " + ex);
        }
        finally {
            mmr.release();
        }
        return null;
    }

    @Override
    protected void startCapture() {
        TUIKitLog.i(TAG, "startCapture");
        if (!this.checkPermission(1)) {
            TUIKitLog.i(TAG, "startCapture checkPermission failed");
            return;
        }
        Intent captureIntent = new Intent(this.getContext(), CameraActivity.class);
        captureIntent.putExtra("camera_type", 257);
        CameraActivity.mCallBack = new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                Uri contentUri = Uri.fromFile((File)new File(data.toString()));
                MessageInfo msg = MessageInfoUtil.buildImageMessage(contentUri, true);
                if (InputLayout.this.mMessageHandler != null) {
                    InputLayout.this.mMessageHandler.sendMessage(msg);
                    InputLayout.this.hideSoftInput();
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
            }
        };
        this.getContext().startActivity(captureIntent);
    }

    @Override
    protected void startVideoRecord() {
        TUIKitLog.i(TAG, "startVideoRecord");
        if (!this.checkPermission(3)) {
            TUIKitLog.i(TAG, "startVideoRecord checkPermission failed");
            return;
        }
        Intent captureIntent = new Intent(this.getContext(), CameraActivity.class);
        captureIntent.putExtra("camera_type", 258);
        CameraActivity.mCallBack = new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                Intent videoData = (Intent)data;
                String imgPath = videoData.getStringExtra("camera_image_path");
                String videoPath = videoData.getStringExtra("camera_video_path");
                int imgWidth = videoData.getIntExtra("image_width", 0);
                int imgHeight = videoData.getIntExtra("image_height", 0);
                long duration = videoData.getLongExtra("video_time", 0L);
                MessageInfo msg = MessageInfoUtil.buildVideoMessage(imgPath, videoPath, imgWidth, imgHeight, duration);
                if (InputLayout.this.mMessageHandler != null) {
                    InputLayout.this.mMessageHandler.sendMessage(msg);
                    InputLayout.this.hideSoftInput();
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
            }
        };
        this.getContext().startActivity(captureIntent);
    }

    @Override
    protected void startSendFile() {
        TUIKitLog.i(TAG, "startSendFile");
        if (!this.checkPermission(5)) {
            TUIKitLog.i(TAG, "startSendFile checkPermission failed");
            return;
        }
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        this.mInputMoreFragment.setCallback(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                MessageInfo info = MessageInfoUtil.buildFileMessage((Uri)data);
                if (InputLayout.this.mMessageHandler != null) {
                    InputLayout.this.mMessageHandler.sendMessage(info);
                    InputLayout.this.hideSoftInput();
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
        this.mInputMoreFragment.startActivityForResult(intent, 1011);
    }

    @Override
    public void startAudioCall() {
        if (!PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.RECORD_AUDIO")) {
            TUIKitLog.i(TAG, "startAudioCall checkPermission failed");
            return;
        }
        if (this.mChatLayout.getChatInfo().getType() == 1) {
            ArrayList<UserModel> contactList = new ArrayList<UserModel>();
            UserModel model = new UserModel();
            model.userId = this.mChatLayout.getChatInfo().getId();
            model.userName = this.mChatLayout.getChatInfo().getChatName();
            model.userSig = TUIKitConfigs.getConfigs().getGeneralConfig().getUserSig();
            contactList.add(model);
            TRTCAudioCallActivity.startCallSomeone(this.mActivity.getApplicationContext(), contactList);
        } else {
            SelectContactActivity.start(this.mActivity.getApplicationContext(), this.mChatLayout.getChatInfo().getId(), 1);
        }
    }

    @Override
    protected void startVideoCall() {
        if (!PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.CAMERA") || !PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.RECORD_AUDIO")) {
            TUIKitLog.i(TAG, "startVideoCall checkPermission failed");
            return;
        }
        if (this.mChatLayout.getChatInfo().getType() == 1) {
            ArrayList<UserModel> contactList = new ArrayList<UserModel>();
            UserModel model = new UserModel();
            model.userId = this.mChatLayout.getChatInfo().getId();
            model.userName = this.mChatLayout.getChatInfo().getChatName();
            model.userSig = TUIKitConfigs.getConfigs().getGeneralConfig().getUserSig();
            contactList.add(model);
            TRTCVideoCallActivity.startCallSomeone(this.mActivity.getApplicationContext(), contactList);
        } else {
            SelectContactActivity.start(this.mActivity.getApplicationContext(), this.mChatLayout.getChatInfo().getId(), 2);
        }
    }

    @Override
    protected void startGroupLive() {
        if (this.mStartActivityListener != null) {
            boolean isHandle = this.mStartActivityListener.handleStartGroupLiveActivity();
            if (!isHandle) {
                this.startDefaultGroupLiveAnchor();
            }
        } else {
            this.startDefaultGroupLiveAnchor();
        }
    }

    private void startDefaultGroupLiveAnchor() {
        Intent intent = new Intent();
        intent.setAction("com.tencent.qcloud.tim.tuikit.live.grouplive.anchor");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.putExtra("group_id", this.mChatLayout.getChatInfo().getId());
        TUIKit.getAppContext().startActivity(intent);
    }

    public void setChatInputHandler(ChatInputHandler handler) {
        this.mChatInputHandler = handler;
    }

    public void setMessageHandler(MessageHandler handler) {
        this.mMessageHandler = handler;
    }

    public void setStartActivityListener(onStartActivityListener listener) {
        this.mStartActivityListener = listener;
    }

    public void onClick(View view) {
        TUIKitLog.i(TAG, "onClick id:" + view.getId() + "|voice_input_switch:" + R.id.voice_input_switch + "|face_btn:" + R.id.face_btn + "|more_btn:" + R.id.more_btn + "|send_btn:" + R.id.send_btn + "|mCurrentState:" + this.mCurrentState + "|mSendEnable:" + this.mSendEnable + "|mMoreInputEvent:" + this.mMoreInputEvent);
        if (view.getId() == R.id.voice_input_switch) {
            if (this.mCurrentState == 2 || this.mCurrentState == 3) {
                this.mCurrentState = 1;
                this.mInputMoreView.setVisibility(8);
                this.mEmojiInputButton.setImageResource(R.drawable.action_face_selector);
            } else {
                this.mCurrentState = this.mCurrentState == 0 ? 1 : 0;
            }
            if (this.mCurrentState == 1) {
                this.mAudioInputSwitchButton.setImageResource(R.drawable.action_textinput_selector);
                this.mSendAudioButton.setVisibility(0);
                this.mTextInput.setVisibility(8);
                this.hideSoftInput();
            } else {
                this.mAudioInputSwitchButton.setImageResource(R.drawable.action_audio_selector);
                this.mSendAudioButton.setVisibility(8);
                this.mTextInput.setVisibility(0);
                this.showSoftInput();
            }
        } else if (view.getId() == R.id.face_btn) {
            if (this.mCurrentState == 1) {
                this.mCurrentState = -1;
                this.mAudioInputSwitchButton.setImageResource(R.drawable.action_audio_selector);
                this.mSendAudioButton.setVisibility(8);
                this.mTextInput.setVisibility(0);
            }
            if (this.mCurrentState == 2) {
                this.mCurrentState = -1;
                this.mInputMoreView.setVisibility(8);
                this.mEmojiInputButton.setImageResource(R.drawable.action_face_selector);
                this.mTextInput.setVisibility(0);
            } else {
                this.mCurrentState = 2;
                this.mEmojiInputButton.setImageResource(R.drawable.action_textinput_selector);
                this.showFaceViewGroup();
            }
        } else if (view.getId() == R.id.more_btn) {
            this.hideSoftInput();
            if (this.mMoreInputEvent instanceof View.OnClickListener) {
                ((View.OnClickListener)this.mMoreInputEvent).onClick(view);
            } else if (this.mMoreInputEvent instanceof BaseInputFragment) {
                this.showCustomInputMoreFragment();
            } else if (this.mCurrentState == 3) {
                this.mCurrentState = -1;
                if (this.mInputMoreView.getVisibility() == 0) {
                    this.mInputMoreView.setVisibility(8);
                } else {
                    this.mInputMoreView.setVisibility(0);
                }
            } else {
                this.showInputMoreLayout();
                this.mCurrentState = 3;
                this.mAudioInputSwitchButton.setImageResource(R.drawable.action_audio_selector);
                this.mEmojiInputButton.setImageResource(R.drawable.action_face_selector);
                this.mSendAudioButton.setVisibility(8);
                this.mTextInput.setVisibility(0);
            }
        } else if (view.getId() == R.id.send_btn && this.mSendEnable) {
            if (this.mMessageHandler != null) {
                if (this.mChatLayout.getChatInfo().getType() == 2 && !this.atUserInfoMap.isEmpty()) {
                    List<String> atUserList = this.updateAtUserList(this.mTextInput.getMentionList(true));
                    if (atUserList == null || atUserList.isEmpty()) {
                        this.mMessageHandler.sendMessage(MessageInfoUtil.buildTextMessage(this.mTextInput.getText().toString().trim()));
                    } else {
                        this.mMessageHandler.sendMessage(MessageInfoUtil.buildTextAtMessage(atUserList, this.mTextInput.getText().toString().trim()));
                    }
                } else {
                    this.mMessageHandler.sendMessage(MessageInfoUtil.buildTextMessage(this.mTextInput.getText().toString().trim()));
                }
            }
            this.mTextInput.setText("");
        }
    }

    private List<String> updateAtUserList(List<String> atMentionList) {
        if (atMentionList == null || atMentionList.isEmpty()) {
            return null;
        }
        ArrayList<String> atUserIdList = new ArrayList<String>();
        for (String name : atMentionList) {
            if (!this.atUserInfoMap.containsKey(name)) continue;
            atUserIdList.add(this.atUserInfoMap.get(name));
        }
        this.atUserInfoMap.clear();
        return atUserIdList;
    }

    private void showSoftInput() {
        TUIKitLog.v(TAG, "showSoftInput");
        this.hideInputMoreLayout();
        this.mAudioInputSwitchButton.setImageResource(R.drawable.action_audio_selector);
        this.mEmojiInputButton.setImageResource(R.drawable.ic_input_face_normal);
        this.mTextInput.requestFocus();
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.showSoftInput((View)this.mTextInput, 0);
        if (this.mChatInputHandler != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputLayout.this.mChatInputHandler.onInputAreaClick();
                }
            }, 200L);
        }
    }

    public void hideSoftInput() {
        TUIKitLog.i(TAG, "hideSoftInput");
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mTextInput.getWindowToken(), 0);
        this.mTextInput.clearFocus();
        this.mInputMoreView.setVisibility(8);
    }

    private void showFaceViewGroup() {
        TUIKitLog.i(TAG, "showFaceViewGroup");
        if (this.mFragmentManager == null) {
            this.mFragmentManager = this.mActivity.getSupportFragmentManager();
        }
        if (this.mFaceFragment == null) {
            this.mFaceFragment = new FaceFragment();
        }
        this.hideSoftInput();
        this.mInputMoreView.setVisibility(0);
        this.mTextInput.requestFocus();
        this.mFaceFragment.setListener(new FaceFragment.OnEmojiClickListener(){

            @Override
            public void onEmojiDelete() {
                int index = InputLayout.this.mTextInput.getSelectionStart();
                Editable editable = InputLayout.this.mTextInput.getText();
                boolean isFace = false;
                if (index <= 0) {
                    return;
                }
                if (editable.charAt(index - 1) == ']') {
                    for (int i = index - 2; i >= 0; --i) {
                        if (editable.charAt(i) != '[') continue;
                        String faceChar = editable.subSequence(i, index).toString();
                        if (!FaceManager.isFaceChar(faceChar)) break;
                        editable.delete(i, index);
                        isFace = true;
                        break;
                    }
                }
                if (!isFace) {
                    editable.delete(index - 1, index);
                }
            }

            @Override
            public void onEmojiClick(Emoji emoji) {
                int index = InputLayout.this.mTextInput.getSelectionStart();
                Editable editable = InputLayout.this.mTextInput.getText();
                editable.insert(index, (CharSequence)emoji.getFilter());
                FaceManager.handlerEmojiText((TextView)InputLayout.this.mTextInput, editable.toString(), true);
            }

            @Override
            public void onCustomFaceClick(int groupIndex, Emoji emoji) {
                InputLayout.this.mMessageHandler.sendMessage(MessageInfoUtil.buildCustomFaceMessage(groupIndex, emoji.getFilter()));
            }
        });
        this.mFragmentManager.beginTransaction().replace(R.id.more_groups, (Fragment)this.mFaceFragment).commitAllowingStateLoss();
        if (this.mChatInputHandler != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputLayout.this.mChatInputHandler.onInputAreaClick();
                }
            }, 100L);
        }
    }

    private void showCustomInputMoreFragment() {
        TUIKitLog.i(TAG, "showCustomInputMoreFragment");
        if (this.mFragmentManager == null) {
            this.mFragmentManager = this.mActivity.getSupportFragmentManager();
        }
        BaseInputFragment fragment = (BaseInputFragment)((Object)this.mMoreInputEvent);
        this.hideSoftInput();
        this.mInputMoreView.setVisibility(0);
        this.mFragmentManager.beginTransaction().replace(R.id.more_groups, (Fragment)fragment).commitAllowingStateLoss();
        if (this.mChatInputHandler != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputLayout.this.mChatInputHandler.onInputAreaClick();
                }
            }, 100L);
        }
    }

    private void showInputMoreLayout() {
        TUIKitLog.i(TAG, "showInputMoreLayout");
        if (this.mFragmentManager == null) {
            this.mFragmentManager = this.mActivity.getSupportFragmentManager();
        }
        if (this.mInputMoreFragment == null) {
            this.mInputMoreFragment = new InputMoreFragment();
        }
        this.assembleActions();
        this.mInputMoreFragment.setActions(this.mInputMoreActionList);
        this.hideSoftInput();
        this.mInputMoreView.setVisibility(0);
        this.mFragmentManager.beginTransaction().replace(R.id.more_groups, (Fragment)this.mInputMoreFragment).commitAllowingStateLoss();
        if (this.mChatInputHandler != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputLayout.this.mChatInputHandler.onInputAreaClick();
                }
            }, 100L);
        }
    }

    private void hideInputMoreLayout() {
        this.mInputMoreView.setVisibility(8);
    }

    private void recordComplete(boolean success) {
        int duration = AudioPlayer.getInstance().getDuration();
        TUIKitLog.i(TAG, "recordComplete duration:" + duration);
        if (this.mChatInputHandler != null) {
            if (!success || duration == 0) {
                this.mChatInputHandler.onRecordStatusChanged(5);
                return;
            }
            if (this.mAudioCancel) {
                this.mChatInputHandler.onRecordStatusChanged(3);
                return;
            }
            if (duration < 1000) {
                this.mChatInputHandler.onRecordStatusChanged(4);
                return;
            }
            this.mChatInputHandler.onRecordStatusChanged(2);
        }
        if (this.mMessageHandler != null && success) {
            this.mMessageHandler.sendMessage(MessageInfoUtil.buildAudioMessage(AudioPlayer.getInstance().getPath(), duration));
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.mInputContent = s.toString();
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        if (TextUtils.isEmpty((CharSequence)s.toString().trim())) {
            this.mSendEnable = false;
            this.showSendTextButton(8);
            this.showMoreInputButton(0);
        } else {
            this.mSendEnable = true;
            this.showSendTextButton(0);
            this.showMoreInputButton(8);
            if (this.mTextInput.getLineCount() != this.mLastMsgLineCount) {
                this.mLastMsgLineCount = this.mTextInput.getLineCount();
                if (this.mChatInputHandler != null) {
                    this.mChatInputHandler.onInputAreaClick();
                }
            }
            if (!TextUtils.equals((CharSequence)this.mInputContent, (CharSequence)this.mTextInput.getText().toString())) {
                FaceManager.handlerEmojiText((TextView)this.mTextInput, this.mTextInput.getText().toString(), true);
            }
        }
    }

    public void setChatLayout(IChatLayout chatLayout) {
        this.mChatLayout = chatLayout;
    }

    public static interface onStartActivityListener {
        public void onStartGroupMemberSelectActivity();

        public boolean handleStartGroupLiveActivity();
    }

    public static interface ChatInputHandler {
        public static final int RECORD_START = 1;
        public static final int RECORD_STOP = 2;
        public static final int RECORD_CANCEL = 3;
        public static final int RECORD_TOO_SHORT = 4;
        public static final int RECORD_FAILED = 5;

        public void onInputAreaClick();

        public void onRecordStatusChanged(int var1);
    }

    public static interface MessageHandler {
        public void sendMessage(MessageInfo var1);
    }
}

