/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.input;

import android.app.AlertDialog;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.base.BaseInputFragment;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IInputLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.input.TIMMentionEditText;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.inputmore.InputMoreActionUnit;
import com.tencent.qcloud.tim.uikit.utils.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

abstract class InputLayoutUI
extends LinearLayout
implements IInputLayout {
    protected static final int CAPTURE = 1;
    protected static final int AUDIO_RECORD = 2;
    protected static final int VIDEO_RECORD = 3;
    protected static final int SEND_PHOTO = 4;
    protected static final int SEND_FILE = 5;
    private static String TAG = InputLayoutUI.class.getSimpleName();
    protected ImageView mAudioInputSwitchButton;
    protected boolean mAudioInputDisable;
    protected ImageView mEmojiInputButton;
    protected boolean mEmojiInputDisable;
    protected ImageView mMoreInputButton;
    protected Object mMoreInputEvent;
    protected boolean mMoreInputDisable;
    protected Button mSendTextButton;
    protected Button mSendAudioButton;
    protected TIMMentionEditText mTextInput;
    protected AppCompatActivity mActivity;
    protected View mInputMoreLayout;
    protected View mInputMoreView;
    protected ChatInfo mChatInfo;
    protected List<InputMoreActionUnit> mInputMoreActionList = new ArrayList<InputMoreActionUnit>();
    protected List<InputMoreActionUnit> mInputMoreCustomActionList = new ArrayList<InputMoreActionUnit>();
    private AlertDialog mPermissionDialog;
    private boolean mSendPhotoDisable;
    private boolean mCaptureDisable;
    private boolean mVideoRecordDisable;
    private boolean mSendFileDisable;
    private boolean mEnableAudioCall;
    private boolean mEnableVideoCall;

    public InputLayoutUI(Context context) {
        super(context);
        this.initViews();
    }

    public InputLayoutUI(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
    }

    public InputLayoutUI(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    private void initViews() {
        this.mActivity = (AppCompatActivity)this.getContext();
        InputLayoutUI.inflate((Context)this.mActivity, (int)R.layout.chat_input_layout, (ViewGroup)this);
        this.mInputMoreView = this.findViewById(R.id.more_groups);
        this.mSendAudioButton = (Button)this.findViewById(R.id.chat_voice_input);
        this.mAudioInputSwitchButton = (ImageView)this.findViewById(R.id.voice_input_switch);
        this.mEmojiInputButton = (ImageView)this.findViewById(R.id.face_btn);
        this.mMoreInputButton = (ImageView)this.findViewById(R.id.more_btn);
        this.mSendTextButton = (Button)this.findViewById(R.id.send_btn);
        this.mTextInput = (TIMMentionEditText)this.findViewById(R.id.chat_message_input);
        this.init();
    }

    protected void assembleActions() {
        this.mInputMoreActionList.clear();
        InputMoreActionUnit action = new InputMoreActionUnit();
        if (!this.mSendPhotoDisable) {
            action.setIconResId(R.drawable.ic_more_picture);
            action.setTitleId(R.string.pic);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    InputLayoutUI.this.startSendPhoto();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (!this.mCaptureDisable) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_camera);
            action.setTitleId(R.string.photo);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startCapture();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (!this.mVideoRecordDisable) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_video);
            action.setTitleId(R.string.video);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startVideoRecord();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (!this.mSendFileDisable) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_file);
            action.setTitleId(R.string.file);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startSendFile();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (this.mEnableVideoCall) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_video_call);
            action.setTitleId(R.string.video_call);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startVideoCall();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (this.mEnableAudioCall) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_audio_call);
            action.setTitleId(R.string.audio_call);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startAudioCall();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        if (TUIKit.getConfigs().isEnableGroupLiveEntry() && this.mChatInfo != null && this.mChatInfo.getType() != 1) {
            action = new InputMoreActionUnit();
            action.setIconResId(R.drawable.ic_more_group_live);
            action.setTitleId(R.string.live_group_live);
            action.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputLayoutUI.this.startGroupLive();
                }
            });
            this.mInputMoreActionList.add(action);
        }
        this.mInputMoreActionList.addAll(this.mInputMoreCustomActionList);
    }

    protected boolean checkPermission(int type) {
        if (!PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return false;
        }
        if (!PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.READ_EXTERNAL_STORAGE")) {
            return false;
        }
        if (type == 5 || type == 4) {
            return true;
        }
        if (type == 1) {
            return PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.CAMERA");
        }
        if (type == 2) {
            return PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.RECORD_AUDIO");
        }
        if (type == 3) {
            return PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.CAMERA") && PermissionUtils.checkPermission((Context)this.mActivity, "android.permission.RECORD_AUDIO");
        }
        return true;
    }

    protected abstract void init();

    protected abstract void startSendPhoto();

    protected abstract void startCapture();

    protected abstract void startVideoRecord();

    protected abstract void startSendFile();

    protected abstract void startAudioCall();

    protected abstract void startVideoCall();

    protected abstract void startGroupLive();

    @Override
    public void disableAudioInput(boolean disable) {
        this.mAudioInputDisable = disable;
        if (disable) {
            this.mAudioInputSwitchButton.setVisibility(8);
        } else {
            this.mAudioInputSwitchButton.setVisibility(0);
        }
    }

    @Override
    public void disableEmojiInput(boolean disable) {
        this.mEmojiInputDisable = disable;
        if (disable) {
            this.mEmojiInputButton.setVisibility(8);
        } else {
            this.mEmojiInputButton.setVisibility(0);
        }
    }

    @Override
    public void disableMoreInput(boolean disable) {
        this.mMoreInputDisable = disable;
        if (disable) {
            this.mMoreInputButton.setVisibility(8);
            this.mSendTextButton.setVisibility(0);
        } else {
            this.mMoreInputButton.setVisibility(0);
            this.mSendTextButton.setVisibility(8);
        }
    }

    @Override
    public void replaceMoreInput(BaseInputFragment fragment) {
        this.mMoreInputEvent = fragment;
    }

    @Override
    public void replaceMoreInput(View.OnClickListener listener) {
        this.mMoreInputEvent = listener;
    }

    @Override
    public void disableSendPhotoAction(boolean disable) {
        this.mSendPhotoDisable = disable;
    }

    @Override
    public void disableCaptureAction(boolean disable) {
        this.mCaptureDisable = disable;
    }

    @Override
    public void disableVideoRecordAction(boolean disable) {
        this.mVideoRecordDisable = disable;
    }

    @Override
    public void disableSendFileAction(boolean disable) {
        this.mSendFileDisable = disable;
    }

    @Override
    public boolean enableAudioCall() {
        if (TUIKitConfigs.getConfigs().getGeneralConfig().isSupportAVCall()) {
            this.mEnableAudioCall = true;
            return true;
        }
        this.mEnableAudioCall = false;
        return false;
    }

    @Override
    public boolean enableVideoCall() {
        if (TUIKitConfigs.getConfigs().getGeneralConfig().isSupportAVCall()) {
            this.mEnableVideoCall = true;
            return true;
        }
        this.mEnableVideoCall = false;
        return false;
    }

    @Override
    public void addAction(InputMoreActionUnit action) {
        this.mInputMoreCustomActionList.add(action);
    }

    @Override
    public EditText getInputText() {
        return this.mTextInput;
    }

    protected void showMoreInputButton(int visibility) {
        if (this.mMoreInputDisable) {
            return;
        }
        this.mMoreInputButton.setVisibility(visibility);
    }

    protected void showSendTextButton(int visibility) {
        if (this.mMoreInputDisable) {
            this.mSendTextButton.setVisibility(0);
        } else {
            this.mSendTextButton.setVisibility(visibility);
        }
    }

    protected void showEmojiInputButton(int visibility) {
        if (this.mEmojiInputDisable) {
            return;
        }
        this.mEmojiInputButton.setVisibility(visibility);
    }

    public void clearCustomActionList() {
        this.mInputMoreCustomActionList.clear();
    }

    public void setChatInfo(ChatInfo chatInfo) {
        this.mChatInfo = chatInfo;
    }

    public ChatInfo getChatInfo() {
        return this.mChatInfo;
    }
}

