/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.input;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TIMMentionEditText
extends EditText {
    public static final String TIM_METION_TAG = "@";
    public static final Pattern TIM_MENTION_PATTERN = Pattern.compile("@[^\\s]+\\s");
    private Map<String, Pattern> mPatternMap = new HashMap<String, Pattern>();
    private int mTIMMentionTextColor;
    private boolean mIsSelected;
    private Range mLastSelectedRange;
    private List<Range> mRangeArrayList = new ArrayList<Range>();
    private OnMentionInputListener mOnMentionInputListener;

    public TIMMentionEditText(Context context) {
        super(context);
        this.init();
    }

    public TIMMentionEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TIMMentionEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new HackInputConnection(super.onCreateInputConnection(outAttrs), true, this);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        this.colorMentionString();
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        Range nearbyRange;
        super.onSelectionChanged(selStart, selEnd);
        if (this.mLastSelectedRange != null && this.mLastSelectedRange.isEqual(selStart, selEnd)) {
            return;
        }
        Range closestRange = this.getRangeOfClosestMentionString(selStart, selEnd);
        if (closestRange != null && closestRange.to == selEnd) {
            this.mIsSelected = false;
        }
        if ((nearbyRange = this.getRangeOfNearbyMentionString(selStart, selEnd)) == null) {
            return;
        }
        if (selStart == selEnd) {
            this.setSelection(nearbyRange.getAnchorPosition(selStart));
        } else {
            if (selEnd < nearbyRange.to) {
                this.setSelection(selStart, nearbyRange.to);
            }
            if (selStart > nearbyRange.from) {
                this.setSelection(nearbyRange.from, selEnd);
            }
        }
    }

    public void setTIMMentionTextColor(int color2) {
        this.mTIMMentionTextColor = color2;
    }

    public List<String> getMentionList(boolean excludeMentionCharacter) {
        ArrayList<String> mentionList = new ArrayList<String>();
        if (TextUtils.isEmpty((CharSequence)this.getText().toString())) {
            return mentionList;
        }
        for (Map.Entry<String, Pattern> entry : this.mPatternMap.entrySet()) {
            Matcher matcher = entry.getValue().matcher(this.getText().toString());
            while (matcher.find()) {
                String mentionText = matcher.group();
                if (excludeMentionCharacter) {
                    mentionText = mentionText.substring(1, mentionText.length() - 1);
                }
                if (mentionList.contains(mentionText)) continue;
                mentionList.add(mentionText);
            }
        }
        return mentionList;
    }

    public void setOnMentionInputListener(OnMentionInputListener onMentionInputListener) {
        this.mOnMentionInputListener = onMentionInputListener;
    }

    private void init() {
        this.mPatternMap.clear();
        this.mPatternMap.put(TIM_METION_TAG, TIM_MENTION_PATTERN);
        this.addTextChangedListener(new MentionTextWatcher());
    }

    private void colorMentionString() {
        ForegroundColorSpan[] oldSpans;
        Editable spannableText;
        this.mIsSelected = false;
        if (this.mRangeArrayList != null) {
            this.mRangeArrayList.clear();
        }
        if ((spannableText = this.getText()) == null || TextUtils.isEmpty((CharSequence)spannableText.toString())) {
            return;
        }
        for (ForegroundColorSpan oldSpan : oldSpans = (ForegroundColorSpan[])spannableText.getSpans(0, spannableText.length(), ForegroundColorSpan.class)) {
            spannableText.removeSpan((Object)oldSpan);
        }
        String text = spannableText.toString();
        int lastMentionIndex = -1;
        for (Map.Entry<String, Pattern> entry : this.mPatternMap.entrySet()) {
            Matcher matcher = entry.getValue().matcher(text);
            while (matcher.find()) {
                String mentionText = matcher.group();
                int start = lastMentionIndex != -1 ? text.indexOf(mentionText, lastMentionIndex) : text.indexOf(mentionText);
                int end = start + mentionText.length();
                spannableText.setSpan(null, start, end, 33);
                lastMentionIndex = end;
                this.mRangeArrayList.add(new Range(start, end));
            }
        }
    }

    private Range getRangeOfClosestMentionString(int selStart, int selEnd) {
        if (this.mRangeArrayList == null) {
            return null;
        }
        for (Range range : this.mRangeArrayList) {
            if (!range.contains(selStart, selEnd)) continue;
            return range;
        }
        return null;
    }

    private Range getRangeOfNearbyMentionString(int selStart, int selEnd) {
        if (this.mRangeArrayList == null) {
            return null;
        }
        for (Range range : this.mRangeArrayList) {
            if (!range.isWrappedBy(selStart, selEnd)) continue;
            return range;
        }
        return null;
    }

    public static interface OnMentionInputListener {
        public void onMentionCharacterInput(String var1);
    }

    private class Range {
        int from;
        int to;

        Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        boolean isWrappedBy(int start, int end) {
            return start > this.from && start < this.to || end > this.from && end < this.to;
        }

        boolean contains(int start, int end) {
            return this.from <= start && this.to >= end;
        }

        boolean isEqual(int start, int end) {
            return this.from == start && this.to == end || this.from == end && this.to == start;
        }

        int getAnchorPosition(int value) {
            if (value - this.from - (this.to - value) >= 0) {
                return this.to;
            }
            return this.from;
        }
    }

    private class HackInputConnection
    extends InputConnectionWrapper {
        private EditText editText;

        HackInputConnection(InputConnection target, boolean mutable, TIMMentionEditText editText) {
            super(target, mutable);
            this.editText = editText;
        }

        public boolean sendKeyEvent(KeyEvent event) {
            if (event.getAction() == 0 && event.getKeyCode() == 67) {
                int selectionEnd;
                int selectionStart = this.editText.getSelectionStart();
                Range closestRange = TIMMentionEditText.this.getRangeOfClosestMentionString(selectionStart, selectionEnd = this.editText.getSelectionEnd());
                if (closestRange == null) {
                    TIMMentionEditText.this.mIsSelected = false;
                    return super.sendKeyEvent(event);
                }
                if (TIMMentionEditText.this.mIsSelected || selectionStart == closestRange.from) {
                    TIMMentionEditText.this.mIsSelected = false;
                    return super.sendKeyEvent(event);
                }
                TIMMentionEditText.this.mIsSelected = true;
                TIMMentionEditText.this.mLastSelectedRange = closestRange;
                this.setSelection(closestRange.to, closestRange.from);
                this.sendKeyEvent(new KeyEvent(0, 67));
                return true;
            }
            return super.sendKeyEvent(event);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (beforeLength == 1 && afterLength == 0) {
                return this.sendKeyEvent(new KeyEvent(0, 67)) && this.sendKeyEvent(new KeyEvent(1, 67));
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    private class MentionTextWatcher
    implements TextWatcher {
        private MentionTextWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int index, int i1, int count) {
            if (count == 1 && !TextUtils.isEmpty((CharSequence)charSequence)) {
                char mentionChar = charSequence.toString().charAt(index);
                for (Map.Entry entry : TIMMentionEditText.this.mPatternMap.entrySet()) {
                    if (!((String)entry.getKey()).equals(String.valueOf(mentionChar)) || TIMMentionEditText.this.mOnMentionInputListener == null) continue;
                    TIMMentionEditText.this.mOnMentionInputListener.onMentionCharacterInput((String)entry.getKey());
                }
            }
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

