/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.inputmore;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.inputmore.ActionsGridViewAdapter;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.inputmore.InputMoreActionUnit;
import java.util.ArrayList;
import java.util.List;

public class ActionsPagerAdapter
extends PagerAdapter {
    private final int ITEM_COUNT_PER_GRID_VIEW = 8;
    private final int COLUMN_COUNT = 4;
    private final Context mContext;
    private final List<InputMoreActionUnit> mInputMoreList;
    private final ViewPager mViewPager;
    private final int mGridViewCount;
    private int actionWidth;
    private int actionHeight;

    public ActionsPagerAdapter(ViewPager mViewPager, List<InputMoreActionUnit> mInputMoreList) {
        this.mContext = mViewPager.getContext();
        this.mInputMoreList = new ArrayList<InputMoreActionUnit>(mInputMoreList);
        this.mViewPager = mViewPager;
        this.mGridViewCount = (mInputMoreList.size() + 8 - 1) / 8;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int end = (position + 1) * 8 > this.mInputMoreList.size() ? this.mInputMoreList.size() : (position + 1) * 8;
        List<InputMoreActionUnit> subBaseActions = this.mInputMoreList.subList(position * 8, end);
        GridView gridView = new GridView(this.mContext);
        gridView.setAdapter((ListAdapter)new ActionsGridViewAdapter(this.mContext, subBaseActions));
        if (this.mInputMoreList.size() >= 4) {
            gridView.setNumColumns(4);
            container.post(new Runnable(){

                @Override
                public void run() {
                    ViewGroup.LayoutParams layoutParams = ActionsPagerAdapter.this.mViewPager.getLayoutParams();
                    layoutParams.height = ActionsPagerAdapter.this.actionHeight;
                    ActionsPagerAdapter.this.mViewPager.setLayoutParams(layoutParams);
                }
            });
        } else {
            gridView.setNumColumns(this.mInputMoreList.size());
            container.post(new Runnable(){

                @Override
                public void run() {
                    ViewGroup.LayoutParams layoutParams = ActionsPagerAdapter.this.mViewPager.getLayoutParams();
                    layoutParams.height = ActionsPagerAdapter.this.actionHeight;
                    ActionsPagerAdapter.this.mViewPager.setLayoutParams(layoutParams);
                }
            });
        }
        gridView.setSelector(R.color.transparent);
        gridView.setHorizontalSpacing(80);
        gridView.setVerticalSpacing(60);
        gridView.setGravity(17);
        gridView.setTag((Object)position);
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int index = (Integer)parent.getTag() * 8 + position;
                ((InputMoreActionUnit)ActionsPagerAdapter.this.mInputMoreList.get(index)).getOnClickListener().onClick(view);
            }
        });
        container.addView((View)gridView);
        return gridView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getCount() {
        return this.mGridViewCount;
    }

    public int getItemPosition(Object object) {
        return -2;
    }
}

