/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.PopupList;
import com.tencent.qcloud.tim.uikit.component.action.PopActionClickListener;
import com.tencent.qcloud.tim.uikit.component.action.PopMenuAction;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageLayoutUI;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageListAdapter;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import java.util.ArrayList;

public class MessageLayout
extends MessageLayoutUI {
    public static final int DATA_CHANGE_TYPE_REFRESH = 0;
    public static final int DATA_CHANGE_TYPE_LOAD = 1;
    public static final int DATA_CHANGE_TYPE_ADD_FRONT = 2;
    public static final int DATA_CHANGE_TYPE_ADD_BACK = 3;
    public static final int DATA_CHANGE_TYPE_UPDATE = 4;
    public static final int DATA_CHANGE_TYPE_DELETE = 5;
    public static final int DATA_CHANGE_TYPE_CLEAR = 6;

    public MessageLayout(Context context) {
        super(context);
    }

    public MessageLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MessageLayout(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (e.getAction() == 1) {
            View child = this.findChildViewUnder(e.getX(), e.getY());
            if (child == null) {
                if (this.mEmptySpaceClickListener != null) {
                    this.mEmptySpaceClickListener.onClick();
                }
            } else if (child instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)child;
                int count = group.getChildCount();
                float x = e.getRawX();
                float y = e.getRawY();
                View touchChild = null;
                for (int i = count - 1; i >= 0; --i) {
                    View innerChild = group.getChildAt(i);
                    int[] position = new int[2];
                    innerChild.getLocationOnScreen(position);
                    if (!(x >= (float)position[0]) || !(x <= (float)(position[0] + innerChild.getMeasuredWidth())) || !(y >= (float)position[1]) || !(y <= (float)(position[1] + innerChild.getMeasuredHeight()))) continue;
                    touchChild = innerChild;
                    break;
                }
                if (touchChild == null && this.mEmptySpaceClickListener != null) {
                    this.mEmptySpaceClickListener.onClick();
                }
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    public void showItemPopMenu(final int index, final MessageInfo messageInfo, View view) {
        this.initPopActions(messageInfo);
        if (this.mPopActions.size() == 0) {
            return;
        }
        final PopupList popupList = new PopupList(this.getContext());
        ArrayList<String> mItemList = new ArrayList<String>();
        for (PopMenuAction action : this.mPopActions) {
            mItemList.add(action.getActionName());
        }
        popupList.show(view, mItemList, new PopupList.PopupListListener(){

            @Override
            public boolean showPopupList(View adapterView, View contextView, int contextPosition) {
                return true;
            }

            @Override
            public void onPopupListClick(View contextView, int contextPosition, int position) {
                PopMenuAction action = (PopMenuAction)MessageLayout.this.mPopActions.get(position);
                if (action.getActionClickListener() != null) {
                    action.getActionClickListener().onActionClick(index, messageInfo);
                }
            }
        });
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (popupList != null) {
                    popupList.hidePopupListWindow();
                }
            }
        }, 10000L);
    }

    private void initPopActions(final MessageInfo msg) {
        if (msg == null) {
            return;
        }
        ArrayList<PopMenuAction> actions = new ArrayList<PopMenuAction>();
        PopMenuAction action = new PopMenuAction();
        if (msg.getMsgType() == 0) {
            action.setActionName(this.getContext().getString(R.string.copy_action));
            action.setActionClickListener(new PopActionClickListener(){

                @Override
                public void onActionClick(int position, Object data) {
                    MessageLayout.this.mOnPopActionClickListener.onCopyClick(position, (MessageInfo)data);
                }
            });
            actions.add(action);
        }
        action = new PopMenuAction();
        action.setActionName(this.getContext().getString(R.string.delete_action));
        action.setActionClickListener(new PopActionClickListener(){

            @Override
            public void onActionClick(int position, Object data) {
                MessageLayout.this.mOnPopActionClickListener.onDeleteMessageClick(position, (MessageInfo)data);
            }
        });
        actions.add(action);
        if (msg.isSelf()) {
            action = new PopMenuAction();
            action.setActionName(this.getContext().getString(R.string.revoke_action));
            action.setActionClickListener(new PopActionClickListener(){

                @Override
                public void onActionClick(int position, Object data) {
                    MessageLayout.this.mOnPopActionClickListener.onRevokeMessageClick(position, (MessageInfo)data);
                }
            });
            actions.add(action);
            if (msg.getStatus() == 3) {
                action = new PopMenuAction();
                action.setActionName(this.getContext().getString(R.string.resend_action));
                action.setActionClickListener(new PopActionClickListener(){

                    @Override
                    public void onActionClick(int position, Object data) {
                        MessageLayout.this.mOnPopActionClickListener.onSendMessageClick(msg, true);
                    }
                });
                actions.add(action);
            }
        }
        this.mPopActions.clear();
        this.mPopActions.addAll(actions);
        this.mPopActions.addAll(this.mMorePopActions);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0 && this.mHandler != null) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
            int firstPosition = layoutManager.findFirstCompletelyVisibleItemPosition();
            int lastPosition = layoutManager.findLastCompletelyVisibleItemPosition();
            if (firstPosition == 0 && lastPosition - firstPosition + 1 < this.getAdapter().getItemCount()) {
                if (this.getAdapter() instanceof MessageListAdapter) {
                    ((MessageListAdapter)this.getAdapter()).showLoading();
                }
                this.mHandler.loadMore();
            }
        }
    }

    public void scrollToEnd() {
        if (this.getAdapter() != null) {
            this.scrollToPosition(this.getAdapter().getItemCount() - 1);
        }
    }

    public OnLoadMoreHandler getLoadMoreHandler() {
        return this.mHandler;
    }

    public void setLoadMoreMessageHandler(OnLoadMoreHandler mHandler) {
        this.mHandler = mHandler;
    }

    public OnEmptySpaceClickListener getEmptySpaceClickListener() {
        return this.mEmptySpaceClickListener;
    }

    public void setEmptySpaceClickListener(OnEmptySpaceClickListener mEmptySpaceClickListener) {
        this.mEmptySpaceClickListener = mEmptySpaceClickListener;
    }

    public void setPopActionClickListener(OnPopActionClickListener listener) {
        this.mOnPopActionClickListener = listener;
    }

    @Override
    public void postSetAdapter(MessageListAdapter adapter) {
        this.mAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onMessageLongClick(View view, int position, MessageInfo messageInfo) {
                if (MessageLayout.this.mOnItemClickListener != null) {
                    MessageLayout.this.mOnItemClickListener.onMessageLongClick(view, position, messageInfo);
                }
            }

            @Override
            public void onUserIconClick(View view, int position, MessageInfo info) {
                if (MessageLayout.this.mOnItemClickListener != null) {
                    MessageLayout.this.mOnItemClickListener.onUserIconClick(view, position, info);
                }
            }
        });
    }

    public static interface OnPopActionClickListener {
        public void onCopyClick(int var1, MessageInfo var2);

        public void onSendMessageClick(MessageInfo var1, boolean var2);

        public void onDeleteMessageClick(int var1, MessageInfo var2);

        public void onRevokeMessageClick(int var1, MessageInfo var2);
    }

    public static interface OnItemClickListener {
        public void onMessageLongClick(View var1, int var2, MessageInfo var3);

        public void onUserIconClick(View var1, int var2, MessageInfo var3);
    }

    public static interface OnEmptySpaceClickListener {
        public void onClick();
    }

    public static interface OnLoadMoreHandler {
        public void loadMore();
    }
}

