/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.qcloud.tim.uikit.component.CustomLinearLayoutManager;
import com.tencent.qcloud.tim.uikit.component.action.PopMenuAction;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IMessageLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IMessageProperties;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageListAdapter;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IGroupMessageClickListener;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IOnCustomMessageDrawListener;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class MessageLayoutUI
extends RecyclerView
implements IMessageLayout {
    protected MessageLayout.OnItemClickListener mOnItemClickListener;
    protected MessageLayout.OnLoadMoreHandler mHandler;
    protected MessageLayout.OnEmptySpaceClickListener mEmptySpaceClickListener;
    protected MessageListAdapter mAdapter;
    protected List<PopMenuAction> mPopActions = new ArrayList<PopMenuAction>();
    protected List<PopMenuAction> mMorePopActions = new ArrayList<PopMenuAction>();
    protected MessageLayout.OnPopActionClickListener mOnPopActionClickListener;
    private Properties properties = Properties.getInstance();

    public MessageLayoutUI(Context context) {
        super(context);
        this.init();
    }

    public MessageLayoutUI(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MessageLayoutUI(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setLayoutFrozen(false);
        this.setItemViewCacheSize(0);
        this.setHasFixedSize(true);
        this.setFocusableInTouchMode(false);
        CustomLinearLayoutManager linearLayoutManager = new CustomLinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(1);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
    }

    @Override
    public int getAvatarRadius() {
        return this.properties.getAvatarRadius();
    }

    @Override
    public void setAvatarRadius(int radius) {
        this.properties.setAvatarRadius(radius);
    }

    @Override
    public int[] getAvatarSize() {
        return this.properties.avatarSize;
    }

    @Override
    public void setAvatarSize(int[] size) {
        this.properties.setAvatarSize(size);
    }

    @Override
    public int getAvatar() {
        return this.properties.getAvatar();
    }

    @Override
    public void setAvatar(int resId) {
        this.properties.setAvatar(resId);
    }

    @Override
    public Drawable getRightBubble() {
        return this.properties.getRightBubble();
    }

    @Override
    public void setRightBubble(Drawable bubble) {
        this.properties.setRightBubble(bubble);
    }

    @Override
    public Drawable getLeftBubble() {
        return this.properties.getLeftBubble();
    }

    @Override
    public void setLeftBubble(Drawable bubble) {
        this.properties.setLeftBubble(bubble);
    }

    @Override
    public int getNameFontSize() {
        return this.properties.getNameFontSize();
    }

    @Override
    public void setNameFontSize(int size) {
        this.properties.setNameFontSize(size);
    }

    @Override
    public int getNameFontColor() {
        return this.properties.getNameFontColor();
    }

    @Override
    public void setNameFontColor(int color2) {
        this.properties.setNameFontColor(color2);
    }

    @Override
    public int getLeftNameVisibility() {
        return this.properties.getLeftNameVisibility();
    }

    @Override
    public void setLeftNameVisibility(int visibility) {
        this.properties.setLeftNameVisibility(visibility);
    }

    @Override
    public int getRightNameVisibility() {
        return this.properties.getRightNameVisibility();
    }

    @Override
    public void setRightNameVisibility(int visibility) {
        this.properties.setRightNameVisibility(visibility);
    }

    @Override
    public int getChatContextFontSize() {
        return this.properties.getChatContextFontSize();
    }

    @Override
    public void setChatContextFontSize(int size) {
        this.properties.setChatContextFontSize(size);
    }

    @Override
    public int getRightChatContentFontColor() {
        return this.properties.getRightChatContentFontColor();
    }

    @Override
    public void setRightChatContentFontColor(int color2) {
        this.properties.setRightChatContentFontColor(color2);
    }

    @Override
    public int getLeftChatContentFontColor() {
        return this.properties.getLeftChatContentFontColor();
    }

    @Override
    public void setLeftChatContentFontColor(int color2) {
        this.properties.setLeftChatContentFontColor(color2);
    }

    @Override
    public Drawable getTipsMessageBubble() {
        return this.properties.getTipsMessageBubble();
    }

    @Override
    public void setTipsMessageBubble(Drawable bubble) {
        this.properties.setTipsMessageBubble(bubble);
    }

    @Override
    public int getTipsMessageFontSize() {
        return this.properties.getTipsMessageFontSize();
    }

    @Override
    public void setTipsMessageFontSize(int size) {
        this.properties.setTipsMessageFontSize(size);
    }

    @Override
    public int getTipsMessageFontColor() {
        return this.properties.getTipsMessageFontColor();
    }

    @Override
    public void setTipsMessageFontColor(int color2) {
        this.properties.setTipsMessageFontColor(color2);
    }

    @Override
    public Drawable getChatTimeBubble() {
        return this.properties.getChatTimeBubble();
    }

    @Override
    public void setChatTimeBubble(Drawable bubble) {
        this.properties.setChatTimeBubble(bubble);
    }

    @Override
    public int getChatTimeFontSize() {
        return this.properties.getChatTimeFontSize();
    }

    @Override
    public void setChatTimeFontSize(int size) {
        this.properties.setChatTimeFontSize(size);
    }

    @Override
    public int getChatTimeFontColor() {
        return this.properties.getChatTimeFontColor();
    }

    @Override
    public void setChatTimeFontColor(int color2) {
        this.properties.setChatTimeFontColor(color2);
    }

    @Override
    public void setOnCustomMessageDrawListener(IOnCustomMessageDrawListener listener) {
        this.mAdapter.setOnCustomMessageDrawListener(listener);
    }

    @Override
    public void setIGroupMessageClickListener(IGroupMessageClickListener listener) {
        this.mAdapter.setIGroupMessageClickListener(listener);
    }

    @Override
    public MessageLayout.OnItemClickListener getOnItemClickListener() {
        return this.mAdapter.getOnItemClickListener();
    }

    @Override
    public void setOnItemClickListener(MessageLayout.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        this.mAdapter.setOnItemClickListener(listener);
    }

    @Override
    public void setAdapter(MessageListAdapter adapter) {
        super.setAdapter((RecyclerView.Adapter)adapter);
        this.mAdapter = adapter;
        this.postSetAdapter(adapter);
    }

    protected abstract void postSetAdapter(MessageListAdapter var1);

    @Override
    public List<PopMenuAction> getPopActions() {
        return this.mPopActions;
    }

    @Override
    public void addPopAction(PopMenuAction action) {
        this.mMorePopActions.add(action);
    }

    public static class Properties
    implements IMessageProperties {
        private static Properties sP = new Properties();
        private int mAvatarId;
        private int mAvatarRadius;
        private int[] avatarSize = null;
        private int mNameFontSize;
        private int mNameFontColor;
        private int mLeftNameVisibility;
        private int mRightNameVisibility;
        private int mChatContextFontSize;
        private int mMyChatContentFontColor;
        private Drawable mMyBubble;
        private int mFriendChatContentFontColor;
        private Drawable mFriendBubble;
        private int mTipsMessageFontSize;
        private int mTipsMessageFontColor;
        private Drawable mTipsMessageBubble;
        private int mChatTimeFontSize;
        private int mChatTimeFontColor;
        private Drawable mChatTimeBubble;

        private Properties() {
        }

        public static Properties getInstance() {
            if (sP == null) {
                sP = new Properties();
            }
            return sP;
        }

        @Override
        public int getAvatarRadius() {
            return this.mAvatarRadius;
        }

        @Override
        public void setAvatarRadius(int radius) {
            this.mAvatarRadius = ScreenUtil.getPxByDp(radius);
        }

        @Override
        public int[] getAvatarSize() {
            return this.avatarSize;
        }

        @Override
        public void setAvatarSize(int[] size) {
            if (size != null && size.length == 2) {
                this.avatarSize = new int[2];
                this.avatarSize[0] = ScreenUtil.getPxByDp(size[0]);
                this.avatarSize[1] = ScreenUtil.getPxByDp(size[1]);
            }
        }

        @Override
        public int getAvatar() {
            return this.mAvatarId;
        }

        @Override
        public void setAvatar(int resId) {
            this.mAvatarId = resId;
        }

        @Override
        public Drawable getRightBubble() {
            return this.mMyBubble;
        }

        @Override
        public void setRightBubble(Drawable bubble) {
            this.mMyBubble = bubble;
        }

        @Override
        public Drawable getLeftBubble() {
            return this.mFriendBubble;
        }

        @Override
        public void setLeftBubble(Drawable bubble) {
            this.mFriendBubble = bubble;
        }

        @Override
        public int getNameFontSize() {
            return this.mNameFontSize;
        }

        @Override
        public void setNameFontSize(int size) {
            this.mNameFontSize = size;
        }

        @Override
        public int getNameFontColor() {
            return this.mNameFontColor;
        }

        @Override
        public void setNameFontColor(int color2) {
            this.mNameFontColor = color2;
        }

        @Override
        public int getLeftNameVisibility() {
            return this.mLeftNameVisibility;
        }

        @Override
        public void setLeftNameVisibility(int visibility) {
            this.mLeftNameVisibility = visibility;
        }

        @Override
        public int getRightNameVisibility() {
            return this.mRightNameVisibility;
        }

        @Override
        public void setRightNameVisibility(int visibility) {
            this.mRightNameVisibility = visibility;
        }

        @Override
        public int getChatContextFontSize() {
            return this.mChatContextFontSize;
        }

        @Override
        public void setChatContextFontSize(int size) {
            this.mChatContextFontSize = size;
        }

        @Override
        public int getRightChatContentFontColor() {
            return this.mMyChatContentFontColor;
        }

        @Override
        public void setRightChatContentFontColor(int color2) {
            this.mMyChatContentFontColor = color2;
        }

        @Override
        public int getLeftChatContentFontColor() {
            return this.mFriendChatContentFontColor;
        }

        @Override
        public void setLeftChatContentFontColor(int color2) {
            this.mFriendChatContentFontColor = color2;
        }

        @Override
        public Drawable getTipsMessageBubble() {
            return this.mTipsMessageBubble;
        }

        @Override
        public void setTipsMessageBubble(Drawable bubble) {
            this.mTipsMessageBubble = bubble;
        }

        @Override
        public int getTipsMessageFontSize() {
            return this.mTipsMessageFontSize;
        }

        @Override
        public void setTipsMessageFontSize(int size) {
            this.mTipsMessageFontSize = size;
        }

        @Override
        public int getTipsMessageFontColor() {
            return this.mTipsMessageFontColor;
        }

        @Override
        public void setTipsMessageFontColor(int color2) {
            this.mTipsMessageFontColor = color2;
        }

        @Override
        public Drawable getChatTimeBubble() {
            return this.mChatTimeBubble;
        }

        @Override
        public void setChatTimeBubble(Drawable bubble) {
            this.mChatTimeBubble = bubble;
        }

        @Override
        public int getChatTimeFontSize() {
            return this.mChatTimeFontSize;
        }

        @Override
        public void setChatTimeFontSize(int size) {
            this.mChatTimeFontSize = size;
        }

        @Override
        public int getChatTimeFontColor() {
            return this.mChatTimeFontColor;
        }

        @Override
        public void setChatTimeFontColor(int color2) {
            this.mChatTimeFontColor = color2;
        }
    }
}

