/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.qcloud.tim.uikit.modules.chat.interfaces.IChatProvider;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.MessageLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.GroupMessageHelper;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IGroupMessageClickListener;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IOnCustomMessageDrawListener;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageBaseHolder;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageContentHolder;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageCustomHolder;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageHeaderHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import java.util.ArrayList;
import java.util.List;

public class MessageListAdapter
extends RecyclerView.Adapter {
    public static final int MSG_TYPE_HEADER_VIEW = -99;
    private static final String TAG = MessageListAdapter.class.getSimpleName();
    private boolean mLoading = true;
    private MessageLayout mRecycleView;
    private List<MessageInfo> mDataSource = new ArrayList<MessageInfo>();
    private MessageLayout.OnItemClickListener mOnItemClickListener;
    private IOnCustomMessageDrawListener mOnCustomMessageDrawListener;
    private IGroupMessageClickListener mIGroupMessageClickListener;

    public void setOnCustomMessageDrawListener(IOnCustomMessageDrawListener listener) {
        this.mOnCustomMessageDrawListener = listener;
    }

    public void setIGroupMessageClickListener(IGroupMessageClickListener IGroupMessageClickListener2) {
        this.mIGroupMessageClickListener = IGroupMessageClickListener2;
    }

    public MessageLayout.OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(MessageLayout.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder = MessageBaseHolder.Factory.getInstance(parent, this, viewType);
        return holder;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        MessageInfo msg = this.getItem(position);
        MessageBaseHolder baseHolder = (MessageBaseHolder)holder;
        baseHolder.setOnItemClickListener(this.mOnItemClickListener);
        switch (this.getItemViewType(position)) {
            case -99: {
                ((MessageHeaderHolder)baseHolder).setLoadingStatus(this.mLoading);
                break;
            }
            case 0: 
            case 32: 
            case 48: 
            case 64: 
            case 80: 
            case 112: {
                break;
            }
        }
        baseHolder.layoutViews(msg, position);
        if (this.getItemViewType(position) == 128) {
            MessageCustomHolder customHolder = (MessageCustomHolder)holder;
            if (MessageInfoUtil.isLive(msg)) {
                new GroupMessageHelper(this.mIGroupMessageClickListener).onDraw(customHolder, msg);
            } else if (this.mOnCustomMessageDrawListener != null) {
                this.mOnCustomMessageDrawListener.onDraw(customHolder, msg);
            }
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecycleView = (MessageLayout)recyclerView;
        this.mRecycleView.setItemViewCacheSize(5);
    }

    public void showLoading() {
        if (this.mLoading) {
            return;
        }
        this.mLoading = true;
        this.notifyItemChanged(0);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof MessageContentHolder) {
            ((MessageContentHolder)holder).msgContentFrame.setBackground(null);
        }
    }

    public void notifyDataSourceChanged(final int type, final int value) {
        BackgroundTasks.getInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                MessageListAdapter.this.mLoading = false;
                if (type == 0) {
                    MessageListAdapter.this.notifyDataSetChanged();
                    MessageListAdapter.this.mRecycleView.scrollToEnd();
                } else if (type == 3) {
                    MessageListAdapter.this.notifyItemRangeInserted(MessageListAdapter.this.mDataSource.size() + 1, value);
                    MessageListAdapter.this.notifyDataSetChanged();
                    MessageListAdapter.this.mRecycleView.scrollToEnd();
                } else if (type == 4) {
                    MessageListAdapter.this.notifyItemChanged(value + 1);
                } else if (type == 1 || type == 2) {
                    if (value == 0) {
                        MessageListAdapter.this.notifyItemChanged(0);
                    } else if (MessageListAdapter.this.getItemCount() > value) {
                        MessageListAdapter.this.notifyItemRangeInserted(0, value);
                    } else {
                        MessageListAdapter.this.notifyItemRangeInserted(0, value);
                    }
                } else if (type == 5) {
                    MessageListAdapter.this.notifyItemRemoved(value + 1);
                    MessageListAdapter.this.notifyDataSetChanged();
                    MessageListAdapter.this.mRecycleView.scrollToEnd();
                }
            }
        }, 100L);
    }

    public int getItemCount() {
        return this.mDataSource.size() + 1;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return -99;
        }
        MessageInfo msg = this.getItem(position);
        return msg.getMsgType();
    }

    public void setDataSource(IChatProvider provider) {
        if (provider == null) {
            this.mDataSource.clear();
        } else {
            this.mDataSource = provider.getDataSource();
            provider.setAdapter(this);
        }
        this.notifyDataSourceChanged(0, this.getItemCount());
    }

    public MessageInfo getItem(int position) {
        if (position == 0 || this.mDataSource.size() == 0) {
            return null;
        }
        MessageInfo info = this.mDataSource.get(position - 1);
        return info;
    }
}

