/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMCustomElem;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.ICustomMessageViewGroup;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IGroupMessageClickListener;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.IOnCustomMessageDrawListener;
import com.tencent.qcloud.tim.uikit.modules.message.LiveMessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;

public class GroupMessageHelper
implements IOnCustomMessageDrawListener {
    public static final String ROOM_TITLE = "room_title";
    public static final String GROUP_ID = "group_id";
    public static final String USE_CDN_PLAY = "use_cdn_play";
    public static final String ANCHOR_ID = "anchor_id";
    public static final String PUSHER_NAME = "pusher_name";
    public static final String COVER_PIC = "cover_pic";
    public static final String PUSHER_AVATAR = "pusher_avatar";
    private IGroupMessageClickListener mIGroupMessageClickListener;

    public GroupMessageHelper(IGroupMessageClickListener IGroupMessageClickListener2) {
        this.mIGroupMessageClickListener = IGroupMessageClickListener2;
    }

    @Override
    public void onDraw(ICustomMessageViewGroup parent, final MessageInfo messageInfo) {
        if (messageInfo.getTimMessage().getElemType() != 2) {
            return;
        }
        V2TIMCustomElem elem = messageInfo.getTimMessage().getCustomElem();
        final LiveMessageInfo info = (LiveMessageInfo)new Gson().fromJson(new String(elem.getData()), LiveMessageInfo.class);
        View view = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.message_adapter_content_trtc, null, false);
        parent.addMessageContentView(view);
        TextView textLiveName = (TextView)view.findViewById(R.id.msg_tv_live_name);
        TextView textStatus = (TextView)view.findViewById(R.id.msg_tv_live_status);
        if (info != null) {
            if (!TextUtils.isEmpty((CharSequence)info.anchorName)) {
                textLiveName.setText((CharSequence)TUIKit.getAppContext().getString(R.string.live_group_user_live, new Object[]{info.anchorName}));
            } else {
                textLiveName.setText((CharSequence)info.roomName);
            }
            textStatus.setText((CharSequence)(info.roomStatus == 1 ? this.getString(R.string.live_group_live_streaming) : this.getString(R.string.live_group_live_end)));
        }
        view.setClickable(true);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GroupMessageHelper.this.mIGroupMessageClickListener != null) {
                    boolean isHandleByUser = GroupMessageHelper.this.mIGroupMessageClickListener.handleLiveMessage(info, messageInfo.isGroup() ? messageInfo.getTimMessage().getGroupID() : "");
                    if (!isHandleByUser) {
                        GroupMessageHelper.this.startDefaultGroupLiveAudience(info);
                    }
                } else {
                    GroupMessageHelper.this.startDefaultGroupLiveAudience(info);
                }
            }
        });
    }

    private void startDefaultGroupLiveAudience(LiveMessageInfo info) {
        Intent intent = new Intent();
        intent.setAction("com.tencent.qcloud.tim.tuikit.live.grouplive.audience");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.putExtra(ROOM_TITLE, info.roomName);
        intent.putExtra(GROUP_ID, info.roomId);
        intent.putExtra(USE_CDN_PLAY, false);
        intent.putExtra(ANCHOR_ID, info.anchorId);
        intent.putExtra(PUSHER_NAME, info.anchorName);
        intent.putExtra(COVER_PIC, info.roomCover);
        intent.putExtra(PUSHER_AVATAR, info.roomCover);
        TUIKit.getAppContext().startActivity(intent);
    }

    private String getString(@StringRes int stringId) {
        return TUIKit.getAppContext().getString(stringId);
    }
}

