/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.graphics.drawable.AnimationDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMSoundElem;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.AudioPlayer;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageContentHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.File;

public class MessageAudioHolder
extends MessageContentHolder {
    private static final int AUDIO_MIN_WIDTH = ScreenUtil.getPxByDp(60.0f);
    private static final int AUDIO_MAX_WIDTH = ScreenUtil.getPxByDp(250.0f);
    private static final int UNREAD = 0;
    private static final int READ = 1;
    private TextView audioTimeText;
    private ImageView audioPlayImage;
    private LinearLayout audioContentView;

    public MessageAudioHolder(View itemView) {
        super(itemView);
    }

    @Override
    public int getVariableLayout() {
        return R.layout.message_adapter_content_audio;
    }

    @Override
    public void initVariableViews() {
        this.audioTimeText = (TextView)this.rootView.findViewById(R.id.audio_time_tv);
        this.audioPlayImage = (ImageView)this.rootView.findViewById(R.id.audio_play_iv);
        this.audioContentView = (LinearLayout)this.rootView.findViewById(R.id.audio_content_ll);
    }

    @Override
    public void layoutVariableViews(final MessageInfo msg, int position) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        if (msg.isSelf()) {
            params.addRule(11);
            params.rightMargin = 24;
            this.audioPlayImage.setImageResource(R.drawable.voice_msg_playing_3);
            this.audioPlayImage.setRotation(180.0f);
            this.audioContentView.removeView((View)this.audioPlayImage);
            this.audioContentView.addView((View)this.audioPlayImage);
            this.unreadAudioText.setVisibility(8);
        } else {
            params.addRule(9);
            params.leftMargin = 24;
            this.audioPlayImage.setImageResource(R.drawable.voice_msg_playing_3);
            this.audioContentView.removeView((View)this.audioPlayImage);
            this.audioContentView.addView((View)this.audioPlayImage, 0);
            if (msg.getCustomInt() == 0) {
                LinearLayout.LayoutParams unreadParams = (LinearLayout.LayoutParams)this.isReadText.getLayoutParams();
                unreadParams.gravity = 16;
                unreadParams.leftMargin = 10;
                this.unreadAudioText.setVisibility(0);
                this.unreadAudioText.setLayoutParams((ViewGroup.LayoutParams)unreadParams);
            } else {
                this.unreadAudioText.setVisibility(8);
            }
        }
        this.audioContentView.setLayoutParams((ViewGroup.LayoutParams)params);
        V2TIMMessage timMessage = msg.getTimMessage();
        if (timMessage.getElemType() != 4) {
            return;
        }
        V2TIMSoundElem soundElem = timMessage.getSoundElem();
        int duration = soundElem.getDuration();
        if (duration == 0) {
            duration = 1;
        }
        if (TextUtils.isEmpty((CharSequence)msg.getDataPath())) {
            this.getSound(msg, soundElem);
        }
        ViewGroup.LayoutParams audioParams = this.msgContentFrame.getLayoutParams();
        audioParams.width = AUDIO_MIN_WIDTH + ScreenUtil.getPxByDp(duration * 6);
        if (audioParams.width > AUDIO_MAX_WIDTH) {
            audioParams.width = AUDIO_MAX_WIDTH;
        }
        this.msgContentFrame.setLayoutParams(audioParams);
        this.audioTimeText.setText((CharSequence)(duration + "''"));
        this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AudioPlayer.getInstance().isPlaying()) {
                    AudioPlayer.getInstance().stopPlay();
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)msg.getDataPath())) {
                    ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.voice_play_tip));
                    return;
                }
                MessageAudioHolder.this.audioPlayImage.setImageResource(R.drawable.play_voice_message);
                if (msg.isSelf()) {
                    MessageAudioHolder.this.audioPlayImage.setRotation(180.0f);
                }
                final AnimationDrawable animationDrawable = (AnimationDrawable)MessageAudioHolder.this.audioPlayImage.getDrawable();
                animationDrawable.start();
                msg.setCustomInt(1);
                MessageAudioHolder.this.unreadAudioText.setVisibility(8);
                AudioPlayer.getInstance().startPlay(msg.getDataPath(), new AudioPlayer.Callback(){

                    @Override
                    public void onCompletion(Boolean success) {
                        MessageAudioHolder.this.audioPlayImage.post(new Runnable(){

                            @Override
                            public void run() {
                                animationDrawable.stop();
                                MessageAudioHolder.this.audioPlayImage.setImageResource(R.drawable.voice_msg_playing_3);
                                if (msg.isSelf()) {
                                    MessageAudioHolder.this.audioPlayImage.setRotation(180.0f);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void getSound(final MessageInfo msgInfo, V2TIMSoundElem soundElemEle) {
        final String path = TUIKitConstants.RECORD_DOWNLOAD_DIR + soundElemEle.getUUID();
        File file = new File(path);
        if (!file.exists()) {
            soundElemEle.downloadSound(path, new V2TIMDownloadCallback(){

                public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                    TUIKitLog.i("downloadSound progress current:", progressInfo.getCurrentSize() + ", total:" + progressInfo.getTotalSize());
                }

                public void onError(int code, String desc) {
                    TUIKitLog.e("getSoundToFile failed code = ", code + ", info = " + desc);
                }

                public void onSuccess() {
                    msgInfo.setDataPath(path);
                }
            });
        } else {
            msgInfo.setDataPath(path);
        }
    }
}

