/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.gatherimage.UserIconView;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageEmptyHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import java.util.ArrayList;

public abstract class MessageContentHolder
extends MessageEmptyHolder {
    public UserIconView leftUserIcon;
    public UserIconView rightUserIcon;
    public TextView usernameText;
    public LinearLayout msgContentLinear;
    public ProgressBar sendingProgress;
    public ImageView statusImage;
    public TextView isReadText;
    public TextView unreadAudioText;

    public MessageContentHolder(View itemView) {
        super(itemView);
        this.rootView = itemView;
        this.leftUserIcon = (UserIconView)itemView.findViewById(R.id.left_user_icon_view);
        this.rightUserIcon = (UserIconView)itemView.findViewById(R.id.right_user_icon_view);
        this.usernameText = (TextView)itemView.findViewById(R.id.user_name_tv);
        this.msgContentLinear = (LinearLayout)itemView.findViewById(R.id.msg_content_ll);
        this.statusImage = (ImageView)itemView.findViewById(R.id.message_status_iv);
        this.sendingProgress = (ProgressBar)itemView.findViewById(R.id.message_sending_pb);
        this.isReadText = (TextView)itemView.findViewById(R.id.is_read_tv);
        this.unreadAudioText = (TextView)itemView.findViewById(R.id.audio_unread);
    }

    @Override
    public void layoutViews(final MessageInfo msg, final int position) {
        V2TIMMessage timMessage;
        super.layoutViews(msg, position);
        if (msg.isSelf()) {
            this.leftUserIcon.setVisibility(8);
            this.rightUserIcon.setVisibility(0);
        } else {
            this.leftUserIcon.setVisibility(0);
            this.rightUserIcon.setVisibility(8);
        }
        if (this.properties.getAvatar() != 0) {
            this.leftUserIcon.setDefaultImageResId(this.properties.getAvatar());
            this.rightUserIcon.setDefaultImageResId(this.properties.getAvatar());
        } else {
            this.leftUserIcon.setDefaultImageResId(R.drawable.default_head);
            this.rightUserIcon.setDefaultImageResId(R.drawable.default_head);
        }
        if (this.properties.getAvatarRadius() != 0) {
            this.leftUserIcon.setRadius(this.properties.getAvatarRadius());
            this.rightUserIcon.setRadius(this.properties.getAvatarRadius());
        } else {
            this.leftUserIcon.setRadius(5);
            this.rightUserIcon.setRadius(5);
        }
        if (this.properties.getAvatarSize() != null && this.properties.getAvatarSize().length == 2) {
            ViewGroup.LayoutParams params = this.leftUserIcon.getLayoutParams();
            params.width = this.properties.getAvatarSize()[0];
            params.height = this.properties.getAvatarSize()[1];
            this.leftUserIcon.setLayoutParams(params);
            params = this.rightUserIcon.getLayoutParams();
            params.width = this.properties.getAvatarSize()[0];
            params.height = this.properties.getAvatarSize()[1];
            this.rightUserIcon.setLayoutParams(params);
        }
        this.leftUserIcon.invokeInformation(msg);
        this.rightUserIcon.invokeInformation(msg);
        if (msg.isSelf()) {
            if (this.properties.getRightNameVisibility() == 0) {
                this.usernameText.setVisibility(8);
            } else {
                this.usernameText.setVisibility(this.properties.getRightNameVisibility());
            }
        } else if (this.properties.getLeftNameVisibility() == 0) {
            if (msg.isGroup()) {
                this.usernameText.setVisibility(0);
            } else {
                this.usernameText.setVisibility(8);
            }
        } else {
            this.usernameText.setVisibility(this.properties.getLeftNameVisibility());
        }
        if (this.properties.getNameFontColor() != 0) {
            this.usernameText.setTextColor(this.properties.getNameFontColor());
        }
        if (this.properties.getNameFontSize() != 0) {
            this.usernameText.setTextSize((float)this.properties.getNameFontSize());
        }
        if (!TextUtils.isEmpty((CharSequence)(timMessage = msg.getTimMessage()).getNameCard())) {
            this.usernameText.setText((CharSequence)timMessage.getNameCard());
        } else if (!TextUtils.isEmpty((CharSequence)timMessage.getFriendRemark())) {
            this.usernameText.setText((CharSequence)timMessage.getFriendRemark());
        } else if (!TextUtils.isEmpty((CharSequence)timMessage.getNickName())) {
            this.usernameText.setText((CharSequence)timMessage.getNickName());
        } else {
            this.usernameText.setText((CharSequence)timMessage.getSender());
        }
        if (!TextUtils.isEmpty((CharSequence)timMessage.getFaceUrl())) {
            ArrayList<Object> urllist = new ArrayList<Object>();
            urllist.add(timMessage.getFaceUrl());
            if (msg.isSelf()) {
                this.rightUserIcon.setIconUrls(urllist);
            } else {
                this.leftUserIcon.setIconUrls(urllist);
            }
        }
        if (msg.isSelf()) {
            if (msg.getStatus() == 3 || msg.getStatus() == 2 || msg.isPeerRead()) {
                this.sendingProgress.setVisibility(8);
            } else {
                this.sendingProgress.setVisibility(0);
            }
        } else {
            this.sendingProgress.setVisibility(8);
        }
        if (msg.isSelf()) {
            if (this.properties.getRightBubble() != null && this.properties.getRightBubble().getConstantState() != null) {
                this.msgContentFrame.setBackground(this.properties.getRightBubble().getConstantState().newDrawable());
            } else {
                this.msgContentFrame.setBackgroundResource(R.drawable.chat_bubble_myself);
            }
        } else if (this.properties.getLeftBubble() != null && this.properties.getLeftBubble().getConstantState() != null) {
            this.msgContentFrame.setBackground(this.properties.getLeftBubble().getConstantState().newDrawable());
            this.msgContentFrame.setLayoutParams(this.msgContentFrame.getLayoutParams());
        } else {
            this.msgContentFrame.setBackgroundResource(R.drawable.chat_other_bg);
        }
        if (this.onItemClickListener != null) {
            this.msgContentFrame.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    MessageContentHolder.this.onItemClickListener.onMessageLongClick(v, position, msg);
                    return true;
                }
            });
            this.leftUserIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MessageContentHolder.this.onItemClickListener.onUserIconClick(view, position, msg);
                }
            });
            this.rightUserIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MessageContentHolder.this.onItemClickListener.onUserIconClick(view, position, msg);
                }
            });
        }
        if (msg.getStatus() == 3) {
            this.statusImage.setVisibility(0);
            this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MessageContentHolder.this.onItemClickListener != null) {
                        MessageContentHolder.this.onItemClickListener.onMessageLongClick((View)MessageContentHolder.this.msgContentFrame, position, msg);
                    }
                }
            });
        } else {
            this.msgContentFrame.setOnClickListener(null);
            this.statusImage.setVisibility(8);
        }
        if (msg.isSelf()) {
            this.msgContentLinear.removeView((View)this.msgContentFrame);
            this.msgContentLinear.addView((View)this.msgContentFrame);
        } else {
            this.msgContentLinear.removeView((View)this.msgContentFrame);
            this.msgContentLinear.addView((View)this.msgContentFrame, 0);
        }
        this.msgContentLinear.setVisibility(0);
        if (TUIKitConfigs.getConfigs().getGeneralConfig().isShowRead()) {
            if (msg.isSelf() && 2 == msg.getStatus()) {
                if (msg.isGroup()) {
                    this.isReadText.setVisibility(8);
                } else {
                    this.isReadText.setVisibility(0);
                    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.isReadText.getLayoutParams();
                    params.gravity = 16;
                    this.isReadText.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (msg.isPeerRead()) {
                        this.isReadText.setText(R.string.has_read);
                    } else {
                        this.isReadText.setText(R.string.unread);
                    }
                }
            } else {
                this.isReadText.setVisibility(8);
            }
        }
        this.unreadAudioText.setVisibility(8);
        this.layoutVariableViews(msg, position);
    }

    public abstract void layoutVariableViews(MessageInfo var1, int var2);
}

