/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.ICustomMessageViewGroup;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageContentHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;

public class MessageCustomHolder
extends MessageContentHolder
implements ICustomMessageViewGroup {
    private MessageInfo mMessageInfo;
    private int mPosition;
    private TextView msgBodyText;

    public MessageCustomHolder(View itemView) {
        super(itemView);
    }

    @Override
    public int getVariableLayout() {
        return R.layout.message_adapter_content_text;
    }

    @Override
    public void initVariableViews() {
        this.msgBodyText = (TextView)this.rootView.findViewById(R.id.msg_body_tv);
    }

    @Override
    public void layoutViews(MessageInfo msg, int position) {
        this.mMessageInfo = msg;
        this.mPosition = position;
        super.layoutViews(msg, position);
    }

    @Override
    public void layoutVariableViews(MessageInfo msg, int position) {
        boolean live;
        this.msgContentFrame.removeAllViews();
        if (this.msgBodyText.getParent() != null) {
            ((ViewGroup)this.msgBodyText.getParent()).removeView((View)this.msgBodyText);
        }
        this.msgContentFrame.addView((View)this.msgBodyText);
        this.msgBodyText.setVisibility(0);
        if (msg.getExtra() != null) {
            if (TextUtils.equals((CharSequence)TUIKit.getAppContext().getString(R.string.custom_msg), (CharSequence)msg.getExtra().toString())) {
                this.msgBodyText.setText((CharSequence)Html.fromHtml((String)TUIKitConstants.covert2HTMLString(TUIKit.getAppContext().getString(R.string.no_support_custom_msg))));
            } else {
                this.msgBodyText.setText((CharSequence)msg.getExtra().toString());
            }
        }
        if (this.properties.getChatContextFontSize() != 0) {
            this.msgBodyText.setTextSize((float)this.properties.getChatContextFontSize());
        }
        if (msg.isSelf()) {
            if (this.properties.getRightChatContentFontColor() != 0) {
                this.msgBodyText.setTextColor(this.properties.getRightChatContentFontColor());
            }
        } else if (this.properties.getLeftChatContentFontColor() != 0) {
            this.msgBodyText.setTextColor(this.properties.getLeftChatContentFontColor());
        }
        if (live = MessageInfoUtil.isLive(msg)) {
            ViewGroup.LayoutParams msgContentLinearParams = this.msgContentLinear.getLayoutParams();
            msgContentLinearParams.width = -2;
            this.msgContentLinear.setLayoutParams(msgContentLinearParams);
            LinearLayout.LayoutParams msgContentFrameParams = (LinearLayout.LayoutParams)this.msgContentFrame.getLayoutParams();
            msgContentFrameParams.width = ScreenUtil.dip2px(220.0f);
            msgContentFrameParams.gravity = 0x800005;
            this.msgContentFrame.setLayoutParams((ViewGroup.LayoutParams)msgContentFrameParams);
            if (msg.isSelf()) {
                this.msgContentFrame.setBackgroundResource(R.drawable.chat_right_live_group_bg);
            } else {
                this.msgContentFrame.setBackgroundResource(R.drawable.chat_left_live_group_bg);
            }
            this.isReadText.setVisibility(4);
        }
    }

    private void hideAll() {
        for (int i = 0; i < ((RelativeLayout)this.rootView).getChildCount(); ++i) {
            ((RelativeLayout)this.rootView).getChildAt(i).setVisibility(8);
        }
    }

    @Override
    public void addMessageItemView(View view) {
        this.hideAll();
        if (view != null) {
            ((RelativeLayout)this.rootView).removeView(view);
            ((RelativeLayout)this.rootView).addView(view);
        }
    }

    @Override
    public void addMessageContentView(View view) {
        this.hideAll();
        super.layoutViews(this.mMessageInfo, this.mPosition);
        if (view != null) {
            for (int i = 0; i < this.msgContentFrame.getChildCount(); ++i) {
                this.msgContentFrame.getChildAt(i).setVisibility(8);
            }
            this.msgContentFrame.removeView(view);
            this.msgContentFrame.addView(view);
        }
    }
}

