/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageBaseHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.DateTimeUtil;
import java.util.Date;

public abstract class MessageEmptyHolder
extends MessageBaseHolder {
    public TextView chatTimeText;
    public FrameLayout msgContentFrame;

    public MessageEmptyHolder(View itemView) {
        super(itemView);
        this.rootView = itemView;
        this.chatTimeText = (TextView)itemView.findViewById(R.id.chat_time_tv);
        this.msgContentFrame = (FrameLayout)itemView.findViewById(R.id.msg_content_fl);
        this.initVariableLayout();
    }

    public abstract int getVariableLayout();

    private void setVariableLayout(int resId) {
        if (this.msgContentFrame.getChildCount() == 0) {
            View.inflate((Context)this.rootView.getContext(), (int)resId, (ViewGroup)this.msgContentFrame);
        }
        this.initVariableViews();
    }

    private void initVariableLayout() {
        if (this.getVariableLayout() != 0) {
            this.setVariableLayout(this.getVariableLayout());
        }
    }

    public abstract void initVariableViews();

    @Override
    public void layoutViews(MessageInfo msg, int position) {
        if (this.properties.getChatTimeBubble() != null) {
            this.chatTimeText.setBackground(this.properties.getChatTimeBubble());
        }
        if (this.properties.getChatTimeFontColor() != 0) {
            this.chatTimeText.setTextColor(this.properties.getChatTimeFontColor());
        }
        if (this.properties.getChatTimeFontSize() != 0) {
            this.chatTimeText.setTextSize((float)this.properties.getChatTimeFontSize());
        }
        if (position > 1) {
            MessageInfo last = this.mAdapter.getItem(position - 1);
            if (last != null) {
                if (msg.getMsgTime() - last.getMsgTime() >= 300L) {
                    this.chatTimeText.setVisibility(0);
                    this.chatTimeText.setText((CharSequence)DateTimeUtil.getTimeFormatText(new Date(msg.getMsgTime() * 1000L)));
                } else {
                    this.chatTimeText.setVisibility(8);
                }
            }
        } else {
            this.chatTimeText.setVisibility(0);
            this.chatTimeText.setText((CharSequence)DateTimeUtil.getTimeFormatText(new Date(msg.getMsgTime() * 1000L)));
        }
    }
}

