/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMFileElem;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageContentHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public class MessageFileHolder
extends MessageContentHolder {
    private TextView fileNameText;
    private TextView fileSizeText;
    private TextView fileStatusText;
    private ImageView fileIconImage;

    public MessageFileHolder(View itemView) {
        super(itemView);
    }

    @Override
    public int getVariableLayout() {
        return R.layout.message_adapter_content_file;
    }

    @Override
    public void initVariableViews() {
        this.fileNameText = (TextView)this.rootView.findViewById(R.id.file_name_tv);
        this.fileSizeText = (TextView)this.rootView.findViewById(R.id.file_size_tv);
        this.fileStatusText = (TextView)this.rootView.findViewById(R.id.file_status_tv);
        this.fileIconImage = (ImageView)this.rootView.findViewById(R.id.file_icon_iv);
    }

    @Override
    public void layoutVariableViews(final MessageInfo msg, int position) {
        V2TIMMessage message = msg.getTimMessage();
        if (message.getElemType() != 6) {
            return;
        }
        final V2TIMFileElem fileElem = message.getFileElem();
        final String path = msg.getDataPath();
        this.fileNameText.setText((CharSequence)fileElem.getFileName());
        String size = FileUtil.FormetFileSize(fileElem.getFileSize());
        this.fileSizeText.setText((CharSequence)size);
        this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.file_path) + path);
            }
        });
        if (msg.getStatus() == 2 || msg.getStatus() == 0) {
            this.fileStatusText.setText(R.string.sended);
        } else if (msg.getStatus() == 4) {
            this.fileStatusText.setText(R.string.downloading);
        } else if (msg.getStatus() == 6) {
            this.fileStatusText.setText(R.string.downloaded);
        } else if (msg.getStatus() == 5) {
            this.fileStatusText.setText(R.string.un_download);
            this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    msg.setStatus(4);
                    MessageFileHolder.this.sendingProgress.setVisibility(0);
                    MessageFileHolder.this.fileStatusText.setText(R.string.downloading);
                    fileElem.downloadFile(path, new V2TIMDownloadCallback(){

                        public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                        }

                        public void onError(int code, String desc) {
                            ToastUtil.toastLongMessage("getToFile fail:" + code + "=" + desc);
                            MessageFileHolder.this.fileStatusText.setText(R.string.un_download);
                            MessageFileHolder.this.sendingProgress.setVisibility(8);
                        }

                        public void onSuccess() {
                            msg.setDataPath(path);
                            MessageFileHolder.this.fileStatusText.setText(R.string.downloaded);
                            msg.setStatus(6);
                            MessageFileHolder.this.sendingProgress.setVisibility(8);
                            MessageFileHolder.this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.file_path) + path);
                                }
                            });
                        }
                    });
                }
            });
        }
    }
}

