/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMFaceElem;
import com.tencent.imsdk.v2.V2TIMImageElem;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMVideoElem;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import com.tencent.qcloud.tim.uikit.component.photoview.PhotoViewActivity;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.component.video.VideoViewActivity;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageContentHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MessageImageHolder
extends MessageContentHolder {
    private static final int DEFAULT_MAX_SIZE = 540;
    private static final int DEFAULT_RADIUS = 10;
    private final List<String> downloadEles = new ArrayList<String>();
    private ImageView contentImage;
    private ImageView videoPlayBtn;
    private TextView videoDurationText;
    private boolean mClicking;

    public MessageImageHolder(View itemView) {
        super(itemView);
    }

    @Override
    public int getVariableLayout() {
        return R.layout.message_adapter_content_image;
    }

    @Override
    public void initVariableViews() {
        this.contentImage = (ImageView)this.rootView.findViewById(R.id.content_image_iv);
        this.videoPlayBtn = (ImageView)this.rootView.findViewById(R.id.video_play_btn);
        this.videoDurationText = (TextView)this.rootView.findViewById(R.id.video_duration_tv);
    }

    @Override
    public void layoutVariableViews(MessageInfo msg, int position) {
        this.msgContentFrame.setBackground(null);
        switch (msg.getMsgType()) {
            case 112: 
            case 113: {
                this.performCustomFace(msg, position);
                break;
            }
            case 32: 
            case 33: {
                this.performImage(msg, position);
                break;
            }
            case 64: 
            case 65: {
                this.performVideo(msg, position);
            }
        }
    }

    private void performCustomFace(MessageInfo msg, int position) {
        Bitmap bitmap;
        this.videoPlayBtn.setVisibility(8);
        this.videoDurationText.setVisibility(8);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.contentImage.setLayoutParams((ViewGroup.LayoutParams)params);
        V2TIMMessage message = msg.getTimMessage();
        if (message.getElemType() != 8) {
            return;
        }
        V2TIMFaceElem faceEle = message.getFaceElem();
        String filter = new String(faceEle.getData());
        if (!filter.contains("@2x")) {
            filter = filter + "@2x";
        }
        if ((bitmap = FaceManager.getCustomBitmap(faceEle.getIndex(), filter)) == null) {
            bitmap = FaceManager.getEmoji(new String(faceEle.getData()));
            if (bitmap == null) {
                this.contentImage.setImageDrawable(this.rootView.getContext().getResources().getDrawable(R.drawable.face_delete));
            } else {
                this.contentImage.setImageBitmap(bitmap);
            }
        } else {
            this.contentImage.setImageBitmap(bitmap);
        }
    }

    private ViewGroup.LayoutParams getImageParams(ViewGroup.LayoutParams params, MessageInfo msg) {
        if (msg.getImgWidth() == 0 || msg.getImgHeight() == 0) {
            return params;
        }
        if (msg.getImgWidth() > msg.getImgHeight()) {
            params.width = 540;
            params.height = 540 * msg.getImgHeight() / msg.getImgWidth();
        } else {
            params.width = 540 * msg.getImgWidth() / msg.getImgHeight();
            params.height = 540;
        }
        return params;
    }

    private void resetParentLayout() {
        ((FrameLayout)this.contentImage.getParent().getParent()).setPadding(17, 0, 13, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImage(final MessageInfo msg, final int position) {
        this.contentImage.setLayoutParams(this.getImageParams(this.contentImage.getLayoutParams(), msg));
        this.resetParentLayout();
        this.videoPlayBtn.setVisibility(8);
        this.videoDurationText.setVisibility(8);
        V2TIMMessage timMessage = msg.getTimMessage();
        if (timMessage.getElemType() != 3) {
            return;
        }
        V2TIMImageElem imageEle = timMessage.getImageElem();
        final List imgs = imageEle.getImageList();
        if (!TextUtils.isEmpty((CharSequence)msg.getDataPath())) {
            GlideEngine.loadCornerImageWithoutPlaceHolder(this.contentImage, msg.getDataPath(), null, 10.0f);
        } else {
            GlideEngine.loadCornerImageWithoutPlaceHolder(this.contentImage, "", null, 10.0f);
            for (int i = 0; i < imgs.size(); ++i) {
                final V2TIMImageElem.V2TIMImage img = (V2TIMImageElem.V2TIMImage)imgs.get(i);
                if (img.getType() != 1) continue;
                List<String> list = this.downloadEles;
                synchronized (list) {
                    if (this.downloadEles.contains(img.getUUID())) {
                        break;
                    }
                    this.downloadEles.add(img.getUUID());
                }
                final String path = TUIKitConstants.IMAGE_DOWNLOAD_DIR + img.getUUID();
                img.downloadImage(path, new V2TIMDownloadCallback(){

                    public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                        TUIKitLog.i("downloadImage progress current:", progressInfo.getCurrentSize() + ", total:" + progressInfo.getTotalSize());
                    }

                    public void onError(int code, String desc) {
                        MessageImageHolder.this.downloadEles.remove(img.getUUID());
                        TUIKitLog.e("MessageListAdapter img getImage", code + ":" + desc);
                    }

                    public void onSuccess() {
                        MessageImageHolder.this.downloadEles.remove(img.getUUID());
                        msg.setDataPath(path);
                        GlideEngine.loadCornerImage(MessageImageHolder.this.contentImage, msg.getDataPath(), null, 10.0f);
                    }
                });
                break;
            }
        }
        this.contentImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                for (int i = 0; i < imgs.size(); ++i) {
                    V2TIMImageElem.V2TIMImage img = (V2TIMImageElem.V2TIMImage)imgs.get(i);
                    if (img.getType() != 0) continue;
                    PhotoViewActivity.mCurrentOriginalImage = img;
                    break;
                }
                Intent intent = new Intent(TUIKit.getAppContext(), PhotoViewActivity.class);
                intent.addFlags(0x10000000);
                intent.putExtra("image_data", msg.getDataPath());
                intent.putExtra("self_message", msg.isSelf());
                TUIKit.getAppContext().startActivity(intent);
            }
        });
        this.contentImage.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (MessageImageHolder.this.onItemClickListener != null) {
                    MessageImageHolder.this.onItemClickListener.onMessageLongClick(view, position, msg);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performVideo(final MessageInfo msg, final int position) {
        this.contentImage.setLayoutParams(this.getImageParams(this.contentImage.getLayoutParams(), msg));
        this.resetParentLayout();
        this.videoPlayBtn.setVisibility(0);
        this.videoDurationText.setVisibility(0);
        V2TIMMessage timMessage = msg.getTimMessage();
        if (timMessage.getElemType() != 5) {
            return;
        }
        final V2TIMVideoElem videoEle = timMessage.getVideoElem();
        if (!TextUtils.isEmpty((CharSequence)msg.getDataPath())) {
            GlideEngine.loadCornerImage(this.contentImage, msg.getDataPath(), null, 10.0f);
        } else {
            List<String> list = this.downloadEles;
            synchronized (list) {
                if (!this.downloadEles.contains(videoEle.getSnapshotUUID())) {
                    this.downloadEles.add(videoEle.getSnapshotUUID());
                }
            }
            final String path = TUIKitConstants.IMAGE_DOWNLOAD_DIR + videoEle.getSnapshotUUID();
            videoEle.downloadSnapshot(path, new V2TIMDownloadCallback(){

                public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                    TUIKitLog.i("downloadSnapshot progress current:", progressInfo.getCurrentSize() + ", total:" + progressInfo.getTotalSize());
                }

                public void onError(int code, String desc) {
                    MessageImageHolder.this.downloadEles.remove(videoEle.getSnapshotUUID());
                    TUIKitLog.e("MessageListAdapter video getImage", code + ":" + desc);
                }

                public void onSuccess() {
                    MessageImageHolder.this.downloadEles.remove(videoEle.getSnapshotUUID());
                    msg.setDataPath(path);
                    GlideEngine.loadCornerImage(MessageImageHolder.this.contentImage, msg.getDataPath(), null, 10.0f);
                }
            });
        }
        String durations = "00:" + videoEle.getDuration();
        if (videoEle.getDuration() < 10) {
            durations = "00:0" + videoEle.getDuration();
        }
        this.videoDurationText.setText((CharSequence)durations);
        final String videoPath = TUIKitConstants.VIDEO_DOWNLOAD_DIR + videoEle.getVideoUUID();
        File videoFile = new File(videoPath);
        if (msg.getStatus() == 2) {
            this.statusImage.setVisibility(8);
            this.sendingProgress.setVisibility(8);
        } else if (videoFile.exists() && msg.getStatus() == 1) {
            this.statusImage.setVisibility(8);
            this.sendingProgress.setVisibility(0);
        } else if (msg.getStatus() == 3) {
            this.statusImage.setVisibility(0);
            this.sendingProgress.setVisibility(8);
        }
        this.msgContentFrame.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageImageHolder.this.mClicking) {
                    return;
                }
                MessageImageHolder.this.sendingProgress.setVisibility(0);
                MessageImageHolder.this.mClicking = true;
                File videoFile = new File(videoPath);
                if (videoFile.exists() && (long)videoEle.getVideoSize() == videoFile.length()) {
                    MessageImageHolder.this.mAdapter.notifyItemChanged(position);
                    MessageImageHolder.this.mClicking = false;
                    MessageImageHolder.this.play(msg);
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MessageImageHolder.this.mClicking = false;
                        }
                    }, 200L);
                } else {
                    MessageImageHolder.this.getVideo(videoEle, videoPath, msg, true, position);
                }
            }
        });
    }

    private void getVideo(V2TIMVideoElem videoElem, String videoPath, final MessageInfo msg, final boolean autoPlay, final int position) {
        videoElem.downloadVideo(videoPath, new V2TIMDownloadCallback(){

            public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                TUIKitLog.i("downloadVideo progress current:", progressInfo.getCurrentSize() + ", total:" + progressInfo.getTotalSize());
            }

            public void onError(int code, String desc) {
                ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.download_file_error) + code + "=" + desc);
                msg.setStatus(6);
                MessageImageHolder.this.sendingProgress.setVisibility(8);
                MessageImageHolder.this.statusImage.setVisibility(0);
                MessageImageHolder.this.mAdapter.notifyItemChanged(position);
                MessageImageHolder.this.mClicking = false;
            }

            public void onSuccess() {
                MessageImageHolder.this.mAdapter.notifyItemChanged(position);
                if (autoPlay) {
                    MessageImageHolder.this.play(msg);
                }
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MessageImageHolder.this.mClicking = false;
                    }
                }, 200L);
            }
        });
    }

    private void play(MessageInfo msg) {
        this.statusImage.setVisibility(8);
        this.sendingProgress.setVisibility(8);
        Intent intent = new Intent(TUIKit.getAppContext(), VideoViewActivity.class);
        intent.putExtra("camera_image_path", msg.getDataPath());
        intent.putExtra("camera_video_path", (Parcelable)msg.getDataUri());
        intent.setFlags(0x10000000);
        TUIKit.getAppContext().startActivity(intent);
    }
}

