/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder;

import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.chat.layout.message.holder.MessageEmptyHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;

public class MessageTipsHolder
extends MessageEmptyHolder {
    private TextView mChatTipsTv;

    public MessageTipsHolder(View itemView) {
        super(itemView);
    }

    @Override
    public int getVariableLayout() {
        return R.layout.message_adapter_content_tips;
    }

    @Override
    public void initVariableViews() {
        this.mChatTipsTv = (TextView)this.rootView.findViewById(R.id.chat_tips_tv);
    }

    @Override
    public void layoutViews(MessageInfo msg, int position) {
        super.layoutViews(msg, position);
        if (this.properties.getTipsMessageBubble() != null) {
            this.mChatTipsTv.setBackground(this.properties.getTipsMessageBubble());
        }
        if (this.properties.getTipsMessageFontColor() != 0) {
            this.mChatTipsTv.setTextColor(this.properties.getTipsMessageFontColor());
        }
        if (this.properties.getTipsMessageFontSize() != 0) {
            this.mChatTipsTv.setTextSize((float)this.properties.getTipsMessageFontSize());
        }
        if (msg.getStatus() == 275) {
            if (msg.isSelf()) {
                msg.setExtra(TUIKit.getAppContext().getString(R.string.revoke_tips_you));
            } else if (msg.isGroup()) {
                String message = TUIKitConstants.covert2HTMLString(TextUtils.isEmpty((CharSequence)msg.getGroupNameCard()) ? msg.getFromUser() : msg.getGroupNameCard());
                msg.setExtra(message + TUIKit.getAppContext().getString(R.string.revoke_tips));
            } else {
                msg.setExtra(TUIKit.getAppContext().getString(R.string.revoke_tips_other));
            }
        }
        if ((msg.getStatus() == 275 || msg.getMsgType() >= 257 && msg.getMsgType() <= 264) && msg.getExtra() != null) {
            this.mChatTipsTv.setText((CharSequence)Html.fromHtml((String)msg.getExtra().toString()));
        }
    }
}

