/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.contact;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.imsdk.v2.V2TIMFriendApplicationResult;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactItemBean;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactListView;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.List;

public class ContactAdapter
extends RecyclerView.Adapter<ViewHolder> {
    protected List<ContactItemBean> mData;
    protected LayoutInflater mInflater;
    private ContactListView.OnSelectChangedListener mOnSelectChangedListener;
    private ContactListView.OnItemClickListener mOnClickListener;
    private int mPreSelectedPosition;
    private boolean isSingleSelectMode;

    public ContactAdapter(List<ContactItemBean> data) {
        this.mData = data;
        this.mInflater = LayoutInflater.from((Context)TUIKit.getAppContext());
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(this.mInflater.inflate(R.layout.contact_selecable_adapter_item, parent, false));
    }

    public void onBindViewHolder(final ViewHolder holder, final int position) {
        String tag2;
        String tag1;
        final ContactItemBean contactBean = this.mData.get(position);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)holder.line.getLayoutParams();
        params.leftMargin = position < this.mData.size() - 1 ? (TextUtils.equals((CharSequence)(tag1 = contactBean.getSuspensionTag()), (CharSequence)(tag2 = this.mData.get(position + 1).getSuspensionTag())) ? holder.tvName.getLeft() : 0) : 0;
        holder.line.setLayoutParams((ViewGroup.LayoutParams)params);
        if (!TextUtils.isEmpty((CharSequence)contactBean.getRemark())) {
            holder.tvName.setText((CharSequence)contactBean.getRemark());
        } else if (!TextUtils.isEmpty((CharSequence)contactBean.getNickname())) {
            holder.tvName.setText((CharSequence)contactBean.getNickname());
        } else {
            holder.tvName.setText((CharSequence)contactBean.getId());
        }
        if (this.mOnSelectChangedListener != null) {
            holder.ccSelect.setVisibility(0);
            holder.ccSelect.setChecked(contactBean.isSelected());
        }
        holder.content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!contactBean.isEnable()) {
                    return;
                }
                holder.ccSelect.setChecked(!holder.ccSelect.isChecked());
                if (ContactAdapter.this.mOnSelectChangedListener != null) {
                    ContactAdapter.this.mOnSelectChangedListener.onSelectChanged(ContactAdapter.this.getItem(position), holder.ccSelect.isChecked());
                }
                contactBean.setSelected(holder.ccSelect.isChecked());
                if (ContactAdapter.this.mOnClickListener != null) {
                    ContactAdapter.this.mOnClickListener.onItemClick(position, contactBean);
                }
                if (ContactAdapter.this.isSingleSelectMode && position != ContactAdapter.this.mPreSelectedPosition && contactBean.isSelected()) {
                    ContactAdapter.this.mData.get(ContactAdapter.this.mPreSelectedPosition).setSelected(false);
                    ContactAdapter.this.notifyItemChanged(ContactAdapter.this.mPreSelectedPosition);
                }
                ContactAdapter.this.mPreSelectedPosition = position;
            }
        });
        holder.unreadText.setVisibility(8);
        if (TextUtils.equals((CharSequence)TUIKit.getAppContext().getResources().getString(R.string.new_friend), (CharSequence)contactBean.getId())) {
            holder.avatar.setImageResource(R.drawable.group_new_friend);
            V2TIMManager.getFriendshipManager().getFriendApplicationList((V2TIMValueCallback)new V2TIMValueCallback<V2TIMFriendApplicationResult>(){

                public void onError(int code, String desc) {
                    ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
                }

                public void onSuccess(V2TIMFriendApplicationResult v2TIMFriendApplicationResult) {
                    if (v2TIMFriendApplicationResult.getFriendApplicationList() != null) {
                        int pendingRequest = v2TIMFriendApplicationResult.getFriendApplicationList().size();
                        if (pendingRequest == 0) {
                            holder.unreadText.setVisibility(8);
                        } else {
                            holder.unreadText.setVisibility(0);
                            holder.unreadText.setText((CharSequence)("" + pendingRequest));
                        }
                    }
                }
            });
        } else if (TextUtils.equals((CharSequence)TUIKit.getAppContext().getResources().getString(R.string.group), (CharSequence)contactBean.getId())) {
            holder.avatar.setImageResource(R.drawable.group_common_list);
        } else if (TextUtils.equals((CharSequence)TUIKit.getAppContext().getResources().getString(R.string.blacklist), (CharSequence)contactBean.getId())) {
            holder.avatar.setImageResource(R.drawable.group_black_list);
        } else if (TextUtils.isEmpty((CharSequence)contactBean.getAvatarurl())) {
            if (contactBean.isGroup()) {
                holder.avatar.setImageResource(R.drawable.default_head);
            } else {
                holder.avatar.setImageResource(R.drawable.default_head);
            }
        } else {
            GlideEngine.loadImage(holder.avatar, Uri.parse((String)contactBean.getAvatarurl()));
        }
    }

    public void onViewRecycled(ViewHolder holder) {
        if (holder != null) {
            GlideEngine.clear(holder.avatar);
            holder.avatar.setImageResource(0);
        }
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    private ContactItemBean getItem(int position) {
        if (position < this.mData.size()) {
            return this.mData.get(position);
        }
        return null;
    }

    public int getItemCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public void setDataSource(List<ContactItemBean> datas) {
        this.mData = datas;
        this.notifyDataSetChanged();
    }

    public void setSingleSelectMode(boolean mode) {
        this.isSingleSelectMode = mode;
    }

    public void setOnSelectChangedListener(ContactListView.OnSelectChangedListener selectListener) {
        this.mOnSelectChangedListener = selectListener;
    }

    public void setOnItemClickListener(ContactListView.OnItemClickListener listener) {
        this.mOnClickListener = listener;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvName;
        TextView unreadText;
        ImageView avatar;
        CheckBox ccSelect;
        View content;
        View line;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvName = (TextView)itemView.findViewById(R.id.tvCity);
            this.unreadText = (TextView)itemView.findViewById(R.id.conversation_unread);
            this.unreadText.setVisibility(8);
            this.avatar = (ImageView)itemView.findViewById(R.id.ivAvatar);
            this.ccSelect = (CheckBox)itemView.findViewById(R.id.contact_check_box);
            this.content = itemView.findViewById(R.id.selectable_contact_item);
            this.line = itemView.findViewById(R.id.view_line);
        }
    }
}

