/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.contact;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.imsdk.v2.V2TIMFriendInfo;
import com.tencent.imsdk.v2.V2TIMGroupInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfoResult;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.CustomLinearLayoutManager;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.widget.IndexBar;
import com.tencent.qcloud.tim.uikit.component.indexlib.suspension.SuspensionDecoration;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactAdapter;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactItemBean;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ThreadHelper;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class ContactListView
extends LinearLayout {
    private static final String TAG = ContactListView.class.getSimpleName();
    private static final String INDEX_STRING_TOP = "\u2191";
    private RecyclerView mRv;
    private ContactAdapter mAdapter;
    private CustomLinearLayoutManager mManager;
    private List<ContactItemBean> mData = new ArrayList<ContactItemBean>();
    private SuspensionDecoration mDecoration;
    private ProgressBar mContactLoadingBar;
    private GroupInfo mGroupInfo;
    private IndexBar mIndexBar;
    private TextView mTvSideBarHint;

    public ContactListView(Context context) {
        super(context);
        this.init();
    }

    public ContactListView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ContactListView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        ContactListView.inflate((Context)this.getContext(), (int)R.layout.contact_list, (ViewGroup)this);
        this.mRv = (RecyclerView)this.findViewById(R.id.contact_member_list);
        this.mManager = new CustomLinearLayoutManager(this.getContext());
        this.mRv.setLayoutManager((RecyclerView.LayoutManager)this.mManager);
        this.mAdapter = new ContactAdapter(this.mData);
        this.mRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mDecoration = new SuspensionDecoration(this.getContext(), this.mData);
        this.mRv.addItemDecoration((RecyclerView.ItemDecoration)this.mDecoration);
        this.mTvSideBarHint = (TextView)this.findViewById(R.id.contact_tvSideBarHint);
        this.mIndexBar = (IndexBar)this.findViewById(R.id.contact_indexBar);
        this.mIndexBar.setPressedShowTextView(this.mTvSideBarHint).setNeedRealIndex(false).setLayoutManager(this.mManager);
        this.mContactLoadingBar = (ProgressBar)this.findViewById(R.id.contact_loading_bar);
    }

    public ContactAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setDataSource(List<ContactItemBean> data) {
        this.mContactLoadingBar.setVisibility(8);
        this.mData = data;
        this.mAdapter.setDataSource(this.mData);
        this.mIndexBar.setSourceDatas(this.mData).invalidate();
        this.mDecoration.setDatas(this.mData);
    }

    public void setSingleSelectMode(boolean mode) {
        this.mAdapter.setSingleSelectMode(mode);
    }

    public void setOnSelectChangeListener(OnSelectChangedListener selectChangeListener) {
        this.mAdapter.setOnSelectChangedListener(selectChangeListener);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mAdapter.setOnItemClickListener(listener);
    }

    public void loadDataSource(int dataSource) {
        this.mContactLoadingBar.setVisibility(0);
        this.mData.clear();
        switch (dataSource) {
            case 1: {
                this.loadFriendListDataAsync();
                break;
            }
            case 2: {
                this.loadBlackListData();
                break;
            }
            case 3: {
                this.loadGroupListData();
                break;
            }
            case 4: {
                this.mData.add((ContactItemBean)new ContactItemBean(this.getResources().getString(R.string.new_friend)).setTop(true).setBaseIndexTag(INDEX_STRING_TOP));
                this.mData.add((ContactItemBean)new ContactItemBean(this.getResources().getString(R.string.group)).setTop(true).setBaseIndexTag(INDEX_STRING_TOP));
                this.mData.add((ContactItemBean)new ContactItemBean(this.getResources().getString(R.string.blacklist)).setTop(true).setBaseIndexTag(INDEX_STRING_TOP));
                this.loadFriendListDataAsync();
                break;
            }
            case 5: {
                this.mData.add((ContactItemBean)new ContactItemBean(this.getResources().getString(R.string.at_all)).setTop(true).setBaseIndexTag(INDEX_STRING_TOP));
                this.loadGroupMembers();
                break;
            }
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        this.mGroupInfo = groupInfo;
    }

    private void updateStatus(List<ContactItemBean> beanList) {
        if (this.mGroupInfo == null) {
            return;
        }
        List<GroupMemberInfo> list = this.mGroupInfo.getMemberDetails();
        boolean needFresh = false;
        if (list.size() > 0) {
            for (GroupMemberInfo info : list) {
                for (ContactItemBean bean : beanList) {
                    if (!info.getAccount().equals(bean.getId())) continue;
                    bean.setSelected(true);
                    bean.setEnable(false);
                    needFresh = true;
                }
            }
        }
        if (needFresh) {
            BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ContactListView.this.mAdapter.notifyDataSetChanged();
                }
            });
        }
    }

    private void loadFriendListDataAsync() {
        TUIKitLog.i(TAG, "loadFriendListDataAsync");
        ThreadHelper.INST.execute(new Runnable(){

            @Override
            public void run() {
                V2TIMManager.getFriendshipManager().getFriendList((V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendInfo>>(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TAG, "loadFriendListDataAsync err code:" + code + ", desc:" + desc);
                        ToastUtil.toastShortMessage("loadFriendList error code = " + code + ", desc = " + desc);
                    }

                    public void onSuccess(List<V2TIMFriendInfo> v2TIMFriendInfos) {
                        if (v2TIMFriendInfos == null) {
                            v2TIMFriendInfos = new ArrayList<V2TIMFriendInfo>();
                        }
                        TUIKitLog.i(TAG, "loadFriendListDataAsync->getFriendList:" + v2TIMFriendInfos.size());
                        ContactListView.this.assembleFriendListData(v2TIMFriendInfos);
                    }
                });
            }
        });
    }

    private void assembleFriendListData(List<V2TIMFriendInfo> timFriendInfoList) {
        for (V2TIMFriendInfo timFriendInfo : timFriendInfoList) {
            ContactItemBean info = new ContactItemBean();
            info.covertTIMFriend(timFriendInfo);
            this.mData.add(info);
        }
        this.updateStatus(this.mData);
        this.setDataSource(this.mData);
    }

    private void loadBlackListData() {
        TUIKitLog.i(TAG, "loadBlackListData");
        V2TIMManager.getFriendshipManager().getBlackList((V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getBlackList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
                ContactListView.this.mContactLoadingBar.setVisibility(8);
            }

            public void onSuccess(List<V2TIMFriendInfo> v2TIMFriendInfos) {
                TUIKitLog.i(TAG, "getBlackList success: " + v2TIMFriendInfos.size());
                if (v2TIMFriendInfos.size() == 0) {
                    TUIKitLog.i(TAG, "getBlackList success but no data");
                }
                ContactListView.this.mData.clear();
                for (V2TIMFriendInfo timFriendInfo : v2TIMFriendInfos) {
                    ContactItemBean info = new ContactItemBean();
                    info.covertTIMFriend(timFriendInfo).setBlackList(true);
                    ContactListView.this.mData.add(info);
                }
                ContactListView.this.setDataSource(ContactListView.this.mData);
            }
        });
    }

    private void loadGroupListData() {
        TUIKitLog.i(TAG, "loadGroupListData");
        V2TIMManager.getGroupManager().getJoinedGroupList((V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMGroupInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getGroupList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
                ContactListView.this.mContactLoadingBar.setVisibility(8);
            }

            public void onSuccess(List<V2TIMGroupInfo> v2TIMGroupInfos) {
                TUIKitLog.i(TAG, "getGroupList success: " + v2TIMGroupInfos.size());
                if (v2TIMGroupInfos.size() == 0) {
                    TUIKitLog.i(TAG, "getGroupList success but no data");
                }
                ContactListView.this.mData.clear();
                for (V2TIMGroupInfo info : v2TIMGroupInfos) {
                    ContactItemBean bean = new ContactItemBean();
                    ContactListView.this.mData.add(bean.covertTIMGroupBaseInfo(info));
                }
                ContactListView.this.setDataSource(ContactListView.this.mData);
            }
        });
    }

    private void loadGroupMembers() {
        V2TIMManager.getGroupManager().getGroupMemberList(this.mGroupInfo.getId(), 0, 0L, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMGroupMemberInfoResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "loadGroupMembers failed, code: " + code + "|desc: " + desc);
            }

            public void onSuccess(V2TIMGroupMemberInfoResult v2TIMGroupMemberInfoResult) {
                ArrayList members = new ArrayList();
                for (int i = 0; i < v2TIMGroupMemberInfoResult.getMemberInfoList().size(); ++i) {
                    if (((V2TIMGroupMemberFullInfo)v2TIMGroupMemberInfoResult.getMemberInfoList().get(i)).getUserID().equals(V2TIMManager.getInstance().getLoginUser())) continue;
                    members.add(v2TIMGroupMemberInfoResult.getMemberInfoList().get(i));
                }
                for (V2TIMGroupMemberFullInfo info : members) {
                    ContactItemBean bean = new ContactItemBean();
                    ContactListView.this.mData.add(bean.covertTIMGroupMemberFullInfo(info));
                }
                ContactListView.this.setDataSource(ContactListView.this.mData);
            }
        });
    }

    public List<ContactItemBean> getGroupData() {
        return this.mData;
    }

    public static class DataSource {
        public static final int UNKNOWN = -1;
        public static final int FRIEND_LIST = 1;
        public static final int BLACK_LIST = 2;
        public static final int GROUP_LIST = 3;
        public static final int CONTACT_LIST = 4;
        public static final int GROUP_MEMBER_LIST = 5;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, ContactItemBean var2);
    }

    public static interface OnSelectChangedListener {
        public void onSelectChanged(ContactItemBean var1, boolean var2);
    }
}

