/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.contact;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMFriendApplication;
import com.tencent.imsdk.v2.V2TIMFriendInfo;
import com.tencent.imsdk.v2.V2TIMFriendOperationResult;
import com.tencent.imsdk.v2.V2TIMGroupApplication;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.CircleImageView;
import com.tencent.qcloud.tim.uikit.component.LineControllerView;
import com.tencent.qcloud.tim.uikit.component.SelectionActivity;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactItemBean;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyInfo;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FriendProfileLayout
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = FriendProfileLayout.class.getSimpleName();
    private final int CHANGE_REMARK_CODE = 200;
    private TitleBarLayout mTitleBar;
    private CircleImageView mHeadImageView;
    private TextView mNickNameView;
    private LineControllerView mIDView;
    private LineControllerView mAddWordingView;
    private LineControllerView mRemarkView;
    private LineControllerView mAddBlackView;
    private LineControllerView mChatTopView;
    private TextView mDeleteView;
    private TextView mChatView;
    private ContactItemBean mContactInfo;
    private ChatInfo mChatInfo;
    private V2TIMFriendApplication mFriendApplication;
    private OnButtonClickListener mListener;
    private String mId;
    private String mNickname;
    private String mRemark;
    private String mAddWords;

    public FriendProfileLayout(Context context) {
        super(context);
        this.init();
    }

    public FriendProfileLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FriendProfileLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        FriendProfileLayout.inflate((Context)this.getContext(), (int)R.layout.contact_friend_profile_layout, (ViewGroup)this);
        this.mHeadImageView = (CircleImageView)this.findViewById(R.id.avatar);
        this.mNickNameView = (TextView)this.findViewById(R.id.name);
        this.mIDView = (LineControllerView)this.findViewById(R.id.id);
        this.mAddWordingView = (LineControllerView)this.findViewById(R.id.add_wording);
        this.mAddWordingView.setCanNav(false);
        this.mAddWordingView.setSingleLine(false);
        this.mRemarkView = (LineControllerView)this.findViewById(R.id.remark);
        this.mRemarkView.setOnClickListener(this);
        this.mChatTopView = (LineControllerView)this.findViewById(R.id.chat_to_top);
        this.mAddBlackView = (LineControllerView)this.findViewById(R.id.blackList);
        this.mDeleteView = (TextView)this.findViewById(R.id.btnDel);
        this.mDeleteView.setOnClickListener((View.OnClickListener)this);
        this.mChatView = (TextView)this.findViewById(R.id.btnChat);
        this.mChatView.setOnClickListener((View.OnClickListener)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.friend_titlebar);
        this.mTitleBar.setTitle(this.getResources().getString(R.string.profile_detail), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBar.getRightGroup().setVisibility(8);
        this.mTitleBar.setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }
        });
    }

    public void initData(Object data) {
        if (data instanceof ChatInfo) {
            this.mChatInfo = (ChatInfo)data;
            this.mId = this.mChatInfo.getId();
            this.mChatTopView.setVisibility(0);
            this.mChatTopView.setChecked(ConversationManagerKit.getInstance().isTopConversation(this.mId));
            this.mChatTopView.setCheckListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    ConversationManagerKit.getInstance().setConversationTop(FriendProfileLayout.this.mId, isChecked);
                }
            });
            this.loadUserProfile();
            return;
        }
        if (data instanceof ContactItemBean) {
            this.mContactInfo = (ContactItemBean)data;
            this.mId = this.mContactInfo.getId();
            this.mNickname = this.mContactInfo.getNickname();
            this.mRemarkView.setVisibility(0);
            this.mRemarkView.setContent(this.mContactInfo.getRemark());
            this.mAddBlackView.setChecked(this.mContactInfo.isBlackList());
            this.mAddBlackView.setCheckListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (isChecked) {
                        FriendProfileLayout.this.addBlack();
                    } else {
                        FriendProfileLayout.this.deleteBlack();
                    }
                }
            });
            if (!TextUtils.isEmpty((CharSequence)this.mContactInfo.getAvatarurl())) {
                GlideEngine.loadImage((ImageView)this.mHeadImageView, Uri.parse((String)this.mContactInfo.getAvatarurl()));
            }
        } else if (data instanceof V2TIMFriendApplication) {
            this.mFriendApplication = (V2TIMFriendApplication)data;
            this.mId = this.mFriendApplication.getUserID();
            this.mNickname = this.mFriendApplication.getNickname();
            this.mAddWordingView.setVisibility(0);
            this.mAddWordingView.setContent(this.mFriendApplication.getAddWording());
            this.mRemarkView.setVisibility(8);
            this.mAddBlackView.setVisibility(8);
            this.mDeleteView.setText(R.string.refuse);
            this.mDeleteView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FriendProfileLayout.this.refuse();
                }
            });
            this.mChatView.setText(R.string.accept);
            this.mChatView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FriendProfileLayout.this.accept();
                }
            });
        } else if (data instanceof GroupApplyInfo) {
            final GroupApplyInfo info = (GroupApplyInfo)data;
            V2TIMGroupApplication item = ((GroupApplyInfo)data).getGroupApplication();
            this.mId = item.getFromUser();
            this.mNickname = item.getFromUserNickName();
            this.mAddWordingView.setVisibility(0);
            this.mAddWordingView.setContent(item.getRequestMsg());
            this.mRemarkView.setVisibility(8);
            this.mAddBlackView.setVisibility(8);
            this.mDeleteView.setText(R.string.refuse);
            this.mDeleteView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FriendProfileLayout.this.refuseApply(info);
                }
            });
            this.mChatView.setText(R.string.accept);
            this.mChatView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FriendProfileLayout.this.acceptApply(info);
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)this.mNickname)) {
            this.mNickNameView.setText((CharSequence)this.mNickname);
        } else {
            this.mNickNameView.setText((CharSequence)this.mId);
        }
        this.mIDView.setContent(this.mId);
    }

    private void updateViews(ContactItemBean bean) {
        this.mContactInfo = bean;
        this.mChatTopView.setVisibility(0);
        boolean top = ConversationManagerKit.getInstance().isTopConversation(this.mId);
        if (this.mChatTopView.isChecked() != top) {
            this.mChatTopView.setChecked(top);
        }
        this.mChatTopView.setCheckListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ConversationManagerKit.getInstance().setConversationTop(FriendProfileLayout.this.mId, isChecked);
            }
        });
        this.mId = bean.getId();
        this.mNickname = bean.getNickname();
        if (bean.isFriend()) {
            this.mRemarkView.setVisibility(0);
            this.mRemarkView.setContent(bean.getRemark());
            this.mAddBlackView.setVisibility(0);
            this.mAddBlackView.setChecked(bean.isBlackList());
            this.mAddBlackView.setCheckListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (isChecked) {
                        FriendProfileLayout.this.addBlack();
                    } else {
                        FriendProfileLayout.this.deleteBlack();
                    }
                }
            });
            this.mDeleteView.setVisibility(0);
        } else {
            this.mRemarkView.setVisibility(8);
            this.mAddBlackView.setVisibility(8);
            this.mDeleteView.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mNickname)) {
            this.mNickNameView.setText((CharSequence)this.mNickname);
        } else {
            this.mNickNameView.setText((CharSequence)this.mId);
        }
        if (!TextUtils.isEmpty((CharSequence)bean.getAvatarurl())) {
            GlideEngine.loadImage((ImageView)this.mHeadImageView, Uri.parse((String)bean.getAvatarurl()));
        }
        this.mIDView.setContent(this.mId);
    }

    private void loadUserProfile() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.mId);
        final ContactItemBean bean = new ContactItemBean();
        bean.setFriend(false);
        V2TIMManager.getInstance().getUsersInfo(list, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMUserFullInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "loadUserProfile err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMUserFullInfo> v2TIMUserFullInfos) {
                if (v2TIMUserFullInfos == null || v2TIMUserFullInfos.size() != 1) {
                    return;
                }
                V2TIMUserFullInfo timUserFullInfo = v2TIMUserFullInfos.get(0);
                bean.setNickname(timUserFullInfo.getNickName());
                bean.setId(timUserFullInfo.getUserID());
                bean.setAvatarurl(timUserFullInfo.getFaceUrl());
                FriendProfileLayout.this.updateViews(bean);
            }
        });
        V2TIMManager.getFriendshipManager().getBlackList((V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getBlackList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMFriendInfo> v2TIMFriendInfos) {
                if (v2TIMFriendInfos != null && v2TIMFriendInfos.size() > 0) {
                    for (V2TIMFriendInfo friendInfo : v2TIMFriendInfos) {
                        if (!TextUtils.equals((CharSequence)friendInfo.getUserID(), (CharSequence)FriendProfileLayout.this.mId)) continue;
                        bean.setBlackList(true);
                        FriendProfileLayout.this.updateViews(bean);
                        break;
                    }
                }
            }
        });
        V2TIMManager.getFriendshipManager().getFriendList((V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getFriendList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMFriendInfo> v2TIMFriendInfos) {
                if (v2TIMFriendInfos != null && v2TIMFriendInfos.size() > 0) {
                    for (V2TIMFriendInfo friendInfo : v2TIMFriendInfos) {
                        if (!TextUtils.equals((CharSequence)friendInfo.getUserID(), (CharSequence)FriendProfileLayout.this.mId)) continue;
                        bean.setFriend(true);
                        bean.setRemark(friendInfo.getFriendRemark());
                        bean.setAvatarurl(friendInfo.getUserProfile().getFaceUrl());
                        break;
                    }
                }
                FriendProfileLayout.this.updateViews(bean);
            }
        });
    }

    private void accept() {
        V2TIMManager.getFriendshipManager().acceptFriendApplication(this.mFriendApplication, 1, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMFriendOperationResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "accept err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(V2TIMFriendOperationResult v2TIMFriendOperationResult) {
                TUIKitLog.i(TAG, "accept success");
                FriendProfileLayout.this.mChatView.setText(R.string.accepted);
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }
        });
    }

    private void refuse() {
        V2TIMManager.getFriendshipManager().refuseFriendApplication(this.mFriendApplication, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMFriendOperationResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "accept err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(V2TIMFriendOperationResult v2TIMFriendOperationResult) {
                TUIKitLog.i(TAG, "refuse success");
                FriendProfileLayout.this.mDeleteView.setText(R.string.refused);
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }
        });
    }

    public void acceptApply(final GroupApplyInfo item) {
        GroupChatManagerKit.getInstance().getProvider().acceptApply(item, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                Intent intent = new Intent();
                intent.putExtra("apply", (Serializable)item);
                ((Activity)FriendProfileLayout.this.getContext()).setResult(-1, intent);
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void refuseApply(final GroupApplyInfo item) {
        GroupChatManagerKit.getInstance().getProvider().refuseApply(item, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                Intent intent = new Intent();
                intent.putExtra("apply", (Serializable)item);
                ((Activity)FriendProfileLayout.this.getContext()).setResult(-1, intent);
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    private void delete() {
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add(this.mId);
        V2TIMManager.getFriendshipManager().deleteFromFriendList(identifiers, 2, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendOperationResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "deleteFriends err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMFriendOperationResult> v2TIMFriendOperationResults) {
                TUIKitLog.i(TAG, "deleteFriends success");
                ConversationManagerKit.getInstance().deleteConversation(FriendProfileLayout.this.mId, false);
                if (FriendProfileLayout.this.mListener != null) {
                    FriendProfileLayout.this.mListener.onDeleteFriendClick(FriendProfileLayout.this.mId);
                }
                ((Activity)FriendProfileLayout.this.getContext()).finish();
            }
        });
    }

    private void chat() {
        if (this.mListener != null || this.mContactInfo != null) {
            this.mListener.onStartConversationClick(this.mContactInfo);
        }
        ((Activity)this.getContext()).finish();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btnChat) {
            this.chat();
        } else if (v.getId() == R.id.btnDel) {
            this.delete();
        } else if (v.getId() == R.id.remark) {
            Bundle bundle = new Bundle();
            bundle.putString("title", this.getResources().getString(R.string.profile_remark_edit));
            bundle.putString("init_content", this.mRemarkView.getContent());
            bundle.putInt("limit", 20);
            SelectionActivity.startTextSelection(TUIKit.getAppContext(), bundle, new SelectionActivity.OnResultReturnListener(){

                @Override
                public void onReturn(Object text) {
                    FriendProfileLayout.this.mRemarkView.setContent(text.toString());
                    if (TextUtils.isEmpty((CharSequence)text.toString())) {
                        text = "";
                    }
                    FriendProfileLayout.this.modifyRemark(text.toString());
                }
            });
        }
    }

    private void modifyRemark(final String txt) {
        V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
        v2TIMFriendInfo.setUserID(this.mId);
        v2TIMFriendInfo.setFriendRemark(txt);
        V2TIMManager.getFriendshipManager().setFriendInfo(v2TIMFriendInfo, new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "modifyRemark err code = " + code + ", desc = " + desc);
            }

            public void onSuccess() {
                FriendProfileLayout.this.mContactInfo.setRemark(txt);
                TUIKitLog.i(TAG, "modifyRemark success");
            }
        });
    }

    private void addBlack() {
        String[] idStringList = this.mId.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String id2 : idStringList) {
            idList.add(id2);
        }
        V2TIMManager.getFriendshipManager().addToBlackList(idList, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendOperationResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "addBlackList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMFriendOperationResult> v2TIMFriendOperationResults) {
                TUIKitLog.v(TAG, "addBlackList success");
            }
        });
    }

    private void deleteBlack() {
        String[] idStringList = this.mId.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String id2 : idStringList) {
            idList.add(id2);
        }
        V2TIMManager.getFriendshipManager().deleteFromBlackList(idList, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMFriendOperationResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "deleteBlackList err code = " + code + ", desc = " + desc);
                ToastUtil.toastShortMessage("Error code = " + code + ", desc = " + desc);
            }

            public void onSuccess(List<V2TIMFriendOperationResult> v2TIMFriendOperationResults) {
                TUIKitLog.i(TAG, "deleteBlackList success");
            }
        });
    }

    public void setOnButtonClickListener(OnButtonClickListener l) {
        this.mListener = l;
    }

    public static interface OnButtonClickListener {
        public void onStartConversationClick(ContactItemBean var1);

        public void onDeleteFriendClick(String var1);
    }
}

