/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationListAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationListLayout;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationProvider;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationLayout;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public class ConversationLayout
extends RelativeLayout
implements IConversationLayout {
    private TitleBarLayout mTitleBarLayout;
    private ConversationListLayout mConversationList;

    public ConversationLayout(Context context) {
        super(context);
        this.init();
    }

    public ConversationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConversationLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        ConversationLayout.inflate((Context)this.getContext(), (int)R.layout.conversation_layout, (ViewGroup)this);
        this.mTitleBarLayout = (TitleBarLayout)this.findViewById(R.id.conversation_title);
        this.mConversationList = (ConversationListLayout)this.findViewById(R.id.conversation_list);
    }

    public void initDefault() {
        this.mTitleBarLayout.setTitle(this.getResources().getString(R.string.conversation_title), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBarLayout.getLeftGroup().setVisibility(8);
        this.mTitleBarLayout.setRightIcon(R.drawable.conversation_more);
        final ConversationListAdapter adapter = new ConversationListAdapter();
        this.mConversationList.setAdapter(adapter);
        ConversationManagerKit.getInstance().loadConversation(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                adapter.setDataProvider((ConversationProvider)data);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(ConversationLayout.this.getContext().getString(R.string.load_msg_error));
            }
        });
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBarLayout;
    }

    @Override
    public void setParentLayout(Object parent) {
    }

    @Override
    public ConversationListLayout getConversationList() {
        return this.mConversationList;
    }

    public void addConversationInfo(int position, ConversationInfo info) {
        this.mConversationList.getAdapter().addItem(position, info);
    }

    public void removeConversationInfo(int position) {
        this.mConversationList.getAdapter().removeItem(position);
    }

    @Override
    public void setConversationTop(int position, ConversationInfo conversation) {
        ConversationManagerKit.getInstance().setConversationTop(position, conversation);
    }

    @Override
    public void deleteConversation(int position, ConversationInfo conversation) {
        ConversationManagerKit.getInstance().deleteConversation(position, conversation);
    }
}

