/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationListLayout;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationProvider;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.holder.ConversationBaseHolder;
import com.tencent.qcloud.tim.uikit.modules.conversation.holder.ConversationCommonHolder;
import com.tencent.qcloud.tim.uikit.modules.conversation.holder.ConversationCustomHolder;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationProvider;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import java.util.ArrayList;
import java.util.List;

public class ConversationListAdapter
extends IConversationAdapter {
    private boolean mHasShowUnreadDot = true;
    private int mItemAvatarRadius = ScreenUtil.getPxByDp(5.0f);
    private int mTopTextSize;
    private int mBottomTextSize;
    private int mDateTextSize;
    private List<ConversationInfo> mDataSource = new ArrayList<ConversationInfo>();
    private ConversationListLayout.OnItemClickListener mOnItemClickListener;
    private ConversationListLayout.OnItemLongClickListener mOnItemLongClickListener;

    public void setOnItemClickListener(ConversationListLayout.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemLongClickListener(ConversationListLayout.OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
    }

    @Override
    public void setDataProvider(IConversationProvider provider) {
        this.mDataSource = provider.getDataSource();
        if (provider instanceof ConversationProvider) {
            provider.attachAdapter(this);
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)TUIKit.getAppContext());
        ConversationBaseHolder holder = null;
        if (viewType == 2) {
            View view = inflater.inflate(R.layout.conversation_custom_adapter, parent, false);
            holder = new ConversationCustomHolder(view);
        } else {
            View view = inflater.inflate(R.layout.conversation_adapter, parent, false);
            holder = new ConversationCommonHolder(view);
        }
        if (holder != null) {
            ((ConversationBaseHolder)holder).setAdapter(this);
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        final ConversationInfo conversationInfo = this.getItem(position);
        ConversationBaseHolder baseHolder = (ConversationBaseHolder)holder;
        switch (this.getItemViewType(position)) {
            case 2: {
                break;
            }
            default: {
                if (this.mOnItemClickListener != null) {
                    holder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            ConversationListAdapter.this.mOnItemClickListener.onItemClick(view, position, conversationInfo);
                        }
                    });
                }
                if (this.mOnItemLongClickListener == null) break;
                holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        ConversationListAdapter.this.mOnItemLongClickListener.OnItemLongClick(view, position, conversationInfo);
                        return true;
                    }
                });
            }
        }
        baseHolder.layoutViews(conversationInfo, position);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        if (holder instanceof ConversationCommonHolder) {
            ((ConversationCommonHolder)holder).conversationIconView.setBackground(null);
        }
    }

    @Override
    public ConversationInfo getItem(int position) {
        if (this.mDataSource.size() == 0) {
            return null;
        }
        return this.mDataSource.get(position);
    }

    public int getItemCount() {
        return this.mDataSource.size();
    }

    public int getItemViewType(int position) {
        if (this.mDataSource != null) {
            ConversationInfo conversation = this.mDataSource.get(position);
            return conversation.getType();
        }
        return 1;
    }

    public void addItem(int position, ConversationInfo info) {
        this.mDataSource.add(position, info);
        this.notifyItemInserted(position);
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.mDataSource.remove(position);
        this.notifyItemRemoved(position);
        this.notifyDataSetChanged();
    }

    public void notifyDataSourceChanged(String info) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!TextUtils.equals((CharSequence)info, (CharSequence)this.mDataSource.get(i).getConversationId())) continue;
            this.notifyItemChanged(i);
            return;
        }
    }

    public void setItemTopTextSize(int size) {
        this.mTopTextSize = size;
    }

    public int getItemTopTextSize() {
        return this.mTopTextSize;
    }

    public void setItemBottomTextSize(int size) {
        this.mBottomTextSize = size;
    }

    public int getItemBottomTextSize() {
        return this.mBottomTextSize;
    }

    public void setItemDateTextSize(int size) {
        this.mDateTextSize = size;
    }

    public int getItemDateTextSize() {
        return this.mDateTextSize;
    }

    public void setItemAvatarRadius(int radius) {
        this.mItemAvatarRadius = radius;
    }

    public int getItemAvatarRadius() {
        return this.mItemAvatarRadius;
    }

    public void disableItemUnreadDot(boolean flag) {
        this.mHasShowUnreadDot = !flag;
    }

    public boolean hasItemUnreadDot() {
        return this.mHasShowUnreadDot;
    }
}

