/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.qcloud.tim.uikit.component.CustomLinearLayoutManager;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationListAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationListLayout;

public class ConversationListLayout
extends RecyclerView
implements IConversationListLayout {
    private ConversationListAdapter mAdapter;

    public ConversationListLayout(Context context) {
        super(context);
        this.init();
    }

    public ConversationListLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConversationListLayout(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void init() {
        this.setLayoutFrozen(false);
        this.setItemViewCacheSize(0);
        this.setHasFixedSize(true);
        this.setFocusableInTouchMode(false);
        CustomLinearLayoutManager linearLayoutManager = new CustomLinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(1);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
    }

    @Override
    public void setBackground(int resId) {
        this.setBackgroundColor(resId);
    }

    @Override
    public void disableItemUnreadDot(boolean flag) {
        this.mAdapter.disableItemUnreadDot(flag);
    }

    @Override
    public void setItemAvatarRadius(int radius) {
        this.mAdapter.setItemAvatarRadius(radius);
    }

    @Override
    public void setItemTopTextSize(int size) {
        this.mAdapter.setItemTopTextSize(size);
    }

    @Override
    public void setItemBottomTextSize(int size) {
        this.mAdapter.setItemBottomTextSize(size);
    }

    @Override
    public void setItemDateTextSize(int size) {
        this.mAdapter.setItemDateTextSize(size);
    }

    @Override
    public ConversationListLayout getListLayout() {
        return this;
    }

    @Override
    public ConversationListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(IConversationAdapter adapter) {
        super.setAdapter((RecyclerView.Adapter)adapter);
        this.mAdapter = (ConversationListAdapter)adapter;
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mAdapter.setOnItemClickListener(listener);
    }

    @Override
    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mAdapter.setOnItemLongClickListener(listener);
    }

    public static interface OnItemLongClickListener {
        public void OnItemLongClick(View var1, int var2, ConversationInfo var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2, ConversationInfo var3);
    }
}

