/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMConversation;
import com.tencent.imsdk.v2.V2TIMConversationResult;
import com.tencent.imsdk.v2.V2TIMGroupAtInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfoResult;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationProvider;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.modules.message.MessageRevokedManager;
import com.tencent.qcloud.tim.uikit.utils.SharedPreferenceUtils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ConversationManagerKit
implements MessageRevokedManager.MessageRevokeHandler {
    private static final String TAG = ConversationManagerKit.class.getSimpleName();
    private static final String SP_NAME = "_top_conversion_list";
    private static final String SP_IMAGE = "_conversation_group_face";
    private static final String TOP_LIST = "top_list";
    private static ConversationManagerKit instance = new ConversationManagerKit();
    private ConversationProvider mProvider;
    private List<MessageUnreadWatcher> mUnreadWatchers = new ArrayList<MessageUnreadWatcher>();
    private SharedPreferences mConversationPreferences;
    private LinkedList<ConversationInfo> mTopLinkedList = new LinkedList();
    private int mUnreadTotal;

    private ConversationManagerKit() {
        this.init();
    }

    public static ConversationManagerKit getInstance() {
        return instance;
    }

    private void init() {
        TUIKitLog.i(TAG, "init");
        MessageRevokedManager.getInstance().addHandler(this);
    }

    public void loadConversation(final IUIKitCallBack callBack) {
        TUIKitLog.i(TAG, "loadConversation callBack:" + callBack);
        this.mConversationPreferences = TUIKit.getAppContext().getSharedPreferences(TUIKitConfigs.getConfigs().getGeneralConfig().getSDKAppId() + "-" + V2TIMManager.getInstance().getLoginUser() + SP_NAME, 0);
        this.mTopLinkedList = SharedPreferenceUtils.getListData(this.mConversationPreferences, TOP_LIST, ConversationInfo.class);
        if (this.mProvider == null) {
            this.mProvider = new ConversationProvider();
        }
        V2TIMManager.getConversationManager().getConversationList(0L, 100, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMConversationResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.v(TAG, "loadConversation getConversationList error, code = " + code + ", desc = " + desc);
            }

            public void onSuccess(V2TIMConversationResult v2TIMConversationResult) {
                ArrayList<ConversationInfo> infos = new ArrayList<ConversationInfo>();
                List v2TIMConversationList = v2TIMConversationResult.getConversationList();
                ConversationManagerKit.this.mUnreadTotal = 0;
                for (V2TIMConversation v2TIMConversation : v2TIMConversationList) {
                    ConversationInfo conversationInfo = ConversationManagerKit.this.TIMConversation2ConversationInfo(v2TIMConversation);
                    if (conversationInfo == null || "AVChatRoom".equals(v2TIMConversation.getGroupType())) continue;
                    ConversationManagerKit.this.mUnreadTotal = ConversationManagerKit.this.mUnreadTotal + conversationInfo.getUnRead();
                    conversationInfo.setType(1);
                    infos.add(conversationInfo);
                }
                ConversationManagerKit.this.mProvider.setDataSource(ConversationManagerKit.this.sortConversations(infos));
                SharedPreferenceUtils.putListData(ConversationManagerKit.this.mConversationPreferences, ConversationManagerKit.TOP_LIST, ConversationManagerKit.this.mTopLinkedList);
                ConversationManagerKit.this.updateUnreadTotal(ConversationManagerKit.this.mUnreadTotal);
                if (callBack != null) {
                    callBack.onSuccess(ConversationManagerKit.this.mProvider);
                }
            }
        });
    }

    public void onRefreshConversation(List<V2TIMConversation> v2TIMConversationList) {
        TUIKitLog.v(TAG, "onRefreshConversation conversations:" + v2TIMConversationList);
        if (this.mProvider == null) {
            return;
        }
        ArrayList<ConversationInfo> infos = new ArrayList<ConversationInfo>();
        for (int i = 0; i < v2TIMConversationList.size(); ++i) {
            V2TIMConversation v2TIMConversation = v2TIMConversationList.get(i);
            TUIKitLog.v(TAG, "refreshConversation v2TIMConversation " + v2TIMConversation.toString());
            ConversationInfo conversationInfo = this.TIMConversation2ConversationInfo(v2TIMConversation);
            if (conversationInfo == null || "AVChatRoom".equals(v2TIMConversation.getGroupType())) continue;
            infos.add(conversationInfo);
        }
        if (infos.size() == 0) {
            return;
        }
        List<ConversationInfo> dataSource = this.mProvider.getDataSource();
        ArrayList<ConversationInfo> exists = new ArrayList<ConversationInfo>();
        for (int j = 0; j < infos.size(); ++j) {
            ConversationInfo update = (ConversationInfo)infos.get(j);
            boolean exist = false;
            for (int i = 0; i < dataSource.size(); ++i) {
                ConversationInfo cacheInfo = dataSource.get(i);
                if (!cacheInfo.getId().equals(update.getId()) || cacheInfo.isGroup() != update.isGroup()) continue;
                dataSource.remove(i);
                dataSource.add(i, update);
                exists.add(update);
                this.mUnreadTotal = this.mUnreadTotal - cacheInfo.getUnRead() + update.getUnRead();
                TUIKitLog.v(TAG, "onRefreshConversation after mUnreadTotal = " + this.mUnreadTotal);
                exist = true;
                break;
            }
            if (exist) continue;
            this.mUnreadTotal += update.getUnRead();
            TUIKitLog.i(TAG, "onRefreshConversation exist = " + exist + ", mUnreadTotal = " + this.mUnreadTotal);
        }
        this.updateUnreadTotal(this.mUnreadTotal);
        infos.removeAll(exists);
        if (infos.size() > 0) {
            dataSource.addAll(infos);
        }
        this.mProvider.setDataSource(this.sortConversations(dataSource));
        SharedPreferenceUtils.putListData(this.mConversationPreferences, TOP_LIST, this.mTopLinkedList);
    }

    private ConversationInfo TIMConversation2ConversationInfo(V2TIMConversation conversation) {
        if (conversation == null) {
            return null;
        }
        TUIKitLog.i(TAG, "TIMConversation2ConversationInfo id:" + conversation.getConversationID() + "|name:" + conversation.getShowName() + "|unreadNum:" + conversation.getUnreadCount());
        V2TIMMessage message = conversation.getLastMessage();
        if (message == null) {
            return null;
        }
        ConversationInfo info = new ConversationInfo();
        int type = conversation.getType();
        if (type != 1 && type != 2) {
            return null;
        }
        boolean isGroup = type == 2;
        info.setLastMessageTime(message.getTimestamp());
        List<MessageInfo> list = MessageInfoUtil.TIMMessage2MessageInfo(message);
        if (list != null && list.size() > 0) {
            info.setLastMessage(list.get(list.size() - 1));
        }
        int atInfoType = this.getAtInfoType(conversation);
        switch (atInfoType) {
            case 1: {
                info.setAtInfoText(TUIKit.getAppContext().getString(R.string.ui_at_me));
                break;
            }
            case 2: {
                info.setAtInfoText(TUIKit.getAppContext().getString(R.string.ui_at_all));
                break;
            }
            case 3: {
                info.setAtInfoText(TUIKit.getAppContext().getString(R.string.ui_at_all_me));
                break;
            }
            default: {
                info.setAtInfoText("");
            }
        }
        info.setTitle(conversation.getShowName());
        if (isGroup) {
            this.fillConversationUrlForGroup(conversation, info);
        } else {
            ArrayList<Object> faceList = new ArrayList<Object>();
            if (TextUtils.isEmpty((CharSequence)conversation.getFaceUrl())) {
                faceList.add(R.drawable.default_head);
            } else {
                faceList.add(conversation.getFaceUrl());
            }
            info.setIconUrlList(faceList);
        }
        if (isGroup) {
            info.setId(conversation.getGroupID());
        } else {
            info.setId(conversation.getUserID());
        }
        info.setConversationId(conversation.getConversationID());
        info.setGroup(isGroup);
        if (!"Meeting".equals(conversation.getGroupType()) && !"AVChatRoom".equals(conversation.getGroupType())) {
            info.setUnRead(conversation.getUnreadCount());
        }
        return info;
    }

    private int getAtInfoType(V2TIMConversation conversation) {
        int atInfoType = 0;
        boolean atMe = false;
        boolean atAll = false;
        List atInfoList = conversation.getGroupAtInfoList();
        if (atInfoList == null || atInfoList.isEmpty()) {
            return 0;
        }
        for (V2TIMGroupAtInfo atInfo : atInfoList) {
            if (atInfo.getAtType() == 1) {
                atMe = true;
                continue;
            }
            if (atInfo.getAtType() == 2) {
                atAll = true;
                continue;
            }
            if (atInfo.getAtType() != 3) continue;
            atMe = true;
            atAll = true;
        }
        atInfoType = atAll && atMe ? 3 : (atAll ? 2 : (atMe ? 1 : 0));
        return atInfoType;
    }

    private void fillConversationUrlForGroup(V2TIMConversation conversation, ConversationInfo info) {
        if (TextUtils.isEmpty((CharSequence)conversation.getFaceUrl())) {
            String savedIcon = this.getGroupConversationAvatar(conversation.getConversationID());
            if (TextUtils.isEmpty((CharSequence)savedIcon)) {
                this.fillFaceUrlList(conversation.getGroupID(), info);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(savedIcon);
                info.setIconUrlList(list);
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(conversation.getFaceUrl());
            info.setIconUrlList(list);
        }
    }

    private void fillFaceUrlList(final String groupID, final ConversationInfo info) {
        V2TIMManager.getGroupManager().getGroupMemberList(groupID, 0, 0L, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMGroupMemberInfoResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getGroupMemberList failed! groupID:" + groupID + "|code:" + code + "|desc: " + desc);
            }

            public void onSuccess(V2TIMGroupMemberInfoResult v2TIMGroupMemberInfoResult) {
                List v2TIMGroupMemberFullInfoList = v2TIMGroupMemberInfoResult.getMemberInfoList();
                int faceSize = v2TIMGroupMemberFullInfoList.size() > 9 ? 9 : v2TIMGroupMemberFullInfoList.size();
                ArrayList<Object> urlList = new ArrayList<Object>();
                for (int i = 0; i < faceSize; ++i) {
                    V2TIMGroupMemberFullInfo v2TIMGroupMemberFullInfo = (V2TIMGroupMemberFullInfo)v2TIMGroupMemberFullInfoList.get(i);
                    if (TextUtils.isEmpty((CharSequence)v2TIMGroupMemberFullInfo.getFaceUrl())) {
                        urlList.add(R.drawable.default_head);
                        continue;
                    }
                    urlList.add(v2TIMGroupMemberFullInfo.getFaceUrl());
                }
                info.setIconUrlList(urlList);
                ConversationManagerKit.this.mProvider.updateAdapter(info.getConversationId());
            }
        });
    }

    public void setConversationTop(int index, ConversationInfo conversation) {
        TUIKitLog.i(TAG, "setConversationTop index:" + index + "|conversation:" + conversation);
        if (!conversation.isTop()) {
            this.mTopLinkedList.remove(conversation);
            this.mTopLinkedList.addFirst(conversation);
            conversation.setTop(true);
        } else {
            conversation.setTop(false);
            this.mTopLinkedList.remove(conversation);
        }
        this.mProvider.setDataSource(this.sortConversations(this.mProvider.getDataSource()));
        SharedPreferenceUtils.putListData(this.mConversationPreferences, TOP_LIST, this.mTopLinkedList);
    }

    public void setConversationTop(String id2, boolean flag) {
        TUIKitLog.i(TAG, "setConversationTop id:" + id2 + "|flag:" + flag);
        this.handleTopData(id2, flag);
        this.mProvider.setDataSource(this.sortConversations(this.mProvider.getDataSource()));
        SharedPreferenceUtils.putListData(this.mConversationPreferences, TOP_LIST, this.mTopLinkedList);
    }

    private boolean isTop(String id2) {
        if (this.mTopLinkedList == null || this.mTopLinkedList.size() == 0) {
            return false;
        }
        for (ConversationInfo info : this.mTopLinkedList) {
            if (!TextUtils.equals((CharSequence)info.getId(), (CharSequence)id2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTopData(String id2, boolean flag) {
        ConversationInfo conversation = null;
        List<ConversationInfo> conversationInfos = this.mProvider.getDataSource();
        for (int i = 0; i < conversationInfos.size(); ++i) {
            ConversationInfo info = conversationInfos.get(i);
            if (!info.getId().equals(id2)) continue;
            conversation = info;
            break;
        }
        if (conversation == null) {
            return;
        }
        if (flag) {
            if (this.isTop(conversation.getId())) return;
            this.mTopLinkedList.remove(conversation);
            this.mTopLinkedList.addFirst(conversation);
            conversation.setTop(true);
        } else {
            if (!this.isTop(conversation.getId())) return;
            conversation.setTop(false);
            this.mTopLinkedList.remove(conversation);
        }
        SharedPreferenceUtils.putListData(this.mConversationPreferences, TOP_LIST, this.mTopLinkedList);
    }

    public void deleteConversation(int index, ConversationInfo conversation) {
        TUIKitLog.i(TAG, "deleteConversation index:" + index + "|conversation:" + conversation);
        V2TIMManager.getConversationManager().deleteConversation(conversation.getConversationId(), new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "deleteConversation error:" + code + ", desc:" + desc);
            }

            public void onSuccess() {
                TUIKitLog.i(TAG, "deleteConversation success");
            }
        });
        this.handleTopData(conversation.getId(), false);
        this.mProvider.deleteConversation(index);
        this.updateUnreadTotal(this.mUnreadTotal - conversation.getUnRead());
    }

    public void deleteConversation(String id2, boolean isGroup) {
        TUIKitLog.i(TAG, "deleteConversation id:" + id2 + "|isGroup:" + isGroup);
        this.handleTopData(id2, false);
        List<ConversationInfo> conversationInfos = this.mProvider.getDataSource();
        for (int i = 0; i < conversationInfos.size(); ++i) {
            ConversationInfo info = conversationInfos.get(i);
            if (!info.getId().equals(id2)) continue;
            this.updateUnreadTotal(this.mUnreadTotal - info.getUnRead());
            break;
        }
        String conversationID = "";
        if (this.mProvider != null) {
            List<ConversationInfo> conversationInfoList = this.mProvider.getDataSource();
            for (ConversationInfo conversationInfo : conversationInfoList) {
                if (isGroup != conversationInfo.isGroup() || !conversationInfo.getId().equals(id2)) continue;
                conversationID = conversationInfo.getConversationId();
                break;
            }
            if (!TextUtils.isEmpty((CharSequence)conversationID)) {
                this.mProvider.deleteConversation(conversationID);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)conversationID)) {
            V2TIMManager.getConversationManager().deleteConversation(conversationID, new V2TIMCallback(){

                public void onError(int code, String desc) {
                    TUIKitLog.i(TAG, "deleteConversation error:" + code + ", desc:" + desc);
                }

                public void onSuccess() {
                    TUIKitLog.i(TAG, "deleteConversation success");
                }
            });
        }
    }

    public boolean addConversation(ConversationInfo conversationInfo) {
        ArrayList<ConversationInfo> conversationInfos = new ArrayList<ConversationInfo>();
        conversationInfos.add(conversationInfo);
        return this.mProvider.addConversations(conversationInfos);
    }

    private List<ConversationInfo> sortConversations(List<ConversationInfo> sources) {
        ArrayList<ConversationInfo> conversationInfos = new ArrayList<ConversationInfo>();
        ArrayList<ConversationInfo> normalConversations = new ArrayList<ConversationInfo>();
        ArrayList<ConversationInfo> topConversations = new ArrayList<ConversationInfo>();
        for (int i = 0; i <= sources.size() - 1; ++i) {
            ConversationInfo conversation = sources.get(i);
            if (this.isTop(conversation.getId())) {
                conversation.setTop(true);
                topConversations.add(conversation);
                continue;
            }
            normalConversations.add(conversation);
        }
        this.mTopLinkedList.clear();
        this.mTopLinkedList.addAll(topConversations);
        if (topConversations != null && topConversations.size() > 1) {
            Collections.sort(topConversations);
        }
        conversationInfos.addAll(topConversations);
        if (normalConversations != null && normalConversations.size() > 1) {
            Collections.sort(normalConversations);
        }
        conversationInfos.addAll(normalConversations);
        return conversationInfos;
    }

    public void updateUnreadTotal(int unreadTotal) {
        TUIKitLog.i(TAG, "updateUnreadTotal:" + unreadTotal);
        this.mUnreadTotal = unreadTotal;
        for (int i = 0; i < this.mUnreadWatchers.size(); ++i) {
            this.mUnreadWatchers.get(i).updateUnread(this.mUnreadTotal);
        }
    }

    public int getUnreadTotal() {
        return this.mUnreadTotal;
    }

    public boolean isTopConversation(String groupId) {
        TUIKitLog.i(TAG, "isTopConversation:" + groupId);
        return this.isTop(groupId);
    }

    @Override
    public void handleInvoke(String msgID) {
        TUIKitLog.i(TAG, "handleInvoke msgID:" + msgID);
        if (this.mProvider != null) {
            this.loadConversation(null);
        }
    }

    public void addUnreadWatcher(MessageUnreadWatcher messageUnreadWatcher) {
        TUIKitLog.i(TAG, "addUnreadWatcher:" + messageUnreadWatcher);
        if (!this.mUnreadWatchers.contains(messageUnreadWatcher)) {
            this.mUnreadWatchers.add(messageUnreadWatcher);
            messageUnreadWatcher.updateUnread(this.mUnreadTotal);
        }
    }

    public void removeUnreadWatcher(MessageUnreadWatcher messageUnreadWatcher) {
        TUIKitLog.i(TAG, "removeUnreadWatcher:" + messageUnreadWatcher);
        if (messageUnreadWatcher == null) {
            this.mUnreadWatchers.clear();
        } else {
            this.mUnreadWatchers.remove(messageUnreadWatcher);
        }
    }

    public void destroyConversation() {
        TUIKitLog.i(TAG, "destroyConversation");
        if (this.mProvider != null) {
            this.mProvider.attachAdapter(null);
        }
        if (this.mUnreadWatchers != null) {
            this.mUnreadWatchers.clear();
        }
    }

    public String getGroupConversationAvatar(String groupId) {
        SharedPreferences sp = TUIKit.getAppContext().getSharedPreferences(TUIKitConfigs.getConfigs().getGeneralConfig().getSDKAppId() + SP_IMAGE, 0);
        String savedIcon = sp.getString(groupId, "");
        if (!TextUtils.isEmpty((CharSequence)savedIcon) && new File(savedIcon).isFile() && new File(savedIcon).exists()) {
            return savedIcon;
        }
        return "";
    }

    public void setGroupConversationAvatar(String groupId, String url) {
        SharedPreferences sp = TUIKit.getAppContext().getSharedPreferences(TUIKitConfigs.getConfigs().getGeneralConfig().getSDKAppId() + SP_IMAGE, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(groupId, url);
        editor.apply();
    }

    public static interface MessageUnreadWatcher {
        public void updateUnread(int var1);
    }
}

