/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation;

import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationListAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationAdapter;
import com.tencent.qcloud.tim.uikit.modules.conversation.interfaces.IConversationProvider;
import java.util.ArrayList;
import java.util.List;

public class ConversationProvider
implements IConversationProvider {
    private ArrayList<ConversationInfo> mDataSource = new ArrayList();
    private ConversationListAdapter mAdapter;

    @Override
    public List<ConversationInfo> getDataSource() {
        return this.mDataSource;
    }

    public void setDataSource(List<ConversationInfo> dataSource) {
        this.mDataSource.clear();
        this.mDataSource.addAll(dataSource);
        this.updateAdapter();
    }

    @Override
    public boolean addConversations(List<ConversationInfo> conversations) {
        boolean flag;
        if (conversations.size() == 1) {
            ConversationInfo conversation = conversations.get(0);
            for (int i = 0; i < this.mDataSource.size(); ++i) {
                if (!this.mDataSource.get(i).getId().equals(conversation.getId())) continue;
                return true;
            }
        }
        if (flag = this.mDataSource.addAll(conversations)) {
            this.updateAdapter();
        }
        return flag;
    }

    @Override
    public boolean deleteConversations(List<ConversationInfo> conversations) {
        int i;
        ArrayList<Integer> removeIndexs = new ArrayList<Integer>();
        block0: for (i = 0; i < this.mDataSource.size(); ++i) {
            for (int j = 0; j < conversations.size(); ++j) {
                if (!this.mDataSource.get(i).getId().equals(conversations.get(j).getId())) continue;
                removeIndexs.add(i);
                conversations.remove(j);
                continue block0;
            }
        }
        if (removeIndexs.size() > 0) {
            for (i = 0; i < removeIndexs.size(); ++i) {
                this.mDataSource.remove(removeIndexs.get(i));
            }
            this.updateAdapter();
            return true;
        }
        return false;
    }

    public void deleteConversation(int index) {
        if (this.mDataSource.remove(index) != null) {
            this.updateAdapter();
        }
    }

    public void deleteConversation(String conversationID) {
        for (int i = 0; i < this.mDataSource.size(); ++i) {
            if (!this.mDataSource.get(i).getConversationId().equals(conversationID)) continue;
            if (this.mDataSource.remove(i) != null) {
                this.updateAdapter();
            }
            return;
        }
    }

    @Override
    public boolean updateConversations(List<ConversationInfo> conversations) {
        boolean flag = false;
        block0: for (int i = 0; i < this.mDataSource.size(); ++i) {
            for (int j = 0; j < conversations.size(); ++j) {
                ConversationInfo update = conversations.get(j);
                if (!this.mDataSource.get(i).getId().equals(update.getId())) continue;
                this.mDataSource.remove(i);
                this.mDataSource.add(i, update);
                conversations.remove(j);
                flag = true;
                continue block0;
            }
        }
        if (flag) {
            this.updateAdapter();
            return true;
        }
        return false;
    }

    public void clear() {
        this.mDataSource.clear();
        this.updateAdapter();
        this.mAdapter = null;
    }

    public void updateAdapter() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateAdapter(String id2) {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSourceChanged(id2);
        }
    }

    @Override
    public void attachAdapter(IConversationAdapter adapter) {
        this.mAdapter = (ConversationListAdapter)adapter;
    }
}

