/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.gatherimage.SynthesizedImageView;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.DynamicConversationIconView;
import com.tencent.qcloud.tim.uikit.utils.ImageUtil;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import java.util.List;

public class ConversationIconView
extends RelativeLayout {
    private static final int icon_size = ScreenUtil.getPxByDp(50.0f);
    private ImageView mIconView;

    public ConversationIconView(Context context) {
        super(context);
        this.init();
    }

    public ConversationIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConversationIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void invokeInformation(ConversationInfo conversationInfo, DynamicConversationIconView infoView) {
        infoView.setLayout((ViewGroup)this);
        infoView.setMainViewId(R.id.profile_icon_group);
        infoView.parseInformation(conversationInfo);
    }

    private void init() {
        ConversationIconView.inflate((Context)this.getContext(), (int)R.layout.profile_icon_view, (ViewGroup)this);
        this.mIconView = (ImageView)this.findViewById(R.id.profile_icon);
        ((SynthesizedImageView)this.mIconView).defaultImage(0);
    }

    public void setProfileImageView(ImageView iconView) {
        this.mIconView = iconView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(icon_size, icon_size);
        params.addRule(13);
        this.addView((View)this.mIconView, (ViewGroup.LayoutParams)params);
    }

    public void setIconUrls(List<Object> iconUrls) {
        if (this.mIconView instanceof SynthesizedImageView) {
            ((SynthesizedImageView)this.mIconView).displayImage(iconUrls).load();
        }
    }

    public void setConversation(ConversationInfo c) {
        if (this.mIconView instanceof SynthesizedImageView) {
            ((SynthesizedImageView)this.mIconView).setImageId(c.getConversationId());
            this.setIconUrls(c.getIconUrlList());
        }
    }

    public void setRadius(int radius) {
        if (this.mIconView instanceof SynthesizedImageView) {
            ((SynthesizedImageView)this.mIconView).setRadius(radius);
        }
    }

    public void setDefaultImageResId(int resId) {
        BitmapDrawable bd = (BitmapDrawable)this.getContext().getResources().getDrawable(resId);
        this.mIconView.setImageBitmap(bd.getBitmap());
    }

    public void setBitmapResId(int resId) {
        BitmapDrawable bd = (BitmapDrawable)this.getContext().getResources().getDrawable(resId);
        Bitmap bitmap = ImageUtil.toRoundBitmap(bd.getBitmap());
        this.mIconView.setImageBitmap(bitmap);
    }
}

