/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation.holder;

import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationIconView;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.holder.ConversationBaseHolder;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.utils.DateTimeUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConversationCommonHolder
extends ConversationBaseHolder {
    public ConversationIconView conversationIconView;
    protected LinearLayout leftItemLayout;
    protected TextView titleText;
    protected TextView messageText;
    protected TextView timelineText;
    protected TextView unreadText;
    protected TextView atInfoText;

    public ConversationCommonHolder(View itemView) {
        super(itemView);
        this.leftItemLayout = (LinearLayout)this.rootView.findViewById(R.id.item_left);
        this.conversationIconView = (ConversationIconView)this.rootView.findViewById(R.id.conversation_icon);
        this.titleText = (TextView)this.rootView.findViewById(R.id.conversation_title);
        this.messageText = (TextView)this.rootView.findViewById(R.id.conversation_last_msg);
        this.timelineText = (TextView)this.rootView.findViewById(R.id.conversation_time);
        this.unreadText = (TextView)this.rootView.findViewById(R.id.conversation_unread);
        this.atInfoText = (TextView)this.rootView.findViewById(R.id.conversation_at_msg);
    }

    @Override
    public void layoutViews(ConversationInfo conversation, int position) {
        MessageInfo lastMsg = conversation.getLastMessage();
        if (lastMsg != null && lastMsg.getStatus() == 275) {
            if (lastMsg.isSelf()) {
                lastMsg.setExtra(TUIKit.getAppContext().getString(R.string.revoke_tips_you));
            } else if (lastMsg.isGroup()) {
                String message = TUIKitConstants.covert2HTMLString(TextUtils.isEmpty((CharSequence)lastMsg.getGroupNameCard()) ? lastMsg.getFromUser() : lastMsg.getGroupNameCard());
                lastMsg.setExtra(message + TUIKit.getAppContext().getString(R.string.revoke_tips));
            } else {
                lastMsg.setExtra(TUIKit.getAppContext().getString(R.string.revoke_tips_other));
            }
        }
        if (conversation.isTop()) {
            this.leftItemLayout.setBackgroundColor(this.rootView.getResources().getColor(R.color.conversation_top_color));
        } else {
            this.leftItemLayout.setBackgroundColor(-1);
        }
        this.titleText.setText((CharSequence)conversation.getTitle());
        this.messageText.setText((CharSequence)"");
        this.timelineText.setText((CharSequence)"");
        if (lastMsg != null) {
            if (lastMsg.getExtra() != null) {
                String result = ConversationCommonHolder.emojiJudge(lastMsg.getExtra().toString());
                this.messageText.setText((CharSequence)Html.fromHtml((String)result));
                this.messageText.setTextColor(this.rootView.getResources().getColor(R.color.list_bottom_text_bg));
            }
            this.timelineText.setText((CharSequence)DateTimeUtil.getTimeFormatText(new Date(lastMsg.getMsgTime() * 1000L)));
        }
        if (conversation.getUnRead() > 0) {
            this.unreadText.setVisibility(0);
            if (conversation.getUnRead() > 99) {
                this.unreadText.setText((CharSequence)"99+");
            } else {
                this.unreadText.setText((CharSequence)("" + conversation.getUnRead()));
            }
        } else {
            this.unreadText.setVisibility(8);
        }
        if (conversation.getAtInfoText().isEmpty()) {
            this.atInfoText.setVisibility(8);
        } else {
            this.atInfoText.setVisibility(0);
            this.atInfoText.setText((CharSequence)conversation.getAtInfoText());
            this.atInfoText.setTextColor(-65536);
        }
        this.conversationIconView.setRadius(this.mAdapter.getItemAvatarRadius());
        if (this.mAdapter.getItemDateTextSize() != 0) {
            this.timelineText.setTextSize((float)this.mAdapter.getItemDateTextSize());
        }
        if (this.mAdapter.getItemBottomTextSize() != 0) {
            this.messageText.setTextSize((float)this.mAdapter.getItemBottomTextSize());
        }
        if (this.mAdapter.getItemTopTextSize() != 0) {
            this.titleText.setTextSize((float)this.mAdapter.getItemTopTextSize());
        }
        if (!this.mAdapter.hasItemUnreadDot()) {
            this.unreadText.setVisibility(8);
        }
        if (conversation.getIconUrlList() != null) {
            this.conversationIconView.setConversation(conversation);
        }
        this.layoutVariableViews(conversation, position);
    }

    private static String emojiJudge(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        String[] emojiList = FaceManager.getEmojiFilters();
        if (emojiList == null || emojiList.length == 0) {
            return text;
        }
        SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)text);
        String regex = "\\[(\\S+?)\\]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        ArrayList<EmojiData> emojiDataArrayList = new ArrayList<EmojiData>();
        int lastMentionIndex = -1;
        while (m.find()) {
            int end;
            String emojiName = m.group();
            int start = lastMentionIndex != -1 ? text.indexOf(emojiName, lastMentionIndex) : text.indexOf(emojiName);
            lastMentionIndex = end = start + emojiName.length();
            int index = ConversationCommonHolder.findeEmoji(emojiName);
            String[] emojiListValues = FaceManager.getEmojiFiltersValues();
            if (index != -1 && emojiListValues != null && emojiListValues.length >= index) {
                emojiName = emojiListValues[index];
            }
            EmojiData emojiData = new EmojiData();
            emojiData.setStart(start);
            emojiData.setEnd(end);
            emojiData.setEmojiText(emojiName);
            emojiDataArrayList.add(emojiData);
        }
        if (emojiDataArrayList.isEmpty()) {
            return text;
        }
        for (int i = emojiDataArrayList.size() - 1; i >= 0; --i) {
            EmojiData emojiData = (EmojiData)emojiDataArrayList.get(i);
            String emojiName = emojiData.getEmojiText();
            int start = emojiData.getStart();
            int end = emojiData.getEnd();
            if (TextUtils.isEmpty((CharSequence)emojiName) || start == -1 || end == -1) continue;
            sb.replace(start, end, (CharSequence)emojiName);
        }
        return sb.toString();
    }

    private static int findeEmoji(String text) {
        int result = -1;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return result;
        }
        String[] emojiList = FaceManager.getEmojiFilters();
        if (emojiList == null || emojiList.length == 0) {
            return result;
        }
        for (int i = 0; i < emojiList.length; ++i) {
            if (!text.equals(emojiList[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    public void layoutVariableViews(ConversationInfo conversationInfo, int position) {
    }

    private static class EmojiData {
        private int start;
        private int end;
        private String emojiText;

        private EmojiData() {
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public String getEmojiText() {
            return this.emojiText;
        }

        public void setEmojiText(String emojiText) {
            this.emojiText = emojiText;
        }
    }
}

