/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.conversation.holder;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationIconView;
import com.tencent.qcloud.tim.uikit.modules.conversation.base.ConversationInfo;
import com.tencent.qcloud.tim.uikit.modules.conversation.holder.ConversationBaseHolder;

public class ConversationCustomHolder
extends ConversationBaseHolder {
    protected LinearLayout leftItemLayout;
    protected TextView titleText;
    protected TextView messageText;
    protected TextView timelineText;
    protected TextView unreadText;
    protected ConversationIconView conversationIconView;

    public ConversationCustomHolder(View itemView) {
        super(itemView);
        this.leftItemLayout = (LinearLayout)this.rootView.findViewById(R.id.item_left);
        this.conversationIconView = (ConversationIconView)this.rootView.findViewById(R.id.conversation_icon);
        this.titleText = (TextView)this.rootView.findViewById(R.id.conversation_title);
        this.messageText = (TextView)this.rootView.findViewById(R.id.conversation_last_msg);
        this.timelineText = (TextView)this.rootView.findViewById(R.id.conversation_time);
        this.unreadText = (TextView)this.rootView.findViewById(R.id.conversation_unread);
    }

    @Override
    public void layoutViews(ConversationInfo conversation, int position) {
        if (conversation.isTop()) {
            this.leftItemLayout.setBackgroundColor(this.rootView.getResources().getColor(R.color.conversation_top_color));
        } else {
            this.leftItemLayout.setBackgroundColor(-1);
        }
        this.conversationIconView.setConversation(conversation);
        this.titleText.setText((CharSequence)conversation.getTitle());
        this.messageText.setText((CharSequence)"");
        this.timelineText.setText((CharSequence)"");
        if (conversation.getUnRead() > 0) {
            this.unreadText.setVisibility(0);
            if (conversation.getUnRead() > 99) {
                this.unreadText.setText((CharSequence)"99+");
            } else {
                this.unreadText.setText((CharSequence)("" + conversation.getUnRead()));
            }
        } else {
            this.unreadText.setVisibility(8);
        }
        if (this.mAdapter.getItemDateTextSize() != 0) {
            this.timelineText.setTextSize((float)this.mAdapter.getItemDateTextSize());
        }
        if (this.mAdapter.getItemBottomTextSize() != 0) {
            this.messageText.setTextSize((float)this.mAdapter.getItemBottomTextSize());
        }
        if (this.mAdapter.getItemTopTextSize() != 0) {
            this.titleText.setTextSize((float)this.mAdapter.getItemTopTextSize());
        }
    }
}

