/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.apply;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupApplyAdapter
extends BaseAdapter {
    private List<GroupApplyInfo> mGroupMembers = new ArrayList<GroupApplyInfo>();
    private GroupInfoProvider mProvider;
    private OnItemClickListener mOnItemClickListener;

    public int getCount() {
        return this.mGroupMembers.size();
    }

    public int getUnHandledSize() {
        int total = 0;
        for (GroupApplyInfo i : this.mGroupMembers) {
            if (i.getStatus() != 0) continue;
            ++total;
        }
        return total;
    }

    public GroupApplyInfo getItem(int i) {
        return this.mGroupMembers.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(final int i, View view, ViewGroup viewGroup) {
        MyViewHolder holder;
        final GroupApplyInfo info = this.getItem(i);
        if (view == null) {
            view = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.group_member_apply_adpater, viewGroup, false);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GroupApplyAdapter.this.mOnItemClickListener != null && info.getStatus() == 0) {
                        GroupApplyAdapter.this.mOnItemClickListener.onItemClick(info);
                    }
                }
            });
            holder = new MyViewHolder();
            holder.memberIcon = (ImageView)view.findViewById(R.id.group_apply_member_icon);
            holder.memberName = (TextView)view.findViewById(R.id.group_apply_member_name);
            holder.reason = (TextView)view.findViewById(R.id.group_apply_reason);
            holder.accept = (Button)view.findViewById(R.id.group_apply_accept);
            holder.refuse = (Button)view.findViewById(R.id.group_apply_refuse);
            view.setTag((Object)holder);
        } else {
            holder = (MyViewHolder)view.getTag();
        }
        holder.memberName.setText((CharSequence)info.getGroupApplication().getFromUser());
        holder.reason.setText((CharSequence)info.getGroupApplication().getRequestMsg());
        if (info.getStatus() == 0) {
            holder.accept.setVisibility(0);
            holder.accept.setText(R.string.accept);
            holder.accept.setBackground(TUIKit.getAppContext().getResources().getDrawable(R.color.bg_positive_btn));
            holder.accept.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GroupApplyAdapter.this.acceptApply(i, info);
                }
            });
            holder.refuse.setVisibility(0);
            holder.refuse.setText(R.string.refuse);
            holder.refuse.setBackground(TUIKit.getAppContext().getResources().getDrawable(R.color.bg_negative_btn));
            holder.refuse.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GroupApplyAdapter.this.refuseApply(i, info);
                }
            });
        } else if (info.getStatus() == 1) {
            holder.accept.setVisibility(0);
            holder.accept.setClickable(false);
            holder.accept.setText(R.string.accepted);
            holder.accept.setBackground(TUIKit.getAppContext().getResources().getDrawable(R.drawable.gray_btn_bg));
            holder.refuse.setVisibility(8);
        } else if (info.getStatus() == -1) {
            holder.refuse.setVisibility(0);
            holder.refuse.setClickable(false);
            holder.refuse.setText(R.string.refused);
            holder.refuse.setBackground(TUIKit.getAppContext().getResources().getDrawable(R.drawable.gray_btn_bg));
            holder.accept.setVisibility(8);
        }
        return view;
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mOnItemClickListener = l;
    }

    public void updateItemData(GroupApplyInfo info) {
        for (GroupApplyInfo i : this.mGroupMembers) {
            if (!TextUtils.equals((CharSequence)i.getGroupApplication().getFromUser(), (CharSequence)info.getGroupApplication().getFromUser())) continue;
            i.setStatus(info.getStatus());
            this.notifyDataSetChanged();
            break;
        }
    }

    public void setDataSource(GroupInfo info) {
        this.mProvider = GroupChatManagerKit.getInstance().getProvider();
        this.mGroupMembers = this.mProvider.getApplyList();
    }

    public void acceptApply(int position, GroupApplyInfo item) {
        this.mProvider.acceptApply(item, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupApplyAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void refuseApply(int position, GroupApplyInfo item) {
        this.mProvider.refuseApply(item, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupApplyAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    private class MyViewHolder {
        private ImageView memberIcon;
        private TextView memberName;
        private TextView reason;
        private Button accept;
        private Button refuse;

        private MyViewHolder() {
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(GroupApplyInfo var1);
    }
}

