/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.apply;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyAdapter;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyInfo;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyMemberActivity;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.interfaces.IGroupMemberLayout;
import java.io.Serializable;

public class GroupApplyManagerLayout
extends LinearLayout
implements IGroupMemberLayout {
    private TitleBarLayout mTitleBar;
    private ListView mApplyMemberList;
    private GroupApplyAdapter mAdapter;

    public GroupApplyManagerLayout(Context context) {
        super(context);
        this.init();
    }

    public GroupApplyManagerLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupApplyManagerLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GroupApplyManagerLayout.inflate((Context)this.getContext(), (int)R.layout.group_apply_manager_layout, (ViewGroup)this);
        this.mApplyMemberList = (ListView)this.findViewById(R.id.group_apply_members);
        this.mAdapter = new GroupApplyAdapter();
        this.mAdapter.setOnItemClickListener(new GroupApplyAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(GroupApplyInfo info) {
                Intent intent = new Intent(GroupApplyManagerLayout.this.getContext(), GroupApplyMemberActivity.class);
                intent.putExtra("content", (Serializable)info);
                ((Activity)GroupApplyManagerLayout.this.getContext()).startActivityForResult(intent, 1);
            }
        });
        this.mApplyMemberList.setAdapter((ListAdapter)this.mAdapter);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_apply_title_bar);
        this.mTitleBar.getRightGroup().setVisibility(8);
        this.mTitleBar.setTitle(this.getResources().getString(R.string.group_apply_members), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBar.setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GroupChatManagerKit.getInstance().onApplied(GroupApplyManagerLayout.this.mAdapter.getUnHandledSize());
                if (GroupApplyManagerLayout.this.getContext() instanceof Activity) {
                    ((Activity)GroupApplyManagerLayout.this.getContext()).finish();
                }
            }
        });
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
    }

    @Override
    public void setDataSource(GroupInfo dataSource) {
        this.mAdapter.setDataSource(dataSource);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateItemData(GroupApplyInfo info) {
        this.mAdapter.updateItemData(info);
    }
}

