/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.info;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.IGroupMemberRouter;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import java.util.ArrayList;
import java.util.List;

public class GroupInfoAdapter
extends BaseAdapter {
    private static final int ADD_TYPE = -100;
    private static final int DEL_TYPE = -101;
    private static final int OWNER_PRIVATE_MAX_LIMIT = 10;
    private static final int OWNER_PUBLIC_MAX_LIMIT = 11;
    private static final int OWNER_CHATROOM_MAX_LIMIT = 11;
    private static final int NORMAL_PRIVATE_MAX_LIMIT = 11;
    private static final int NORMAL_PUBLIC_MAX_LIMIT = 12;
    private static final int NORMAL_CHATROOM_MAX_LIMIT = 12;
    private List<GroupMemberInfo> mGroupMembers = new ArrayList<GroupMemberInfo>();
    private IGroupMemberRouter mTailListener;
    private GroupInfo mGroupInfo;

    public void setManagerCallBack(IGroupMemberRouter listener) {
        this.mTailListener = listener;
    }

    public int getCount() {
        return this.mGroupMembers.size();
    }

    public GroupMemberInfo getItem(int i) {
        return this.mGroupMembers.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        MyViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.group_member_adpater, viewGroup, false);
            holder = new MyViewHolder();
            holder.memberIcon = (ImageView)view.findViewById(R.id.group_member_icon);
            holder.memberName = (TextView)view.findViewById(R.id.group_member_name);
            view.setTag((Object)holder);
        } else {
            holder = (MyViewHolder)view.getTag();
        }
        GroupMemberInfo info = this.getItem(i);
        if (!TextUtils.isEmpty((CharSequence)info.getIconUrl())) {
            GlideEngine.loadImage(holder.memberIcon, info.getIconUrl(), null);
        }
        if (!TextUtils.isEmpty((CharSequence)info.getAccount())) {
            holder.memberName.setText((CharSequence)info.getAccount());
        } else {
            holder.memberName.setText((CharSequence)"");
        }
        view.setOnClickListener(null);
        holder.memberIcon.setBackground(null);
        if (info.getMemberType() == -100) {
            holder.memberIcon.setImageResource(R.drawable.add_group_member);
            holder.memberIcon.setBackgroundResource(R.drawable.bottom_action_border);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GroupInfoAdapter.this.mTailListener != null) {
                        GroupInfoAdapter.this.mTailListener.forwardAddMember(GroupInfoAdapter.this.mGroupInfo);
                    }
                }
            });
        } else if (info.getMemberType() == -101) {
            holder.memberIcon.setImageResource(R.drawable.del_group_member);
            holder.memberIcon.setBackgroundResource(R.drawable.bottom_action_border);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GroupInfoAdapter.this.mTailListener != null) {
                        GroupInfoAdapter.this.mTailListener.forwardDeleteMember(GroupInfoAdapter.this.mGroupInfo);
                    }
                }
            });
        }
        return view;
    }

    public void setDataSource(GroupInfo info) {
        this.mGroupInfo = info;
        this.mGroupMembers.clear();
        List<GroupMemberInfo> members = info.getMemberDetails();
        if (members != null) {
            int shootMemberCount = 0;
            if (TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Private") || TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Work")) {
                shootMemberCount = info.isOwner() ? (members.size() > 10 ? 10 : members.size()) : (members.size() > 11 ? 11 : members.size());
            } else if (TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Public")) {
                shootMemberCount = info.isOwner() ? (members.size() > 11 ? 11 : members.size()) : (members.size() > 12 ? 12 : members.size());
            } else if (TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"ChatRoom") || TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Meeting")) {
                shootMemberCount = info.isOwner() ? (members.size() > 11 ? 11 : members.size()) : (members.size() > 12 ? 12 : members.size());
            }
            for (int i = 0; i < shootMemberCount; ++i) {
                this.mGroupMembers.add(members.get(i));
            }
            if (TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Private") || TextUtils.equals((CharSequence)info.getGroupType(), (CharSequence)"Work")) {
                GroupMemberInfo add = new GroupMemberInfo();
                add.setMemberType(-100);
                this.mGroupMembers.add(add);
            }
            GroupMemberInfo self = null;
            for (int i = 0; i < this.mGroupMembers.size(); ++i) {
                GroupMemberInfo memberInfo = this.mGroupMembers.get(i);
                if (!TextUtils.equals((CharSequence)memberInfo.getAccount(), (CharSequence)V2TIMManager.getInstance().getLoginUser())) continue;
                self = memberInfo;
                break;
            }
            if (info.isOwner() || self != null && self.getMemberType() == 300) {
                GroupMemberInfo del = new GroupMemberInfo();
                del.setMemberType(-101);
                this.mGroupMembers.add(del);
            }
            BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    GroupInfoAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    private class MyViewHolder {
        private ImageView memberIcon;
        private TextView memberName;

        private MyViewHolder() {
        }
    }
}

