/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.info;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMGroupInfo;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.LineControllerView;
import com.tencent.qcloud.tim.uikit.component.SelectionActivity;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.dialog.TUIKitDialog;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoAdapter;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoPresenter;
import com.tencent.qcloud.tim.uikit.modules.group.interfaces.IGroupMemberLayout;
import com.tencent.qcloud.tim.uikit.modules.group.member.IGroupMemberRouter;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class GroupInfoLayout
extends LinearLayout
implements IGroupMemberLayout,
View.OnClickListener {
    private static final String TAG = GroupInfoLayout.class.getSimpleName();
    private TitleBarLayout mTitleBar;
    private LineControllerView mMemberView;
    private GroupInfoAdapter mMemberAdapter;
    private IGroupMemberRouter mMemberPreviewListener;
    private LineControllerView mGroupTypeView;
    private LineControllerView mGroupIDView;
    private LineControllerView mGroupNameView;
    private LineControllerView mGroupIcon;
    private LineControllerView mGroupNotice;
    private LineControllerView mNickView;
    private LineControllerView mJoinTypeView;
    private LineControllerView mTopSwitchView;
    private Button mDissolveBtn;
    private GroupInfo mGroupInfo;
    private GroupInfoPresenter mPresenter;
    private ArrayList<String> mJoinTypes = new ArrayList();

    public GroupInfoLayout(Context context) {
        super(context);
        this.init();
    }

    public GroupInfoLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupInfoLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GroupInfoLayout.inflate((Context)this.getContext(), (int)R.layout.group_info_layout, (ViewGroup)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_info_title_bar);
        this.mTitleBar.getRightGroup().setVisibility(8);
        this.mTitleBar.setTitle(this.getResources().getString(R.string.group_detail), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBar.setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((Activity)GroupInfoLayout.this.getContext()).finish();
            }
        });
        this.mMemberView = (LineControllerView)this.findViewById(R.id.group_member_bar);
        this.mMemberView.setOnClickListener(this);
        this.mMemberView.setCanNav(true);
        GridView memberList = (GridView)this.findViewById(R.id.group_members);
        this.mMemberAdapter = new GroupInfoAdapter();
        memberList.setAdapter((ListAdapter)this.mMemberAdapter);
        this.mGroupTypeView = (LineControllerView)this.findViewById(R.id.group_type_bar);
        this.mGroupIDView = (LineControllerView)this.findViewById(R.id.group_account);
        this.mGroupNameView = (LineControllerView)this.findViewById(R.id.group_name);
        this.mGroupNameView.setOnClickListener(this);
        this.mGroupNameView.setCanNav(true);
        this.mGroupIcon = (LineControllerView)this.findViewById(R.id.group_icon);
        this.mGroupIcon.setOnClickListener(this);
        this.mGroupIcon.setCanNav(false);
        this.mGroupNotice = (LineControllerView)this.findViewById(R.id.group_notice);
        this.mGroupNotice.setOnClickListener(this);
        this.mGroupNotice.setCanNav(true);
        this.mJoinTypeView = (LineControllerView)this.findViewById(R.id.join_type_bar);
        this.mJoinTypeView.setOnClickListener(this);
        this.mJoinTypeView.setCanNav(true);
        this.mJoinTypes.addAll(Arrays.asList(this.getResources().getStringArray(R.array.group_join_type)));
        this.mNickView = (LineControllerView)this.findViewById(R.id.self_nickname_bar);
        this.mNickView.setOnClickListener(this);
        this.mNickView.setCanNav(true);
        this.mTopSwitchView = (LineControllerView)this.findViewById(R.id.chat_to_top_switch);
        this.mTopSwitchView.setCheckListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                GroupInfoLayout.this.mPresenter.setTopConversation(isChecked);
            }
        });
        this.mDissolveBtn = (Button)this.findViewById(R.id.group_dissolve_button);
        this.mDissolveBtn.setOnClickListener((View.OnClickListener)this);
        this.mPresenter = new GroupInfoPresenter(this);
    }

    public void onClick(View v) {
        if (this.mGroupInfo == null) {
            TUIKitLog.e(TAG, "mGroupInfo is NULL");
            return;
        }
        if (v.getId() == R.id.group_member_bar) {
            if (this.mMemberPreviewListener != null) {
                this.mMemberPreviewListener.forwardListMember(this.mGroupInfo);
            }
        } else if (v.getId() == R.id.group_name) {
            Bundle bundle = new Bundle();
            bundle.putString("title", this.getResources().getString(R.string.modify_group_name));
            bundle.putString("init_content", this.mGroupNameView.getContent());
            bundle.putInt("limit", 20);
            SelectionActivity.startTextSelection((Context)((Activity)this.getContext()), bundle, new SelectionActivity.OnResultReturnListener(){

                @Override
                public void onReturn(Object text) {
                    GroupInfoLayout.this.mPresenter.modifyGroupName(text.toString());
                    GroupInfoLayout.this.mGroupNameView.setContent(text.toString());
                }
            });
        } else if (v.getId() == R.id.group_icon) {
            String groupUrl = String.format("https://picsum.photos/id/%d/200/200", new Random().nextInt(1000));
            V2TIMGroupInfo v2TIMGroupInfo = new V2TIMGroupInfo();
            v2TIMGroupInfo.setGroupID(this.mGroupInfo.getId());
            v2TIMGroupInfo.setFaceUrl(groupUrl);
            V2TIMManager.getGroupManager().setGroupInfo(v2TIMGroupInfo, new V2TIMCallback(){

                public void onError(int code, String desc) {
                    TUIKitLog.e(TAG, "modify group icon failed, code:" + code + "|desc:" + desc);
                    ToastUtil.toastLongMessage(GroupInfoLayout.this.getContext().getString(R.string.modify_icon_fail) + ", code = " + code + ", info = " + desc);
                }

                public void onSuccess() {
                    ToastUtil.toastLongMessage(GroupInfoLayout.this.getContext().getString(R.string.modify_icon_suc));
                }
            });
        } else if (v.getId() == R.id.group_notice) {
            Bundle bundle = new Bundle();
            bundle.putString("title", this.getResources().getString(R.string.modify_group_notice));
            bundle.putString("init_content", this.mGroupNotice.getContent());
            bundle.putInt("limit", 200);
            SelectionActivity.startTextSelection((Context)((Activity)this.getContext()), bundle, new SelectionActivity.OnResultReturnListener(){

                @Override
                public void onReturn(Object text) {
                    GroupInfoLayout.this.mPresenter.modifyGroupNotice(text.toString());
                    GroupInfoLayout.this.mGroupNotice.setContent(text.toString());
                }
            });
        } else if (v.getId() == R.id.self_nickname_bar) {
            Bundle bundle = new Bundle();
            bundle.putString("title", this.getResources().getString(R.string.modify_nick_name_in_goup));
            bundle.putString("init_content", this.mNickView.getContent());
            bundle.putInt("limit", 20);
            SelectionActivity.startTextSelection((Context)((Activity)this.getContext()), bundle, new SelectionActivity.OnResultReturnListener(){

                @Override
                public void onReturn(Object text) {
                    GroupInfoLayout.this.mPresenter.modifyMyGroupNickname(text.toString());
                    GroupInfoLayout.this.mNickView.setContent(text.toString());
                }
            });
        } else if (v.getId() == R.id.join_type_bar) {
            if (this.mGroupTypeView.getContent().equals(this.getContext().getString(R.string.chat_roon))) {
                ToastUtil.toastLongMessage(this.getContext().getString(R.string.chat_roon_tip));
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("title", this.getResources().getString(R.string.group_join_type));
            bundle.putStringArrayList("list", this.mJoinTypes);
            bundle.putInt("default_select_item_index", this.mGroupInfo.getJoinType());
            SelectionActivity.startListSelection((Context)((Activity)this.getContext()), bundle, new SelectionActivity.OnResultReturnListener(){

                @Override
                public void onReturn(Object text) {
                    GroupInfoLayout.this.mPresenter.modifyGroupInfo((Integer)text, 3);
                    GroupInfoLayout.this.mJoinTypeView.setContent((String)GroupInfoLayout.this.mJoinTypes.get((Integer)text));
                }
            });
        } else if (v.getId() == R.id.group_dissolve_button) {
            if (!(!this.mGroupInfo.isOwner() || this.mGroupInfo.getGroupType().equals("Work") && this.mGroupInfo.getGroupType().equals("Private"))) {
                new TUIKitDialog(this.getContext()).builder().setCancelable(true).setCancelOutside(true).setTitle(this.getContext().getString(R.string.dismiss_group_tip)).setDialogWidth(0.75f).setPositiveButton(this.getContext().getString(R.string.sure), new View.OnClickListener(){

                    public void onClick(View v) {
                        GroupInfoLayout.this.mPresenter.deleteGroup();
                    }
                }).setNegativeButton(this.getContext().getString(R.string.cancel), new View.OnClickListener(){

                    public void onClick(View v) {
                    }
                }).show();
            } else {
                new TUIKitDialog(this.getContext()).builder().setCancelable(true).setCancelOutside(true).setTitle(this.getContext().getString(R.string.quit_group_tip)).setDialogWidth(0.75f).setPositiveButton(this.getContext().getString(R.string.sure), new View.OnClickListener(){

                    public void onClick(View v) {
                        GroupInfoLayout.this.mPresenter.quitGroup();
                    }
                }).setNegativeButton(this.getContext().getString(R.string.cancel), new View.OnClickListener(){

                    public void onClick(View v) {
                    }
                }).show();
            }
        }
    }

    public void setGroupId(String groupId) {
        this.mPresenter.loadGroupInfo(groupId, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoLayout.this.setGroupInfo((GroupInfo)data);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
            }
        });
    }

    private void setGroupInfo(GroupInfo info) {
        if (info == null) {
            return;
        }
        this.mGroupInfo = info;
        this.mGroupNameView.setContent(info.getGroupName());
        this.mGroupIDView.setContent(info.getId());
        this.mGroupNotice.setContent(info.getNotice());
        this.mMemberView.setContent(info.getMemberCount() + "\u4eba");
        this.mMemberAdapter.setDataSource(info);
        this.mGroupTypeView.setContent(this.convertGroupText(info.getGroupType()));
        this.mJoinTypeView.setContent(this.mJoinTypes.get(info.getJoinType()));
        this.mNickView.setContent(this.mPresenter.getNickName());
        this.mTopSwitchView.setChecked(this.mGroupInfo.isTopChat());
        this.mDissolveBtn.setText(R.string.dissolve);
        if (this.mGroupInfo.isOwner()) {
            this.mGroupNotice.setVisibility(0);
            this.mJoinTypeView.setVisibility(0);
            if (this.mGroupInfo.getGroupType().equals("Work") || this.mGroupInfo.getGroupType().equals("Private")) {
                this.mDissolveBtn.setText(R.string.exit_group);
            }
        } else {
            this.mGroupNotice.setVisibility(8);
            this.mJoinTypeView.setVisibility(8);
            this.mDissolveBtn.setText(R.string.exit_group);
        }
    }

    private String convertGroupText(String groupType) {
        String groupText = "";
        if (TextUtils.isEmpty((CharSequence)groupType)) {
            return groupText;
        }
        if (TextUtils.equals((CharSequence)groupType, (CharSequence)"Private") || TextUtils.equals((CharSequence)groupType, (CharSequence)"Work")) {
            groupText = this.getContext().getString(R.string.private_group);
        } else if (TextUtils.equals((CharSequence)groupType, (CharSequence)"Public")) {
            groupText = this.getContext().getString(R.string.public_group);
        } else if (TextUtils.equals((CharSequence)groupType, (CharSequence)"ChatRoom") || TextUtils.equals((CharSequence)groupType, (CharSequence)"Meeting")) {
            groupText = this.getContext().getString(R.string.chat_roon);
        }
        return groupText;
    }

    public void onGroupInfoModified(Object value, int type) {
        switch (type) {
            case 1: {
                ToastUtil.toastLongMessage(this.getResources().getString(R.string.modify_group_name_success));
                this.mGroupNameView.setContent(value.toString());
                break;
            }
            case 2: {
                this.mGroupNotice.setContent(value.toString());
                ToastUtil.toastLongMessage(this.getResources().getString(R.string.modify_group_notice_success));
                break;
            }
            case 3: {
                this.mJoinTypeView.setContent(this.mJoinTypes.get((Integer)value));
                break;
            }
            case 17: {
                ToastUtil.toastLongMessage(this.getResources().getString(R.string.modify_nickname_success));
                this.mNickView.setContent(value.toString());
            }
        }
    }

    public void setRouter(IGroupMemberRouter listener) {
        this.mMemberPreviewListener = listener;
        this.mMemberAdapter.setManagerCallBack(listener);
    }

    @Override
    public void setDataSource(GroupInfo dataSource) {
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
    }
}

