/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.info;

import android.app.Activity;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoLayout;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public class GroupInfoPresenter {
    private GroupInfoLayout mInfoLayout;
    private GroupInfoProvider mProvider;

    public GroupInfoPresenter(GroupInfoLayout layout2) {
        this.mInfoLayout = layout2;
        this.mProvider = new GroupInfoProvider();
    }

    public void loadGroupInfo(String groupId, final IUIKitCallBack callBack) {
        this.mProvider.loadGroupInfo(groupId, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                callBack.onSuccess(data);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e("loadGroupInfo", errCode + ":" + errMsg);
                callBack.onError(module, errCode, errMsg);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void modifyGroupName(final String name) {
        this.mProvider.modifyGroupInfo(name, 1, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoPresenter.this.mInfoLayout.onGroupInfoModified(name, 1);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e("modifyGroupName", errCode + ":" + errMsg);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void modifyGroupNotice(final String notice) {
        this.mProvider.modifyGroupInfo(notice, 2, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoPresenter.this.mInfoLayout.onGroupInfoModified(notice, 2);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e("modifyGroupNotice", errCode + ":" + errMsg);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public String getNickName() {
        String nickName = "";
        if (this.mProvider.getSelfGroupInfo() != null) {
            nickName = this.mProvider.getSelfGroupInfo().getNameCard();
        }
        return nickName == null ? "" : nickName;
    }

    public void modifyMyGroupNickname(final String nickname) {
        this.mProvider.modifyMyGroupNickname(nickname, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoPresenter.this.mInfoLayout.onGroupInfoModified(nickname, 17);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e("modifyMyGroupNickname", errCode + ":" + errMsg);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void deleteGroup() {
        this.mProvider.deleteGroup(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                ((Activity)GroupInfoPresenter.this.mInfoLayout.getContext()).finish();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e("deleteGroup", errCode + ":" + errMsg);
                ToastUtil.toastLongMessage(errMsg);
            }
        });
    }

    public void setTopConversation(boolean flag) {
        this.mProvider.setTopConversation(flag);
    }

    public void quitGroup() {
        this.mProvider.quitGroup(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                ((Activity)GroupInfoPresenter.this.mInfoLayout.getContext()).finish();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ((Activity)GroupInfoPresenter.this.mInfoLayout.getContext()).finish();
                TUIKitLog.e("quitGroup", errCode + ":" + errMsg);
            }
        });
    }

    public void modifyGroupInfo(int value, int type) {
        this.mProvider.modifyGroupInfo(value, type, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoPresenter.this.mInfoLayout.onGroupInfoModified(data, 3);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage("modifyGroupInfo fail :" + errCode + "=" + errMsg);
            }
        });
    }
}

