/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.info;

import android.text.TextUtils;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMGroupApplication;
import com.tencent.imsdk.v2.V2TIMGroupApplicationResult;
import com.tencent.imsdk.v2.V2TIMGroupInfo;
import com.tencent.imsdk.v2.V2TIMGroupInfoResult;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfoResult;
import com.tencent.imsdk.v2.V2TIMGroupMemberOperationResult;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupInfoProvider {
    private static final String TAG = GroupInfoProvider.class.getSimpleName();
    private static final int PAGE = 50;
    private GroupInfo mGroupInfo;
    private GroupMemberInfo mSelfInfo;
    private List<GroupMemberInfo> mGroupMembers = new ArrayList<GroupMemberInfo>();
    private List<GroupApplyInfo> mApplyList = new ArrayList<GroupApplyInfo>();

    private void reset() {
        this.mGroupInfo = new GroupInfo();
        this.mGroupMembers = new ArrayList<GroupMemberInfo>();
        this.mSelfInfo = null;
    }

    public void loadGroupInfo(GroupInfo info) {
        this.mGroupInfo = info;
        this.mGroupMembers = info.getMemberDetails();
    }

    public void loadGroupInfo(final String groupId, final IUIKitCallBack callBack) {
        this.reset();
        this.loadGroupPublicInfo(groupId, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                GroupInfoProvider.this.mGroupInfo.covertTIMGroupDetailInfo((V2TIMGroupInfoResult)data);
                boolean isTop = ConversationManagerKit.getInstance().isTopConversation(groupId);
                GroupInfoProvider.this.mGroupInfo.setTopChat(isTop);
                GroupInfoProvider.this.loadGroupMembers(0L, callBack);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e(TAG, "loadGroupPublicInfo failed, code: " + errCode + "|desc: " + errMsg);
                if (callBack != null) {
                    callBack.onError(module, errCode, errMsg);
                }
            }
        });
    }

    public void deleteGroup(final IUIKitCallBack callBack) {
        V2TIMManager.getInstance().dismissGroup(this.mGroupInfo.getId(), new V2TIMCallback(){

            public void onError(int code, String desc) {
                callBack.onError(TAG, code, desc);
                TUIKitLog.e(TAG, "deleteGroup failed, code: " + code + "|desc: " + desc);
            }

            public void onSuccess() {
                callBack.onSuccess(null);
                ConversationManagerKit.getInstance().deleteConversation(GroupInfoProvider.this.mGroupInfo.getId(), true);
                GroupChatManagerKit.getInstance().onGroupForceExit();
            }
        });
    }

    public void loadGroupPublicInfo(String groupId, final IUIKitCallBack callBack) {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(groupId);
        V2TIMManager.getGroupManager().getGroupsInfo(groupList, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMGroupInfoResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "loadGroupPublicInfo failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess(List<V2TIMGroupInfoResult> v2TIMGroupInfoResults) {
                if (v2TIMGroupInfoResults.size() > 0) {
                    V2TIMGroupInfoResult infoResult = v2TIMGroupInfoResults.get(0);
                    TUIKitLog.i(TAG, infoResult.toString());
                    callBack.onSuccess(infoResult);
                }
            }
        });
    }

    public void loadGroupMembers(long nextSeq, final IUIKitCallBack callBack) {
        V2TIMManager.getGroupManager().getGroupMemberList(this.mGroupInfo.getId(), 0, nextSeq, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMGroupMemberInfoResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "loadGroupMembers failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess(V2TIMGroupMemberInfoResult v2TIMGroupMemberInfoResult) {
                ArrayList<GroupMemberInfo> members = new ArrayList<GroupMemberInfo>();
                for (int i = 0; i < v2TIMGroupMemberInfoResult.getMemberInfoList().size(); ++i) {
                    GroupMemberInfo member = new GroupMemberInfo();
                    members.add(member.covertTIMGroupMemberInfo((V2TIMGroupMemberInfo)v2TIMGroupMemberInfoResult.getMemberInfoList().get(i)));
                }
                GroupInfoProvider.this.mGroupMembers.addAll(members);
                GroupInfoProvider.this.mGroupInfo.setMemberDetails(GroupInfoProvider.this.mGroupMembers);
                if (v2TIMGroupMemberInfoResult.getNextSeq() != 0L) {
                    GroupInfoProvider.this.loadGroupMembers(v2TIMGroupMemberInfoResult.getNextSeq(), callBack);
                } else {
                    callBack.onSuccess(GroupInfoProvider.this.mGroupInfo);
                }
            }
        });
    }

    public List<GroupMemberInfo> getGroupMembers() {
        return this.mGroupMembers;
    }

    public void modifyGroupInfo(final Object value, final int type, final IUIKitCallBack callBack) {
        V2TIMGroupInfo v2TIMGroupInfo = new V2TIMGroupInfo();
        v2TIMGroupInfo.setGroupID(this.mGroupInfo.getId());
        if (type == 1) {
            v2TIMGroupInfo.setGroupName(value.toString());
        } else if (type == 2) {
            v2TIMGroupInfo.setNotification(value.toString());
        } else if (type == 3) {
            v2TIMGroupInfo.setGroupAddOpt(((Integer)value).intValue());
        }
        V2TIMManager.getGroupManager().setGroupInfo(v2TIMGroupInfo, new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.i(TAG, "modifyGroupInfo faild tyep| value| code| desc " + value + ":" + type + ":" + code + ":" + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess() {
                if (type == 1) {
                    GroupInfoProvider.this.mGroupInfo.setGroupName(value.toString());
                } else if (type == 2) {
                    GroupInfoProvider.this.mGroupInfo.setNotice(value.toString());
                } else if (type == 3) {
                    GroupInfoProvider.this.mGroupInfo.setJoinType((Integer)value);
                }
                callBack.onSuccess(value);
            }
        });
    }

    public void modifyMyGroupNickname(String nickname, final IUIKitCallBack callBack) {
        if (this.mGroupInfo == null) {
            ToastUtil.toastLongMessage("modifyMyGroupNickname fail: NO GROUP");
        }
        V2TIMGroupMemberFullInfo v2TIMGroupMemberFullInfo = new V2TIMGroupMemberFullInfo();
        v2TIMGroupMemberFullInfo.setUserID(V2TIMManager.getInstance().getLoginUser());
        v2TIMGroupMemberFullInfo.setNameCard(nickname);
        V2TIMManager.getGroupManager().setGroupMemberInfo(this.mGroupInfo.getId(), v2TIMGroupMemberFullInfo, new V2TIMCallback(){

            public void onError(int code, String desc) {
                callBack.onError(TAG, code, desc);
                ToastUtil.toastLongMessage("modifyMyGroupNickname fail: " + code + "=" + desc);
            }

            public void onSuccess() {
                callBack.onSuccess(null);
            }
        });
    }

    public GroupMemberInfo getSelfGroupInfo() {
        if (this.mSelfInfo != null) {
            return this.mSelfInfo;
        }
        for (int i = 0; i < this.mGroupMembers.size(); ++i) {
            GroupMemberInfo memberInfo = this.mGroupMembers.get(i);
            if (!TextUtils.equals((CharSequence)memberInfo.getAccount(), (CharSequence)V2TIMManager.getInstance().getLoginUser())) continue;
            this.mSelfInfo = memberInfo;
            return memberInfo;
        }
        return null;
    }

    public void setTopConversation(boolean flag) {
        ConversationManagerKit.getInstance().setConversationTop(this.mGroupInfo.getId(), flag);
    }

    public void quitGroup(final IUIKitCallBack callBack) {
        V2TIMManager.getInstance().quitGroup(this.mGroupInfo.getId(), new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "quitGroup failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess() {
                ConversationManagerKit.getInstance().deleteConversation(GroupInfoProvider.this.mGroupInfo.getId(), true);
                GroupChatManagerKit.getInstance().onGroupForceExit();
                callBack.onSuccess(null);
                GroupInfoProvider.this.reset();
            }
        });
    }

    public void inviteGroupMembers(List<String> addMembers, final IUIKitCallBack callBack) {
        if (addMembers == null || addMembers.size() == 0) {
            return;
        }
        V2TIMManager.getGroupManager().inviteUserToGroup(this.mGroupInfo.getId(), addMembers, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMGroupMemberOperationResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "addGroupMembers failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess(List<V2TIMGroupMemberOperationResult> v2TIMGroupMemberOperationResults) {
                ArrayList<String> adds = new ArrayList<String>();
                if (v2TIMGroupMemberOperationResults.size() > 0) {
                    for (int i = 0; i < v2TIMGroupMemberOperationResults.size(); ++i) {
                        V2TIMGroupMemberOperationResult res = v2TIMGroupMemberOperationResults.get(i);
                        if (res.getResult() == 3) {
                            callBack.onSuccess(TUIKit.getAppContext().getString(R.string.request_wait));
                            return;
                        }
                        if (res.getResult() <= 0) continue;
                        adds.add(res.getMemberID());
                    }
                }
                if (adds.size() > 0) {
                    GroupInfoProvider.this.loadGroupMembers(0L, callBack);
                }
            }
        });
    }

    public void removeGroupMembers(List<GroupMemberInfo> delMembers, final IUIKitCallBack callBack) {
        if (delMembers == null || delMembers.size() == 0) {
            return;
        }
        ArrayList<String> members = new ArrayList<String>();
        for (int i = 0; i < delMembers.size(); ++i) {
            members.add(delMembers.get(i).getAccount());
        }
        V2TIMManager.getGroupManager().kickGroupMember(this.mGroupInfo.getId(), members, "", (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMGroupMemberOperationResult>>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "removeGroupMembers failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess(List<V2TIMGroupMemberOperationResult> v2TIMGroupMemberOperationResults) {
                int i;
                ArrayList<String> dels = new ArrayList<String>();
                for (i = 0; i < v2TIMGroupMemberOperationResults.size(); ++i) {
                    V2TIMGroupMemberOperationResult res = v2TIMGroupMemberOperationResults.get(i);
                    if (res.getResult() != 1) continue;
                    dels.add(res.getMemberID());
                }
                block1: for (i = 0; i < dels.size(); ++i) {
                    for (int j = GroupInfoProvider.this.mGroupMembers.size() - 1; j >= 0; --j) {
                        if (!((GroupMemberInfo)GroupInfoProvider.this.mGroupMembers.get(j)).getAccount().equals(dels.get(i))) continue;
                        GroupInfoProvider.this.mGroupMembers.remove(j);
                        continue block1;
                    }
                }
                GroupInfoProvider.this.mGroupInfo.setMemberDetails(GroupInfoProvider.this.mGroupMembers);
                callBack.onSuccess(dels);
            }
        });
    }

    public List<GroupApplyInfo> getApplyList() {
        return this.mApplyList;
    }

    public void loadGroupApplies(final IUIKitCallBack callBack) {
        this.loadApplyInfo(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                if (GroupInfoProvider.this.mGroupInfo == null) {
                    callBack.onError(TAG, 0, "no groupInfo");
                    return;
                }
                String groupId = GroupInfoProvider.this.mGroupInfo.getId();
                List allApplies = (List)data;
                ArrayList<GroupApplyInfo> applyInfos = new ArrayList<GroupApplyInfo>();
                for (int i = 0; i < allApplies.size(); ++i) {
                    GroupApplyInfo applyInfo = (GroupApplyInfo)allApplies.get(i);
                    if (!groupId.equals(applyInfo.getGroupApplication().getGroupID()) || applyInfo.getGroupApplication().getHandleStatus() != 0) continue;
                    applyInfos.add(applyInfo);
                }
                GroupInfoProvider.this.mApplyList = applyInfos;
                callBack.onSuccess(applyInfos);
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                TUIKitLog.e(TAG, "loadApplyInfo failed, code: " + errCode + "|desc: " + errMsg);
                callBack.onError(module, errCode, errMsg);
            }
        });
    }

    private void loadApplyInfo(final IUIKitCallBack callBack) {
        final ArrayList applies = new ArrayList();
        V2TIMManager.getGroupManager().getGroupApplicationList((V2TIMValueCallback)new V2TIMValueCallback<V2TIMGroupApplicationResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "getGroupPendencyList failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess(V2TIMGroupApplicationResult v2TIMGroupApplicationResult) {
                List v2TIMGroupApplicationList = v2TIMGroupApplicationResult.getGroupApplicationList();
                for (int i = 0; i < v2TIMGroupApplicationList.size(); ++i) {
                    GroupApplyInfo info = new GroupApplyInfo((V2TIMGroupApplication)v2TIMGroupApplicationList.get(i));
                    info.setStatus(0);
                    applies.add(info);
                }
                callBack.onSuccess(applies);
            }
        });
    }

    public void acceptApply(final GroupApplyInfo item, final IUIKitCallBack callBack) {
        V2TIMManager.getGroupManager().acceptGroupApplication(item.getGroupApplication(), "", new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "acceptApply failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess() {
                item.setStatus(1);
                callBack.onSuccess(null);
            }
        });
    }

    public void refuseApply(final GroupApplyInfo item, final IUIKitCallBack callBack) {
        V2TIMManager.getGroupManager().refuseGroupApplication(item.getGroupApplication(), "", new V2TIMCallback(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "refuseApply failed, code: " + code + "|desc: " + desc);
                callBack.onError(TAG, code, desc);
            }

            public void onSuccess() {
                item.setStatus(-1);
                callBack.onSuccess(null);
            }
        });
    }
}

