/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.info;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactItemBean;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactListView;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import java.util.ArrayList;

public class StartGroupMemberSelectActivity
extends Activity {
    private static final String TAG = StartGroupMemberSelectActivity.class.getSimpleName();
    private TitleBarLayout mTitleBar;
    private ContactListView mContactListView;
    private ArrayList<GroupMemberInfo> mMembers = new ArrayList();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.popup_start_group_select_activity);
        this.init();
    }

    private String getMembersNameCard() {
        if (this.mMembers.size() == 0) {
            return "";
        }
        String nameCardString = "";
        for (int i = 0; i < this.mMembers.size(); ++i) {
            nameCardString = nameCardString + this.mMembers.get(i).getNameCard();
            nameCardString = nameCardString + " ";
        }
        return nameCardString;
    }

    private String getMembersUserId() {
        if (this.mMembers.size() == 0) {
            return "";
        }
        String userIdString = "";
        for (int i = 0; i < this.mMembers.size(); ++i) {
            userIdString = userIdString + this.mMembers.get(i).getAccount();
            userIdString = userIdString + " ";
        }
        return userIdString;
    }

    private void init() {
        this.mMembers.clear();
        GroupInfo groupInfo = (GroupInfo)this.getIntent().getExtras().getSerializable("groupInfo");
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_create_title_bar);
        this.mTitleBar.setTitle(this.getResources().getString(R.string.sure), ITitleBarLayout.POSITION.RIGHT);
        this.mTitleBar.getRightTitle().setTextColor(this.getResources().getColor(R.color.title_bar_font_color));
        this.mTitleBar.getRightIcon().setVisibility(8);
        this.mTitleBar.setOnRightClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent i = new Intent();
                i.putExtra("user_namecard_select", StartGroupMemberSelectActivity.this.getMembersNameCard());
                i.putExtra("user_id_select", StartGroupMemberSelectActivity.this.getMembersUserId());
                StartGroupMemberSelectActivity.this.setResult(3, i);
                StartGroupMemberSelectActivity.this.finish();
            }
        });
        this.mTitleBar.setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StartGroupMemberSelectActivity.this.finish();
            }
        });
        this.mContactListView = (ContactListView)this.findViewById(R.id.group_create_member_list);
        this.mContactListView.setGroupInfo(groupInfo);
        this.mContactListView.loadDataSource(5);
        this.mContactListView.setOnItemClickListener(new ContactListView.OnItemClickListener(){

            @Override
            public void onItemClick(int position, ContactItemBean contact) {
                if (position == 0) {
                    StartGroupMemberSelectActivity.this.mMembers.clear();
                    Intent i = new Intent();
                    i.putExtra("user_namecard_select", StartGroupMemberSelectActivity.this.getString(R.string.at_all));
                    i.putExtra("user_id_select", "__kImSDK_MesssageAtALL__");
                    StartGroupMemberSelectActivity.this.setResult(3, i);
                    StartGroupMemberSelectActivity.this.finish();
                }
            }
        });
        this.mContactListView.setOnSelectChangeListener(new ContactListView.OnSelectChangedListener(){

            @Override
            public void onSelectChanged(ContactItemBean contact, boolean selected) {
                if (selected) {
                    GroupMemberInfo memberInfo = new GroupMemberInfo();
                    memberInfo.setAccount(contact.getId());
                    memberInfo.setNameCard(TextUtils.isEmpty((CharSequence)contact.getNickname()) ? contact.getId() : contact.getNickname());
                    StartGroupMemberSelectActivity.this.mMembers.add(memberInfo);
                } else {
                    for (int i = StartGroupMemberSelectActivity.this.mMembers.size() - 1; i >= 0; --i) {
                        if (!((GroupMemberInfo)StartGroupMemberSelectActivity.this.mMembers.get(i)).getAccount().equals(contact.getId())) continue;
                        StartGroupMemberSelectActivity.this.mMembers.remove(i);
                    }
                }
            }
        });
    }
}

