/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.member;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import java.util.ArrayList;
import java.util.List;

public class GroupMemberDeleteAdapter
extends BaseAdapter {
    private List<GroupMemberInfo> mGroupMembers = new ArrayList<GroupMemberInfo>();
    private List<GroupMemberInfo> mDelMembers = new ArrayList<GroupMemberInfo>();
    private OnSelectChangedListener mSelectCallback;

    public int getCount() {
        return this.mGroupMembers.size();
    }

    public GroupMemberInfo getItem(int i) {
        return this.mGroupMembers.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        MyViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.group_member_del_adpater, viewGroup, false);
            holder = new MyViewHolder();
            holder.memberIcon = (ImageView)view.findViewById(R.id.group_member_icon);
            holder.memberName = (TextView)view.findViewById(R.id.group_member_name);
            holder.delCheck = (CheckBox)view.findViewById(R.id.group_member_del_check);
            view.setTag((Object)holder);
        } else {
            holder = (MyViewHolder)view.getTag();
        }
        final GroupMemberInfo info = this.getItem(i);
        if (!TextUtils.isEmpty((CharSequence)info.getIconUrl())) {
            GlideEngine.loadImage(holder.memberIcon, info.getIconUrl(), null);
        }
        holder.memberName.setText((CharSequence)info.getAccount());
        holder.delCheck.setChecked(false);
        holder.delCheck.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    GroupMemberDeleteAdapter.this.mDelMembers.add(info);
                } else {
                    GroupMemberDeleteAdapter.this.mDelMembers.remove(info);
                }
                if (GroupMemberDeleteAdapter.this.mSelectCallback != null) {
                    GroupMemberDeleteAdapter.this.mSelectCallback.onSelectChanged(GroupMemberDeleteAdapter.this.mDelMembers);
                }
            }
        });
        return view;
    }

    public void setDataSource(List<GroupMemberInfo> members) {
        if (members != null) {
            this.mGroupMembers = members;
            BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    GroupMemberDeleteAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    public void setOnSelectChangedListener(OnSelectChangedListener callback) {
        this.mSelectCallback = callback;
    }

    public void clear() {
        this.mDelMembers.clear();
    }

    private class MyViewHolder {
        private ImageView memberIcon;
        private TextView memberName;
        private CheckBox delCheck;

        private MyViewHolder() {
        }
    }

    public static interface OnSelectChangedListener {
        public void onSelectChanged(List<GroupMemberInfo> var1);
    }
}

