/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.member;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.modules.group.interfaces.IGroupMemberLayout;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberDeleteAdapter;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.List;

public class GroupMemberDeleteLayout
extends LinearLayout
implements IGroupMemberLayout {
    private TitleBarLayout mTitleBar;
    private ListView mMembers;
    private GroupMemberDeleteAdapter mAdapter;
    private List<GroupMemberInfo> mDelMembers;
    private GroupInfo mGroupInfo;

    public GroupMemberDeleteLayout(Context context) {
        super(context);
        this.init();
    }

    public GroupMemberDeleteLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupMemberDeleteLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GroupMemberDeleteLayout.inflate((Context)this.getContext(), (int)R.layout.group_member_del_layout, (ViewGroup)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_member_title_bar);
        this.mTitleBar.setTitle(this.getContext().getString(R.string.remove), ITitleBarLayout.POSITION.RIGHT);
        this.mTitleBar.setTitle(this.getContext().getString(R.string.remove_member), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBar.getRightTitle().setTextColor(-16776961);
        this.mTitleBar.getRightIcon().setVisibility(8);
        this.mTitleBar.setOnRightClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GroupInfoProvider provider = new GroupInfoProvider();
                provider.loadGroupInfo(GroupMemberDeleteLayout.this.mGroupInfo);
                provider.removeGroupMembers(GroupMemberDeleteLayout.this.mDelMembers, new IUIKitCallBack(){

                    @Override
                    public void onSuccess(Object data) {
                        ToastUtil.toastLongMessage(GroupMemberDeleteLayout.this.getContext().getString(R.string.remove_tip_suc));
                        GroupMemberDeleteLayout.this.post(new Runnable(){

                            @Override
                            public void run() {
                                GroupMemberDeleteLayout.this.mTitleBar.setTitle(GroupMemberDeleteLayout.this.getContext().getString(R.string.remove), ITitleBarLayout.POSITION.RIGHT);
                                GroupMemberDeleteLayout.this.mAdapter.clear();
                                GroupMemberDeleteLayout.this.mAdapter.notifyDataSetChanged();
                            }
                        });
                    }

                    @Override
                    public void onError(String module, int errCode, String errMsg) {
                        ToastUtil.toastLongMessage(GroupMemberDeleteLayout.this.getContext().getString(R.string.remove_tip_fail) + errCode + "=" + errMsg);
                    }
                });
            }
        });
        this.mAdapter = new GroupMemberDeleteAdapter();
        this.mAdapter.setOnSelectChangedListener(new GroupMemberDeleteAdapter.OnSelectChangedListener(){

            @Override
            public void onSelectChanged(List<GroupMemberInfo> members) {
                GroupMemberDeleteLayout.this.mDelMembers = members;
                if (GroupMemberDeleteLayout.this.mDelMembers.size() > 0) {
                    GroupMemberDeleteLayout.this.mTitleBar.setTitle(GroupMemberDeleteLayout.this.getContext().getString(R.string.remove) + "\uff08" + GroupMemberDeleteLayout.this.mDelMembers.size() + "\uff09", ITitleBarLayout.POSITION.RIGHT);
                } else {
                    GroupMemberDeleteLayout.this.mTitleBar.setTitle(GroupMemberDeleteLayout.this.getContext().getString(R.string.remove), ITitleBarLayout.POSITION.RIGHT);
                }
            }
        });
        this.mMembers = (ListView)this.findViewById(R.id.group_del_members);
        this.mMembers.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
    }

    @Override
    public void setDataSource(GroupInfo groupInfo) {
        this.mGroupInfo = groupInfo;
        this.mAdapter.setDataSource(groupInfo.getMemberDetails());
    }
}

