/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.member;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.BaseFragment;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactItemBean;
import com.tencent.qcloud.tim.uikit.modules.contact.ContactListView;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.modules.group.interfaces.IGroupMemberLayout;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupMemberInviteLayout
extends LinearLayout
implements IGroupMemberLayout {
    private static final String TAG = GroupMemberInviteLayout.class.getSimpleName();
    private TitleBarLayout mTitleBar;
    private ContactListView mContactListView;
    private List<String> mInviteMembers = new ArrayList<String>();
    private Object mParentLayout;
    private GroupInfo mGroupInfo;

    public GroupMemberInviteLayout(Context context) {
        super(context);
        this.init();
    }

    public GroupMemberInviteLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupMemberInviteLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GroupMemberInviteLayout.inflate((Context)this.getContext(), (int)R.layout.group_member_invite_layout, (ViewGroup)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_invite_title_bar);
        this.mTitleBar.setTitle(this.getContext().getString(R.string.sure), ITitleBarLayout.POSITION.RIGHT);
        this.mTitleBar.setTitle(this.getContext().getString(R.string.add_group_member), ITitleBarLayout.POSITION.MIDDLE);
        this.mTitleBar.getRightTitle().setTextColor(-16776961);
        this.mTitleBar.getRightIcon().setVisibility(8);
        this.mTitleBar.setOnRightClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GroupInfoProvider provider = new GroupInfoProvider();
                provider.loadGroupInfo(GroupMemberInviteLayout.this.mGroupInfo);
                provider.inviteGroupMembers(GroupMemberInviteLayout.this.mInviteMembers, new IUIKitCallBack(){

                    @Override
                    public void onSuccess(Object data) {
                        if (data instanceof String) {
                            ToastUtil.toastLongMessage(data.toString());
                        } else {
                            ToastUtil.toastLongMessage(GroupMemberInviteLayout.this.getContext().getString(R.string.invite_suc));
                        }
                        GroupMemberInviteLayout.this.mInviteMembers.clear();
                        GroupMemberInviteLayout.this.finish();
                    }

                    @Override
                    public void onError(String module, int errCode, String errMsg) {
                        ToastUtil.toastLongMessage(GroupMemberInviteLayout.this.getContext().getString(R.string.invite_fail) + errCode + "=" + errMsg);
                    }
                });
            }
        });
        this.mContactListView = (ContactListView)this.findViewById(R.id.group_invite_member_list);
        this.mContactListView.loadDataSource(1);
        this.mContactListView.setOnSelectChangeListener(new ContactListView.OnSelectChangedListener(){

            @Override
            public void onSelectChanged(ContactItemBean contact, boolean selected) {
                if (selected) {
                    GroupMemberInviteLayout.this.mInviteMembers.add(contact.getId());
                } else {
                    GroupMemberInviteLayout.this.mInviteMembers.remove(contact.getId());
                }
                if (GroupMemberInviteLayout.this.mInviteMembers.size() > 0) {
                    GroupMemberInviteLayout.this.mTitleBar.setTitle(GroupMemberInviteLayout.this.getContext().getString(R.string.sure) + "\uff08" + GroupMemberInviteLayout.this.mInviteMembers.size() + "\uff09", ITitleBarLayout.POSITION.RIGHT);
                } else {
                    GroupMemberInviteLayout.this.mTitleBar.setTitle(GroupMemberInviteLayout.this.getContext().getString(R.string.sure), ITitleBarLayout.POSITION.RIGHT);
                }
            }
        });
    }

    @Override
    public void setDataSource(GroupInfo groupInfo) {
        this.mGroupInfo = groupInfo;
        if (this.mContactListView != null) {
            this.mContactListView.setGroupInfo(this.mGroupInfo);
        }
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
        this.mParentLayout = parent;
    }

    private void finish() {
        if (this.mParentLayout instanceof Activity) {
            ((Activity)this.mParentLayout).finish();
        } else if (this.mParentLayout instanceof BaseFragment) {
            ((BaseFragment)((Object)this.mParentLayout)).backward();
        }
    }
}

