/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.member;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.IGroupMemberChangedCallback;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import com.tencent.qcloud.tim.uikit.utils.PopWindowUtil;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupMemberManagerAdapter
extends BaseAdapter {
    private IGroupMemberChangedCallback mCallback;
    private GroupInfo mGroupInfo;
    private List<GroupMemberInfo> mGroupMembers = new ArrayList<GroupMemberInfo>();

    public void setMemberChangedCallback(IGroupMemberChangedCallback callback) {
        this.mCallback = callback;
    }

    public int getCount() {
        return this.mGroupMembers.size();
    }

    public GroupMemberInfo getItem(int i) {
        return this.mGroupMembers.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(int i, View view, final ViewGroup viewGroup) {
        MyViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.group_member_adpater, viewGroup, false);
            holder = new MyViewHolder();
            holder.memberIcon = (ImageView)view.findViewById(R.id.group_member_icon);
            holder.memberName = (TextView)view.findViewById(R.id.group_member_name);
            view.setTag((Object)holder);
        } else {
            holder = (MyViewHolder)view.getTag();
        }
        final GroupMemberInfo info = this.getItem(i);
        if (!TextUtils.isEmpty((CharSequence)info.getIconUrl())) {
            GlideEngine.loadImage(holder.memberIcon, info.getIconUrl(), null);
        }
        holder.memberName.setText((CharSequence)info.getAccount());
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (!GroupMemberManagerAdapter.this.mGroupInfo.isOwner()) {
                    return false;
                }
                TextView delete = new TextView(viewGroup.getContext());
                delete.setText(R.string.group_remove_member);
                int padding = ScreenUtil.getPxByDp(10.0f);
                delete.setPadding(padding, padding, padding, padding);
                delete.setBackgroundResource(R.drawable.text_border);
                int[] location = new int[2];
                v.getLocationInWindow(location);
                final PopupWindow window = PopWindowUtil.popupWindow((View)delete, (View)viewGroup, location[0], location[1] + v.getMeasuredHeight() / 3);
                delete.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ArrayList<GroupMemberInfo> dels = new ArrayList<GroupMemberInfo>();
                        dels.add(info);
                        GroupInfoProvider provider = new GroupInfoProvider();
                        provider.loadGroupInfo(GroupMemberManagerAdapter.this.mGroupInfo);
                        provider.removeGroupMembers(dels, new IUIKitCallBack(){

                            @Override
                            public void onSuccess(Object data) {
                                GroupMemberManagerAdapter.this.mGroupMembers.remove(info);
                                GroupMemberManagerAdapter.this.notifyDataSetChanged();
                                if (GroupMemberManagerAdapter.this.mCallback != null) {
                                    GroupMemberManagerAdapter.this.mCallback.onMemberRemoved(info);
                                }
                            }

                            @Override
                            public void onError(String module, int errCode, String errMsg) {
                                ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.remove_fail_tip) + ":errCode=" + errCode);
                            }
                        });
                        window.dismiss();
                    }
                });
                return false;
            }
        });
        return view;
    }

    public void setDataSource(GroupInfo groupInfo) {
        if (groupInfo != null) {
            this.mGroupInfo = groupInfo;
            this.mGroupMembers = groupInfo.getMemberDetails();
            BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    GroupMemberManagerAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    private class MyViewHolder {
        private ImageView memberIcon;
        private TextView memberName;

        private MyViewHolder() {
        }
    }
}

