/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.group.member;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.interfaces.IGroupMemberLayout;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberManagerAdapter;
import com.tencent.qcloud.tim.uikit.modules.group.member.IGroupMemberChangedCallback;
import com.tencent.qcloud.tim.uikit.modules.group.member.IGroupMemberRouter;
import com.tencent.qcloud.tim.uikit.utils.PopWindowUtil;

public class GroupMemberManagerLayout
extends LinearLayout
implements IGroupMemberLayout {
    private TitleBarLayout mTitleBar;
    private AlertDialog mDialog;
    private GroupMemberManagerAdapter mAdapter;
    private IGroupMemberRouter mGroupMemberManager;
    private GroupInfo mGroupInfo;

    public GroupMemberManagerLayout(Context context) {
        super(context);
        this.init();
    }

    public GroupMemberManagerLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupMemberManagerLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GroupMemberManagerLayout.inflate((Context)this.getContext(), (int)R.layout.group_member_layout, (ViewGroup)this);
        this.mTitleBar = (TitleBarLayout)this.findViewById(R.id.group_member_title_bar);
        this.mTitleBar.setTitle(this.getContext().getString(R.string.manager), ITitleBarLayout.POSITION.RIGHT);
        this.mTitleBar.getRightIcon().setVisibility(8);
        this.mTitleBar.setOnRightClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GroupMemberManagerLayout.this.buildPopMenu();
            }
        });
        this.mAdapter = new GroupMemberManagerAdapter();
        this.mAdapter.setMemberChangedCallback(new IGroupMemberChangedCallback(){

            @Override
            public void onMemberRemoved(GroupMemberInfo memberInfo) {
                GroupMemberManagerLayout.this.mTitleBar.setTitle(GroupMemberManagerLayout.this.getContext().getString(R.string.group_members) + "(" + GroupMemberManagerLayout.this.mGroupInfo.getMemberDetails().size() + ")", ITitleBarLayout.POSITION.MIDDLE);
            }
        });
        GridView gridView = (GridView)this.findViewById(R.id.group_all_members);
        gridView.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public TitleBarLayout getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void setParentLayout(Object parent) {
    }

    @Override
    public void setDataSource(GroupInfo groupInfo) {
        this.mGroupInfo = groupInfo;
        this.mAdapter.setDataSource(groupInfo);
        if (groupInfo != null) {
            this.mTitleBar.setTitle(this.getContext().getString(R.string.group_members) + "(" + groupInfo.getMemberDetails().size() + ")", ITitleBarLayout.POSITION.MIDDLE);
        }
    }

    private void buildPopMenu() {
        if (this.mGroupInfo == null) {
            return;
        }
        if (this.mDialog == null) {
            this.mDialog = PopWindowUtil.buildFullScreenDialog((Activity)this.getContext());
            View moreActionView = GroupMemberManagerLayout.inflate((Context)this.getContext(), (int)R.layout.group_member_pop_menu, null);
            moreActionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GroupMemberManagerLayout.this.mDialog.dismiss();
                }
            });
            Button addBtn = (Button)moreActionView.findViewById(R.id.add_group_member);
            addBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (GroupMemberManagerLayout.this.mGroupMemberManager != null) {
                        GroupMemberManagerLayout.this.mGroupMemberManager.forwardAddMember(GroupMemberManagerLayout.this.mGroupInfo);
                    }
                    GroupMemberManagerLayout.this.mDialog.dismiss();
                }
            });
            Button deleteBtn = (Button)moreActionView.findViewById(R.id.remove_group_member);
            if (!this.mGroupInfo.isOwner()) {
                deleteBtn.setVisibility(8);
            }
            deleteBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (GroupMemberManagerLayout.this.mGroupMemberManager != null) {
                        GroupMemberManagerLayout.this.mGroupMemberManager.forwardDeleteMember(GroupMemberManagerLayout.this.mGroupInfo);
                    }
                    GroupMemberManagerLayout.this.mDialog.dismiss();
                }
            });
            Button cancelBtn = (Button)moreActionView.findViewById(R.id.cancel);
            cancelBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GroupMemberManagerLayout.this.mDialog.dismiss();
                }
            });
            this.mDialog.setContentView(moreActionView);
        } else {
            this.mDialog.show();
        }
    }

    public void setRouter(IGroupMemberRouter callBack) {
        this.mGroupMemberManager = callBack;
    }
}

