/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.message;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMCustomElem;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMFaceElem;
import com.tencent.imsdk.v2.V2TIMFileElem;
import com.tencent.imsdk.v2.V2TIMGroupChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupTipsElem;
import com.tencent.imsdk.v2.V2TIMImageElem;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMSoundElem;
import com.tencent.imsdk.v2.V2TIMTextElem;
import com.tencent.imsdk.v2.V2TIMVideoElem;
import com.tencent.liteav.model.CallModel;
import com.tencent.liteav.model.LiveModel;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.modules.message.LiveMessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageCustom;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageTyping;
import com.tencent.qcloud.tim.uikit.utils.DateTimeUtil;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.ImageUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageInfoUtil {
    private static final String TAG = MessageInfoUtil.class.getSimpleName();

    public static MessageInfo buildTextMessage(String message) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createTextMessage(message);
        info.setExtra(message);
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(0);
        return info;
    }

    public static MessageInfo buildTextAtMessage(List<String> atUserList, String message) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createTextAtMessage(message, atUserList);
        info.setExtra(message);
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(0);
        return info;
    }

    public static MessageInfo buildCustomFaceMessage(int groupId, String faceName) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createFaceMessage(groupId, faceName.getBytes());
        info.setExtra(TUIKit.getAppContext().getString(R.string.custom_emoji));
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(112);
        return info;
    }

    public static MessageInfo buildImageMessage(Uri uri, boolean compressed) {
        MessageInfo info = new MessageInfo();
        String path = FileUtil.getPathFromUri(uri);
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createImageMessage(path);
        info.setDataUri(uri);
        int[] size = ImageUtil.getImageSize(uri);
        info.setDataPath(path);
        info.setImgWidth(size[0]);
        info.setImgHeight(size[1]);
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setExtra(TUIKit.getAppContext().getString(R.string.picture_extra));
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(32);
        return info;
    }

    public static MessageInfo buildVideoMessage(String imgPath, String videoPath, int width, int height, long duration) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createVideoMessage(videoPath, "mp4", (int)duration / 1000, imgPath);
        Uri videoUri = Uri.fromFile((File)new File(videoPath));
        info.setSelf(true);
        info.setImgWidth(width);
        info.setImgHeight(height);
        info.setDataPath(imgPath);
        info.setDataUri(videoUri);
        info.setTimMessage(v2TIMMessage);
        info.setExtra(TUIKit.getAppContext().getString(R.string.video_extra));
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(64);
        return info;
    }

    public static MessageInfo buildAudioMessage(String recordPath, int duration) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createSoundMessage(recordPath, duration / 1000);
        info.setDataPath(recordPath);
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setExtra(TUIKit.getAppContext().getString(R.string.audio_extra));
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setMsgType(48);
        return info;
    }

    public static MessageInfo buildFileMessage(Uri fileUri) {
        String filePath = FileUtil.getPathFromUri(fileUri);
        File file = new File(filePath);
        if (file.exists()) {
            MessageInfo info = new MessageInfo();
            V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createFileMessage(filePath, file.getName());
            info.setDataPath(filePath);
            info.setSelf(true);
            info.setTimMessage(v2TIMMessage);
            info.setExtra(TUIKit.getAppContext().getString(R.string.file_extra));
            info.setMsgTime(System.currentTimeMillis() / 1000L);
            info.setFromUser(V2TIMManager.getInstance().getLoginUser());
            info.setMsgType(80);
            return info;
        }
        return null;
    }

    public static MessageInfo buildCustomMessage(String data) {
        MessageInfo info = new MessageInfo();
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createCustomMessage(data.getBytes());
        info.setSelf(true);
        info.setTimMessage(v2TIMMessage);
        info.setMsgTime(System.currentTimeMillis() / 1000L);
        info.setMsgType(128);
        info.setFromUser(V2TIMManager.getInstance().getLoginUser());
        info.setExtra(TUIKit.getAppContext().getString(R.string.custom_msg));
        return info;
    }

    public static V2TIMMessage buildGroupCustomMessage(String customMessage) {
        V2TIMMessage v2TIMMessage = V2TIMManager.getMessageManager().createCustomMessage(customMessage.getBytes());
        return v2TIMMessage;
    }

    public static List<MessageInfo> TIMMessages2MessageInfos(List<V2TIMMessage> timMessages, boolean isGroup) {
        if (timMessages == null) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        for (int i = 0; i < timMessages.size(); ++i) {
            V2TIMMessage timMessage = timMessages.get(i);
            List<MessageInfo> info = MessageInfoUtil.TIMMessage2MessageInfo(timMessage);
            if (info == null) continue;
            messageInfos.addAll(info);
        }
        return messageInfos;
    }

    public static List<MessageInfo> TIMMessage2MessageInfo(V2TIMMessage timMessage) {
        if (timMessage == null || timMessage.getStatus() == 4 || timMessage.getElemType() == 0) {
            return null;
        }
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        MessageInfo msgInfo = MessageInfoUtil.createMessageInfo(timMessage);
        if (msgInfo != null) {
            list.add(msgInfo);
        }
        return list;
    }

    public static boolean isOnlineIgnoredDialing(byte[] data) {
        try {
            String str = new String(data, "UTF-8");
            MessageCustom custom = (MessageCustom)new Gson().fromJson(str, MessageCustom.class);
            return custom != null && TextUtils.equals((CharSequence)custom.businessID, (CharSequence)"av_call") && custom.version <= TUIKitConstants.version;
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "parse json error");
            return false;
        }
    }

    public static boolean isTyping(byte[] data) {
        try {
            String str = new String(data, "UTF-8");
            MessageTyping typing = (MessageTyping)new Gson().fromJson(str, MessageTyping.class);
            return typing != null && typing.userAction == 14 && TextUtils.equals((CharSequence)typing.actionParam, (CharSequence)"EIMAMSG_InputStatus_Ing");
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "parse json error");
            return false;
        }
    }

    public static boolean isLive(MessageInfo messageInfo) {
        try {
            JSONObject jsonObject = new JSONObject(new String(messageInfo.getTimMessage().getCustomElem().getData()));
            return jsonObject.getString("roomType") != null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static MessageInfo createMessageInfo(V2TIMMessage timMessage) {
        if (timMessage == null || timMessage.getStatus() == 4 || timMessage.getElemType() == 0) {
            TUIKitLog.e(TAG, "ele2MessageInfo parameters error");
            return null;
        }
        Context context = TUIKit.getAppContext();
        if (context == null) {
            TUIKitLog.e(TAG, "context == null");
            return new MessageInfo();
        }
        final MessageInfo msgInfo = new MessageInfo();
        boolean isGroup = !TextUtils.isEmpty((CharSequence)timMessage.getGroupID());
        String sender = timMessage.getSender();
        msgInfo.setTimMessage(timMessage);
        msgInfo.setGroup(isGroup);
        msgInfo.setId(timMessage.getMsgID());
        msgInfo.setPeerRead(timMessage.isPeerRead());
        msgInfo.setFromUser(sender);
        if (isGroup && !TextUtils.isEmpty((CharSequence)timMessage.getNameCard())) {
            msgInfo.setGroupNameCard(timMessage.getNameCard());
        }
        msgInfo.setMsgTime(timMessage.getTimestamp());
        msgInfo.setSelf(sender.equals(V2TIMManager.getInstance().getLoginUser()));
        int type = timMessage.getElemType();
        if (type == 2) {
            V2TIMCustomElem customElem = timMessage.getCustomElem();
            String data = new String(customElem.getData());
            if (data.equals("group_create")) {
                msgInfo.setMsgType(257);
                String message = TUIKitConstants.covert2HTMLString(TextUtils.isEmpty((CharSequence)msgInfo.getGroupNameCard()) ? msgInfo.getFromUser() : msgInfo.getGroupNameCard()) + TUIKit.getAppContext().getString(R.string.create_group);
                msgInfo.setExtra(message);
            } else {
                if (MessageInfoUtil.isTyping(customElem.getData())) {
                    return null;
                }
                TUIKitLog.i(TAG, "custom data:" + data);
                String content = TUIKit.getAppContext().getString(R.string.custom_msg);
                msgInfo.setMsgType(128);
                msgInfo.setExtra(content);
                Gson gson = new Gson();
                MessageCustom messageCustom = null;
                try {
                    messageCustom = (MessageCustom)gson.fromJson(data, MessageCustom.class);
                    if (!TextUtils.isEmpty((CharSequence)messageCustom.businessID) && messageCustom.businessID.equals("group_create")) {
                        msgInfo.setMsgType(257);
                        String message = TUIKitConstants.covert2HTMLString(messageCustom.opUser) + messageCustom.content;
                        msgInfo.setExtra(message);
                    } else if (!TextUtils.isEmpty((CharSequence)messageCustom.businessID) && messageCustom.businessID.equals("group_live")) {
                        Gson liveGson = new Gson();
                        LiveMessageInfo liveMessageInfo = (LiveMessageInfo)liveGson.fromJson(data, LiveMessageInfo.class);
                        String anchorName = !TextUtils.isEmpty((CharSequence)liveMessageInfo.anchorName) ? liveMessageInfo.anchorName : liveMessageInfo.roomName;
                        content = anchorName + TUIKit.getAppContext().getString(R.string.live_room);
                        msgInfo.setExtra(content);
                    } else if (LiveModel.isLiveRoomSignal(messageCustom.data)) {
                        LiveModel liveModel = LiveModel.convert2LiveData(timMessage);
                        content = liveModel.message;
                        msgInfo.setMsgType(0);
                        msgInfo.setExtra(content);
                    } else {
                        CallModel callModel = CallModel.convert2VideoCallData(timMessage);
                        if (callModel != null) {
                            String senderShowName = timMessage.getSender();
                            if (!TextUtils.isEmpty((CharSequence)timMessage.getNameCard())) {
                                senderShowName = timMessage.getNameCard();
                            } else if (!TextUtils.isEmpty((CharSequence)timMessage.getFriendRemark())) {
                                senderShowName = timMessage.getFriendRemark();
                            } else if (!TextUtils.isEmpty((CharSequence)timMessage.getNickName())) {
                                senderShowName = timMessage.getNickName();
                            }
                            switch (callModel.action) {
                                case 1: {
                                    content = isGroup ? "\"" + senderShowName + "\"" + context.getString(R.string.start_group_call) : context.getString(R.string.start_call);
                                    break;
                                }
                                case 2: {
                                    content = isGroup ? context.getString(R.string.cancle_group_call) : context.getString(R.string.cancle_call);
                                    break;
                                }
                                case 6: {
                                    content = isGroup ? "\"" + senderShowName + "\"" + context.getString(R.string.line_busy) : context.getString(R.string.other_line_busy);
                                    break;
                                }
                                case 3: {
                                    content = isGroup ? "\"" + senderShowName + "\"" + context.getString(R.string.reject_group_calls) : context.getString(R.string.reject_calls);
                                    break;
                                }
                                case 4: {
                                    if (isGroup && callModel.invitedList != null && callModel.invitedList.size() == 1 && callModel.invitedList.get(0).equals(timMessage.getSender())) {
                                        content = "\"" + senderShowName + "\"" + context.getString(R.string.no_response_call);
                                        break;
                                    }
                                    StringBuilder inviteeShowStringBuilder = new StringBuilder();
                                    if (callModel.invitedList != null && callModel.invitedList.size() > 0) {
                                        for (String invitee : callModel.invitedList) {
                                            inviteeShowStringBuilder.append(invitee).append("\u3001");
                                        }
                                        if (inviteeShowStringBuilder.length() > 0) {
                                            inviteeShowStringBuilder.delete(inviteeShowStringBuilder.length() - 1, inviteeShowStringBuilder.length());
                                        }
                                    }
                                    content = isGroup ? "\"" + inviteeShowStringBuilder.toString() + "\"" + context.getString(R.string.no_response_call) : context.getString(R.string.no_response_call);
                                    break;
                                }
                                case 7: {
                                    content = isGroup ? "\"" + senderShowName + "\"" + context.getString(R.string.accept_call) : context.getString(R.string.accept_call);
                                    break;
                                }
                                case 5: {
                                    content = isGroup ? context.getString(R.string.stop_group_call) : context.getString(R.string.stop_call_tip) + DateTimeUtil.formatSecondsTo00(callModel.duration);
                                    break;
                                }
                                default: {
                                    content = context.getString(R.string.invalid_command);
                                }
                            }
                            if (isGroup) {
                                msgInfo.setMsgType(264);
                            } else {
                                msgInfo.setMsgType(0);
                            }
                            msgInfo.setExtra(content);
                        }
                    }
                }
                catch (Exception e) {
                    TUIKitLog.e(TAG, "invalid json: " + data + ", exception:" + e);
                }
            }
        } else if (type == 9) {
            List modifyList;
            V2TIMGroupTipsElem groupTipElem = timMessage.getGroupTipsElem();
            int tipsType = groupTipElem.getType();
            String user = "";
            if (groupTipElem.getMemberList().size() > 0) {
                List v2TIMGroupMemberInfoList = groupTipElem.getMemberList();
                for (int i = 0; i < v2TIMGroupMemberInfoList.size(); ++i) {
                    V2TIMGroupMemberInfo v2TIMGroupMemberInfo = (V2TIMGroupMemberInfo)v2TIMGroupMemberInfoList.get(i);
                    if (i == 0) {
                        user = user + v2TIMGroupMemberInfo.getUserID();
                        continue;
                    }
                    if (i == 2 && v2TIMGroupMemberInfoList.size() > 3) {
                        user = user + context.getString(R.string.etc);
                        break;
                    }
                    user = user + "\uff0c" + v2TIMGroupMemberInfo.getUserID();
                }
            } else {
                user = groupTipElem.getOpMember().getUserID();
            }
            String message = TUIKitConstants.covert2HTMLString(user);
            if (tipsType == 1) {
                msgInfo.setMsgType(259);
                message = message + context.getString(R.string.join_group);
            }
            if (tipsType == 2) {
                msgInfo.setMsgType(259);
                message = message + context.getString(R.string.invite_joined_group);
            }
            if (tipsType == 3) {
                msgInfo.setMsgType(260);
                message = message + context.getString(R.string.quit_group);
            }
            if (tipsType == 4) {
                msgInfo.setMsgType(261);
                message = message + context.getString(R.string.kick_group_tip);
            }
            if (tipsType == 5) {
                msgInfo.setMsgType(263);
                message = message + context.getString(R.string.be_group_manager);
            }
            if (tipsType == 6) {
                msgInfo.setMsgType(263);
                message = message + context.getString(R.string.cancle_group_manager);
            }
            if (tipsType == 7) {
                List modifyList2 = groupTipElem.getGroupChangeInfoList();
                for (int i = 0; i < modifyList2.size(); ++i) {
                    V2TIMGroupChangeInfo modifyInfo = (V2TIMGroupChangeInfo)modifyList2.get(i);
                    int modifyType = modifyInfo.getType();
                    if (modifyType == 1) {
                        msgInfo.setMsgType(262);
                        message = message + context.getString(R.string.modify_group_name_is) + "\"" + modifyInfo.getValue() + "\"";
                    } else if (modifyType == 3) {
                        msgInfo.setMsgType(263);
                        message = message + context.getString(R.string.modify_notice) + "\"" + modifyInfo.getValue() + "\"";
                    } else if (modifyType == 5) {
                        msgInfo.setMsgType(263);
                        message = message + context.getString(R.string.move_owner) + "\"" + modifyInfo.getValue() + "\"";
                    } else if (modifyType == 4) {
                        msgInfo.setMsgType(263);
                        message = message + context.getString(R.string.modify_group_avatar);
                    } else if (modifyType == 2) {
                        msgInfo.setMsgType(263);
                        message = message + context.getString(R.string.modify_notice) + "\"" + modifyInfo.getValue() + "\"";
                    }
                    if (i >= modifyList2.size() - 1) continue;
                    message = message + "\u3001";
                }
            }
            if (tipsType == 8 && (modifyList = groupTipElem.getMemberChangeInfoList()).size() > 0) {
                long shutupTime = ((V2TIMGroupMemberChangeInfo)modifyList.get(0)).getMuteTime();
                if (shutupTime > 0L) {
                    msgInfo.setMsgType(263);
                    message = message + context.getString(R.string.banned) + "\"" + DateTimeUtil.formatSeconds(shutupTime) + "\"";
                } else {
                    msgInfo.setMsgType(263);
                    message = message + context.getString(R.string.cancle_banned);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                return null;
            }
            msgInfo.setExtra(message);
        } else {
            if (type == 1) {
                V2TIMTextElem txtEle = timMessage.getTextElem();
                msgInfo.setExtra(txtEle.getText());
            } else if (type == 8) {
                V2TIMFaceElem faceElem = timMessage.getFaceElem();
                if (faceElem.getIndex() < 1 || faceElem.getData() == null) {
                    TUIKitLog.e("MessageInfoUtil", "faceElem data is null or index<1");
                    return null;
                }
                msgInfo.setExtra(context.getString(R.string.custom_emoji));
            } else if (type == 4) {
                V2TIMSoundElem soundElemEle = timMessage.getSoundElem();
                if (msgInfo.isSelf()) {
                    msgInfo.setDataPath(soundElemEle.getPath());
                } else {
                    final String path = TUIKitConstants.RECORD_DOWNLOAD_DIR + soundElemEle.getUUID();
                    File file = new File(path);
                    if (!file.exists()) {
                        soundElemEle.downloadSound(path, new V2TIMDownloadCallback(){

                            public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                                long currentSize = progressInfo.getCurrentSize();
                                long totalSize = progressInfo.getTotalSize();
                                int progress = 0;
                                if (totalSize > 0L) {
                                    progress = (int)(100L * currentSize / totalSize);
                                }
                                if (progress > 100) {
                                    progress = 100;
                                }
                                TUIKitLog.i("MessageInfoUtil getSoundToFile", "progress:" + progress);
                            }

                            public void onError(int code, String desc) {
                                TUIKitLog.e("MessageInfoUtil getSoundToFile", code + ":" + desc);
                            }

                            public void onSuccess() {
                                msgInfo.setDataPath(path);
                            }
                        });
                    } else {
                        msgInfo.setDataPath(path);
                    }
                }
                msgInfo.setExtra(context.getString(R.string.audio_extra));
            } else if (type == 3) {
                V2TIMImageElem imageEle = timMessage.getImageElem();
                String localPath = imageEle.getPath();
                if (msgInfo.isSelf() && !TextUtils.isEmpty((CharSequence)localPath)) {
                    msgInfo.setDataPath(localPath);
                    int[] size = ImageUtil.getImageSize(localPath);
                    msgInfo.setImgWidth(size[0]);
                    msgInfo.setImgHeight(size[1]);
                } else {
                    List imgs = imageEle.getImageList();
                    for (int i = 0; i < imgs.size(); ++i) {
                        V2TIMImageElem.V2TIMImage img = (V2TIMImageElem.V2TIMImage)imgs.get(i);
                        if (img.getType() != 1) continue;
                        String path = TUIKitConstants.IMAGE_DOWNLOAD_DIR + img.getUUID();
                        msgInfo.setImgWidth(img.getWidth());
                        msgInfo.setImgHeight(img.getHeight());
                        File file = new File(path);
                        if (!file.exists()) continue;
                        msgInfo.setDataPath(path);
                    }
                }
                msgInfo.setExtra(context.getString(R.string.picture_extra));
            } else if (type == 5) {
                V2TIMVideoElem videoEle = timMessage.getVideoElem();
                if (msgInfo.isSelf() && !TextUtils.isEmpty((CharSequence)videoEle.getSnapshotPath())) {
                    int[] size = ImageUtil.getImageSize(videoEle.getSnapshotPath());
                    msgInfo.setImgWidth(size[0]);
                    msgInfo.setImgHeight(size[1]);
                    msgInfo.setDataPath(videoEle.getSnapshotPath());
                    msgInfo.setDataUri(FileUtil.getUriFromPath(videoEle.getVideoPath()));
                } else {
                    String videoPath = TUIKitConstants.VIDEO_DOWNLOAD_DIR + videoEle.getVideoUUID();
                    Uri uri = Uri.parse((String)videoPath);
                    msgInfo.setDataUri(uri);
                    msgInfo.setImgWidth(videoEle.getSnapshotWidth());
                    msgInfo.setImgHeight(videoEle.getSnapshotHeight());
                    String snapPath = TUIKitConstants.IMAGE_DOWNLOAD_DIR + videoEle.getSnapshotUUID();
                    if (new File(snapPath).exists()) {
                        msgInfo.setDataPath(snapPath);
                    }
                }
                msgInfo.setExtra(context.getString(R.string.video_extra));
            } else if (type == 6) {
                String path;
                File file;
                V2TIMFileElem fileElem = timMessage.getFileElem();
                String filename = fileElem.getUUID();
                if (TextUtils.isEmpty((CharSequence)filename)) {
                    filename = System.currentTimeMillis() + fileElem.getFileName();
                }
                if ((file = new File(path = TUIKitConstants.FILE_DOWNLOAD_DIR + filename)).exists()) {
                    if (msgInfo.isSelf()) {
                        msgInfo.setStatus(2);
                    } else {
                        msgInfo.setStatus(6);
                    }
                    msgInfo.setDataPath(path);
                } else if (msgInfo.isSelf()) {
                    if (TextUtils.isEmpty((CharSequence)fileElem.getPath())) {
                        msgInfo.setStatus(5);
                        msgInfo.setDataPath(path);
                    } else {
                        file = new File(fileElem.getPath());
                        if (file.exists()) {
                            msgInfo.setStatus(2);
                            msgInfo.setDataPath(fileElem.getPath());
                        } else {
                            msgInfo.setStatus(5);
                            msgInfo.setDataPath(path);
                        }
                    }
                } else {
                    msgInfo.setStatus(5);
                    msgInfo.setDataPath(path);
                }
                msgInfo.setExtra(context.getString(R.string.file_extra));
            }
            msgInfo.setMsgType(MessageInfoUtil.TIMElemType2MessageInfoType(type));
        }
        if (timMessage.getStatus() == 6) {
            msgInfo.setStatus(275);
            msgInfo.setMsgType(275);
            if (msgInfo.isSelf()) {
                msgInfo.setExtra(context.getString(R.string.revoke_tips_you));
            } else if (msgInfo.isGroup()) {
                String message = TUIKitConstants.covert2HTMLString(msgInfo.getFromUser());
                msgInfo.setExtra(message + context.getString(R.string.revoke_tips));
            } else {
                msgInfo.setExtra(context.getString(R.string.revoke_tips_other));
            }
        } else if (msgInfo.isSelf()) {
            if (timMessage.getStatus() == 3) {
                msgInfo.setStatus(3);
            } else if (timMessage.getStatus() == 2) {
                msgInfo.setStatus(2);
            } else if (timMessage.getStatus() == 1) {
                msgInfo.setStatus(1);
            }
        }
        return msgInfo;
    }

    private static int TIMElemType2MessageInfoType(int type) {
        switch (type) {
            case 1: {
                return 0;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 48;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 80;
            }
            case 7: {
                return 96;
            }
            case 8: {
                return 112;
            }
            case 9: {
                return 256;
            }
        }
        return -1;
    }
}

