/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.content.Context;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    private static final long minute = 60000L;
    private static final long hour = 3600000L;
    private static final long day = 86400000L;
    private static final long month = 2678400000L;
    private static final long year = 32140800000L;

    public static String getTimeFormatText(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int currentDayIndex = calendar.get(6);
        int currentYear = calendar.get(1);
        calendar.setTime(date);
        int msgYear = calendar.get(1);
        int msgDayIndex = calendar.get(6);
        int msgMinute = calendar.get(12);
        String msgTimeStr = calendar.get(11) + ":";
        msgTimeStr = msgMinute < 10 ? msgTimeStr + "0" + msgMinute : msgTimeStr + msgMinute;
        int msgDayInWeek = calendar.get(7);
        if (currentDayIndex == msgDayIndex) {
            return msgTimeStr;
        }
        Context context = TUIKit.getAppContext();
        msgTimeStr = currentDayIndex - msgDayIndex == 1 && currentYear == msgYear ? context.getString(R.string.date_yesterday) + msgTimeStr : msgYear + "/" + Integer.valueOf(calendar.get(2) + 1) + "/" + calendar.get(5) + " " + msgTimeStr + " ";
        return msgTimeStr;
    }

    public static String formatSeconds(long seconds) {
        Context context = TUIKit.getAppContext();
        String timeStr = seconds + context.getString(R.string.date_second_short);
        if (seconds > 60L) {
            long second = seconds % 60L;
            long min = seconds / 60L;
            timeStr = min + context.getString(R.string.date_minute_short) + second + context.getString(R.string.date_second_short);
            if (min > 60L) {
                min = seconds / 60L % 60L;
                long hour = seconds / 60L / 60L;
                timeStr = hour + context.getString(R.string.date_hour_short) + min + context.getString(R.string.date_minute_short) + second + context.getString(R.string.date_second_short);
                if (hour % 24L == 0L) {
                    long day = seconds / 60L / 60L / 24L;
                    timeStr = day + context.getString(R.string.date_day_short);
                } else if (hour > 24L) {
                    hour = seconds / 60L / 60L % 24L;
                    long day = seconds / 60L / 60L / 24L;
                    timeStr = day + context.getString(R.string.date_day_short) + hour + context.getString(R.string.date_hour_short) + min + context.getString(R.string.date_minute_short) + second + context.getString(R.string.date_second_short);
                }
            }
        }
        return timeStr;
    }

    public static String formatSecondsTo00(int timeSeconds) {
        int second = timeSeconds % 60;
        int minuteTemp = timeSeconds / 60;
        if (minuteTemp > 0) {
            int minute = minuteTemp % 60;
            int hour = minuteTemp / 60;
            if (hour > 0) {
                return (hour > 10 ? hour + "" : "0" + hour) + ":" + (minute > 10 ? minute + "" : "0" + minute) + ":" + (second > 10 ? second + "" : "0" + second);
            }
            return (minute > 10 ? minute + "" : "0" + minute) + ":" + (second > 10 ? second + "" : "0" + second);
        }
        return "00:" + (second > 10 ? second + "" : "0" + second);
    }
}

