/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitFileProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FileUtil {
    public static final String DOCUMENTS_DIR = "documents";
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;

    public static void initPath() {
        File f = new File(TUIKitConstants.MEDIA_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.RECORD_DIR)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.RECORD_DOWNLOAD_DIR)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.VIDEO_DOWNLOAD_DIR)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.IMAGE_DOWNLOAD_DIR)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.FILE_DOWNLOAD_DIR)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(TUIKitConstants.CRASH_LOG_DIR)).exists()) {
            f.mkdirs();
        }
    }

    public static String saveBitmap(String dir, Bitmap b) {
        String jpegName = TUIKitConstants.MEDIA_DIR + File.separator + "picture_" + new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date()) + ".jpg";
        try {
            FileOutputStream fout = new FileOutputStream(jpegName);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
            return jpegName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean deleteFile(String url) {
        boolean result = false;
        File file = new File(url);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static String getPathFromUri(Uri uri) {
        String path = "";
        try {
            int sdkVersion = Build.VERSION.SDK_INT;
            path = sdkVersion >= 19 ? FileUtil.getPath(TUIKit.getAppContext(), uri) : FileUtil.getRealFilePath(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (path == null) {
            path = "";
        }
        return path;
    }

    public static String getRealFilePath(Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = TUIKit.getAppContext().getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static Uri getUriFromPath(String path) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                return TUIKitFileProvider.getUriForFile((Context)TUIKit.getAppContext(), (String)(TUIKit.getAppContext().getApplicationInfo().packageName + ".uikit.fileprovider"), (File)new File(path));
            }
            return Uri.fromFile((File)new File(path));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkAudioExist(String fileName) {
        File file = new File(TUIKitConstants.RECORD_DOWNLOAD_DIR);
        if (!file.exists()) {
            return false;
        }
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtil.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtil.isDownloadsDocument(uri)) {
                    String[] contentUriPrefixesToTry;
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    if (id2.startsWith("raw:")) {
                        String path = id2.replaceFirst("raw:", "");
                        return path;
                    }
                    for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads", "content://downloads/all_downloads"}) {
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id2));
                        try {
                            String path = FileUtil.getDataColumn(context, contentUri, null, null);
                            if (path == null) continue;
                            return path;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String destinationPath = FileUtil.getPathByCopyFile(context, uri);
                    return destinationPath;
                }
                if (FileUtil.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    String path = FileUtil.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                    if (TextUtils.isEmpty((CharSequence)path)) {
                        path = FileUtil.getPathByCopyFile(context, uri);
                    }
                    return path;
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                String path = FileUtil.getDataColumn(context, uri, null, null);
                if (TextUtils.isEmpty((CharSequence)path)) {
                    path = FileUtil.getPathByCopyFile(context, uri);
                }
                return path;
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    private static String getPathByCopyFile(Context context, Uri uri) {
        String fileName = FileUtil.getFileName(context, uri);
        File cacheDir = FileUtil.getDocumentCacheDir(context);
        File file = FileUtil.generateFileName(fileName, cacheDir);
        String destinationPath = null;
        if (file != null) {
            destinationPath = file.getAbsolutePath();
            FileUtil.saveFileFromUri(context, uri, destinationPath);
        }
        return destinationPath;
    }

    @Nullable
    private static File generateFileName(@Nullable String name, File directory) {
        if (name == null) {
            return null;
        }
        File file = new File(directory, name);
        if (file.exists()) {
            String fileName = name;
            String extension = "";
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = name.substring(0, dotIndex);
                extension = name.substring(dotIndex);
            }
            int index = 0;
            while (file.exists()) {
                name = fileName + '(' + ++index + ')' + extension;
                file = new File(directory, name);
            }
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return file;
    }

    private static String getFileName(@NonNull Context context, Uri uri) {
        String mimeType = context.getContentResolver().getType(uri);
        String filename = null;
        if (mimeType == null && context != null) {
            filename = FileUtil.getName(uri.toString());
        } else {
            Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
            if (returnCursor != null) {
                int nameIndex = returnCursor.getColumnIndex("_display_name");
                returnCursor.moveToFirst();
                filename = returnCursor.getString(nameIndex);
                returnCursor.close();
            }
        }
        return filename;
    }

    private static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(47);
        return filename.substring(index + 1);
    }

    private static File getDocumentCacheDir(@NonNull Context context) {
        File dir = new File(context.getCacheDir(), DOCUMENTS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFileFromUri(Context context, Uri uri, String destinationPath) {
        InputStream is = null;
        FilterOutputStream bos = null;
        try {
            is = context.getContentResolver().openInputStream(uri);
            bos = new BufferedOutputStream(new FileOutputStream(destinationPath, false));
            byte[] buf = new byte[1024];
            is.read(buf);
            do {
                bos.write(buf);
            } while (is.read(buf) != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static double getFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtil.getFileSizes(file) : FileUtil.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtil.FormetFileSize(blockSize, sizeType);
    }

    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtil.getFileSizes(file) : FileUtil.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtil.FormetFileSize(blockSize);
    }

    public static long getFileSize(File file) {
        long size = 0L;
        try {
            if (file.exists()) {
                FileInputStream fis = null;
                fis = new FileInputStream(file);
                size = fis.available();
            } else {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    private static long getFileSizes(File f) {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtil.getFileSizes(flist[i]);
                continue;
            }
            size += FileUtil.getFileSize(flist[i]);
        }
        return size;
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    private static double FormetFileSize(long fileS, int sizeType) {
        DecimalFormat df = new DecimalFormat("#.00");
        double fileSizeLong = 0.0;
        switch (sizeType) {
            case 1: {
                fileSizeLong = Double.valueOf(df.format((double)fileS));
                break;
            }
            case 2: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1024.0));
                break;
            }
            case 3: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1048576.0));
                break;
            }
            case 4: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1.073741824E9));
                break;
            }
        }
        return fileSizeLong;
    }

    public static String reNameFile(File file, final String fileName) {
        String filePath = TUIKitConstants.FILE_DOWNLOAD_DIR + fileName;
        if (new File(filePath).exists()) {
            File baseFile = new File(TUIKitConstants.FILE_DOWNLOAD_DIR);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(fileName);
                }
            };
            File[] files = baseFile.listFiles(fileFilter);
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            File lastFile = fileList.get(0);
            String[] indexStr = lastFile.getName().split(fileName);
            int index = 0;
            if (indexStr.length > 1) {
                Integer.parseInt(indexStr[1].split("\\(")[1].split("\\)")[0]);
                ++index;
            }
            String newName = fileName + "(" + index + ")";
            File dest = new File(TUIKitConstants.FILE_DOWNLOAD_DIR + newName);
            file.renameTo(dest);
            return newName;
        }
        File dest = new File(filePath);
        file.renameTo(dest);
        return fileName;
    }
}

