/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.text.TextUtils;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File storeBitmap(File outFile, Bitmap bitmap) {
        if (!outFile.exists() || outFile.isDirectory()) {
            outFile.getParentFile().mkdirs();
        }
        FileOutputStream fOut = null;
        try {
            outFile.deleteOnExit();
            outFile.createNewFile();
            fOut = new FileOutputStream(outFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fOut);
            fOut.flush();
        }
        catch (IOException e1) {
            outFile.deleteOnExit();
        }
        finally {
            if (null != fOut) {
                try {
                    fOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    outFile.deleteOnExit();
                }
            }
        }
        return outFile;
    }

    public static Bitmap getBitmapFormPath(Uri uri) {
        Bitmap bitmap = null;
        try {
            InputStream input = TUIKit.getAppContext().getContentResolver().openInputStream(uri);
            BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
            onlyBoundsOptions.inJustDecodeBounds = true;
            onlyBoundsOptions.inDither = true;
            onlyBoundsOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)onlyBoundsOptions);
            input.close();
            int originalWidth = onlyBoundsOptions.outWidth;
            int originalHeight = onlyBoundsOptions.outHeight;
            if (originalWidth == -1 || originalHeight == -1) {
                return null;
            }
            float hh = 800.0f;
            float ww = 480.0f;
            int degree = ImageUtil.getBitmapDegree(uri);
            if (degree == 90 || degree == 270) {
                hh = 480.0f;
                ww = 800.0f;
            }
            int be = 1;
            if (originalWidth > originalHeight && (float)originalWidth > ww) {
                be = (int)((float)originalWidth / ww);
            } else if (originalWidth < originalHeight && (float)originalHeight > hh) {
                be = (int)((float)originalHeight / hh);
            }
            if (be <= 0) {
                be = 1;
            }
            BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
            bitmapOptions.inSampleSize = be;
            bitmapOptions.inDither = true;
            bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
            input = TUIKit.getAppContext().getContentResolver().openInputStream(uri);
            bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)bitmapOptions);
            input.close();
            ImageUtil.compressImage(bitmap);
            bitmap = ImageUtil.rotateBitmapByDegree(bitmap, degree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getBitmapFormPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return ImageUtil.getBitmapFormPath(Uri.fromFile((File)new File(path)));
    }

    public static Bitmap compressImage(Bitmap image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > 100) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            options -= 10;
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        return bitmap;
    }

    public static int getBitmapDegree(Uri uri) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(FileUtil.getPathFromUri(uri));
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static int getBitmapDegree(String fileName) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(fileName);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap returnBm = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            returnBm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (returnBm == null) {
            returnBm = bm;
        }
        if (bm != returnBm) {
            bm.recycle();
        }
        return returnBm;
    }

    public static int[] getImageSize(String path) {
        int[] size = new int[2];
        try {
            BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
            onlyBoundsOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)onlyBoundsOptions);
            int originalWidth = onlyBoundsOptions.outWidth;
            int originalHeight = onlyBoundsOptions.outHeight;
            int degree = ImageUtil.getBitmapDegree(path);
            if (degree == 0) {
                size[0] = originalWidth;
                size[1] = originalHeight;
            } else {
                float hh = 800.0f;
                float ww = 480.0f;
                if (degree == 90 || degree == 270) {
                    hh = 480.0f;
                    ww = 800.0f;
                }
                int be = 1;
                if (originalWidth > originalHeight && (float)originalWidth > ww) {
                    be = (int)((float)originalWidth / ww);
                } else if (originalWidth < originalHeight && (float)originalHeight > hh) {
                    be = (int)((float)originalHeight / hh);
                }
                if (be <= 0) {
                    be = 1;
                }
                BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
                bitmapOptions.inSampleSize = be;
                bitmapOptions.inDither = true;
                bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
                Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)bitmapOptions);
                bitmap = ImageUtil.rotateBitmapByDegree(bitmap, degree);
                size[0] = bitmap.getWidth();
                size[1] = bitmap.getHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getImageSize(Uri uri) {
        int[] size = new int[2];
        try {
            InputStream is = TUIKit.getAppContext().getContentResolver().openInputStream(uri);
            BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
            onlyBoundsOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)onlyBoundsOptions);
            int originalWidth = onlyBoundsOptions.outWidth;
            int originalHeight = onlyBoundsOptions.outHeight;
            int degree = ImageUtil.getBitmapDegree(uri);
            if (degree == 0) {
                size[0] = originalWidth;
                size[1] = originalHeight;
            } else {
                float hh = 800.0f;
                float ww = 480.0f;
                if (degree == 90 || degree == 270) {
                    hh = 480.0f;
                    ww = 800.0f;
                }
                int be = 1;
                if (originalWidth > originalHeight && (float)originalWidth > ww) {
                    be = (int)((float)originalWidth / ww);
                } else if (originalWidth < originalHeight && (float)originalHeight > hh) {
                    be = (int)((float)originalHeight / hh);
                }
                if (be <= 0) {
                    be = 1;
                }
                BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
                bitmapOptions.inSampleSize = be;
                bitmapOptions.inDither = true;
                bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
                is = TUIKit.getAppContext().getContentResolver().openInputStream(uri);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)bitmapOptions);
                bitmap = ImageUtil.rotateBitmapByDegree(bitmap, degree);
                size[0] = bitmap.getWidth();
                size[1] = bitmap.getHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static CopyImageInfo copyImage(String path, String dir) {
        CopyImageInfo info = new CopyImageInfo();
        if (null == path) {
            return null;
        }
        try {
            int index = path.lastIndexOf(".");
            String fileType = "";
            if (index >= 0) {
                fileType = path.substring(index + 1);
            }
            String newFileName = dir + File.separator + System.currentTimeMillis() + "." + fileType;
            FileInputStream is = new FileInputStream(new File(path));
            int degree = ImageUtil.getBitmapDegree(path);
            File file = new File(newFileName);
            BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
            onlyBoundsOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)onlyBoundsOptions);
            info.setWidth(onlyBoundsOptions.outWidth);
            info.setHeight(onlyBoundsOptions.outHeight);
            if (degree == 0) {
                int c;
                is = new FileInputStream(new File(path));
                FileOutputStream os = new FileOutputStream(file);
                byte[] bt = new byte[10240];
                while ((c = ((InputStream)is).read(bt)) > 0) {
                    ((OutputStream)os).write(bt, 0, c);
                }
                ((InputStream)is).close();
                ((OutputStream)os).close();
            } else {
                int ww = 400;
                int hh = 800;
                if (degree == 90 || degree == 270) {
                    ww = 800;
                    hh = 400;
                }
                int be = 1;
                if (info.width > info.height && info.width > ww) {
                    be = info.width / ww;
                } else if (info.width < info.height && info.height > hh) {
                    be = info.height / hh;
                }
                if (be <= 0) {
                    be = 1;
                }
                BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
                bitmapOptions.inSampleSize = be;
                bitmapOptions.inDither = true;
                bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
                is = new FileInputStream(new File(path));
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)bitmapOptions);
                bitmap = ImageUtil.rotateBitmapByDegree(bitmap, degree);
                info.setWidth(bitmap.getWidth());
                info.setHeight(bitmap.getHeight());
                ImageUtil.storeBitmap(file, bitmap);
            }
            info.setPath(newFileName);
            return info;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float bottom;
        float right;
        float top;
        float left;
        float roundPx;
        int height;
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            left = 0.0f;
            top = 0.0f;
            right = width;
            bottom = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle(roundPx, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    public static class CopyImageInfo {
        String path;
        int width;
        int height;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

