/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DecimalFormat;

public class NetWorkUtils {
    private static final String TAG = "NetWorkUtils";
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_WIFI = -101;
    private static final int NETWORK_CLASS_WIFI = -101;
    private static final int NETWORK_CLASS_UNAVAILABLE = -1;
    private static final int NETWORK_CLASS_UNKNOWN = 0;
    private static final int NETWORK_CLASS_2_G = 1;
    private static final int NETWORK_CLASS_3_G = 2;
    private static final int NETWORK_CLASS_4_G = 3;
    public static boolean sIMSDKConnected;
    private static DecimalFormat df;

    public static boolean isWifiAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static String getMacAddress(Context context) {
        if (context == null) {
            return "";
        }
        String localMac = null;
        if (NetWorkUtils.isWifiAvailable(context)) {
            localMac = NetWorkUtils.getWifiMacAddress(context);
        }
        if (localMac != null && localMac.length() > 0) {
            localMac = localMac.replace(":", "-").toLowerCase();
            return localMac;
        }
        localMac = NetWorkUtils.getMacFromCallCmd();
        if (localMac != null) {
            localMac = localMac.replace(":", "-").toLowerCase();
        }
        return localMac;
    }

    private static String getWifiMacAddress(Context context) {
        String localMac = null;
        try {
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            if (wifi.isWifiEnabled() && (localMac = info.getMacAddress()) != null) {
                localMac = localMac.replace(":", "-").toLowerCase();
                return localMac;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getMacFromCallCmd() {
        String Mac;
        String result = "";
        result = NetWorkUtils.callCmd("busybox ifconfig", "HWaddr");
        if (result == null || result.length() <= 0) {
            return null;
        }
        TUIKitLog.v(TAG, "cmd result : " + result);
        if (result.length() > 0 && result.contains("HWaddr") && (Mac = result.substring(result.indexOf("HWaddr") + 6, result.length() - 1)).length() > 1) {
            result = Mac.replaceAll(" ", "");
        }
        return result;
    }

    public static String callCmd(String cmd, String filter) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null && !line.contains(filter)) {
            }
            result = line;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean IsNetWorkEnable(Context context) {
        try {
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity == null) {
                return false;
            }
            NetworkInfo info = connectivity.getActiveNetworkInfo();
            if (info != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String formatSize(long size) {
        String unit = "B";
        float len = size;
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "KB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "MB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "GB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "TB";
        }
        return df.format(len) + unit;
    }

    public static String formatSizeBySecond(long size) {
        String unit = "B";
        float len = size;
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "KB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "MB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "GB";
        }
        if (len > 900.0f) {
            len /= 1024.0f;
            unit = "TB";
        }
        return df.format(len) + unit + "/s";
    }

    public static String format(long size) {
        String unit = "B";
        float len = size;
        if (len > 1000.0f) {
            len /= 1024.0f;
            unit = "KB";
            if (len > 1000.0f) {
                len /= 1024.0f;
                unit = "MB";
                if (len > 1000.0f) {
                    len /= 1024.0f;
                    unit = "GB";
                }
            }
        }
        return df.format(len) + "\n" + unit + "/s";
    }

    public static String getCurrentNetworkType(Context context) {
        int networkClass = NetWorkUtils.getNetworkClass(context);
        String type = "\u672a\u77e5";
        switch (networkClass) {
            case -1: {
                type = "\u65e0";
                break;
            }
            case -101: {
                type = "Wi-Fi";
                break;
            }
            case 1: {
                type = "2G";
                break;
            }
            case 2: {
                type = "3G";
                break;
            }
            case 3: {
                type = "4G";
                break;
            }
            case 0: {
                type = "\u672a\u77e5";
            }
        }
        return type;
    }

    private static int getNetworkClassByType(int networkType) {
        switch (networkType) {
            case -1: {
                return -1;
            }
            case -101: {
                return -101;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    private static int getNetworkClass(Context context) {
        int networkType = 0;
        try {
            NetworkInfo network = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected()) {
                int type = network.getType();
                if (type == 1) {
                    networkType = -101;
                } else if (type == 0) {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    networkType = telephonyManager.getNetworkType();
                }
            } else {
                networkType = -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return NetWorkUtils.getNetworkClassByType(networkType);
    }

    public static String getWifiRssi(Context context) {
        int asu = 85;
        try {
            WifiManager wifiManager;
            WifiInfo wifiInfo;
            int type;
            NetworkInfo network = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected() && (type = network.getType()) == 1 && (wifiInfo = (wifiManager = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null) {
                asu = wifiInfo.getRssi();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asu + "dBm";
    }

    public static String getWifiSsid(Context context) {
        String ssid = "";
        try {
            WifiManager wifiManager;
            WifiInfo wifiInfo;
            int type;
            NetworkInfo network = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected() && (type = network.getType()) == 1 && (wifiInfo = (wifiManager = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null) {
                ssid = wifiInfo.getSSID();
                if (ssid == null) {
                    ssid = "";
                }
                ssid = ssid.replaceAll("\"", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssid;
    }

    public static boolean checkSimState(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimState() != 1 && tm.getSimState() != 0;
    }

    static {
        df = new DecimalFormat("#.##");
    }
}

