/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;

public class PermissionUtils {
    private static final String TAG = PermissionUtils.class.getSimpleName();
    private static AlertDialog mPermissionDialog;

    public static boolean checkPermission(Context context, String permission2) {
        int result;
        TUIKitLog.i(TAG, "checkPermission permission:" + permission2 + "|sdk:" + Build.VERSION.SDK_INT);
        boolean flag = true;
        if (Build.VERSION.SDK_INT >= 23 && 0 != (result = ActivityCompat.checkSelfPermission((Context)context, (String)permission2))) {
            PermissionUtils.showPermissionDialog(context);
            flag = false;
        }
        return flag;
    }

    private static void showPermissionDialog(final Context context) {
        if (mPermissionDialog == null) {
            mPermissionDialog = new AlertDialog.Builder(context).setMessage((CharSequence)TUIKit.getAppContext().getString(R.string.permission_content)).setPositiveButton((CharSequence)TUIKit.getAppContext().getString(R.string.setting), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PermissionUtils.cancelPermissionDialog();
                    Uri packageURI = Uri.parse((String)("package:" + context.getPackageName()));
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageURI);
                    context.startActivity(intent);
                }
            }).setNegativeButton((CharSequence)TUIKit.getAppContext().getString(R.string.cancel), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PermissionUtils.cancelPermissionDialog();
                }
            }).create();
        }
        mPermissionDialog.show();
    }

    private static void cancelPermissionDialog() {
        mPermissionDialog.cancel();
    }
}

