/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.SoftKeyBoardUtil;

public class PopWindowUtil {
    public static AlertDialog buildCustomDialog(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            return null;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)activity, R.style.TUIKit_Theme_Transparent));
        builder.setTitle((CharSequence)"");
        builder.setCancelable(true);
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public static AlertDialog buildFullScreenDialog(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            return null;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)"");
        builder.setCancelable(true);
        AlertDialog dialog = builder.create();
        dialog.getWindow().setDimAmount(0.0f);
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        dialog.getWindow().setLayout(-1, -1);
        dialog.getWindow().setBackgroundDrawable(null);
        return dialog;
    }

    public static final AlertDialog buildEditorDialog(Context context, String title, String cancel, String sure, final boolean autoDismiss, final EnsureListener listener) {
        if (context instanceof Activity && Build.VERSION.SDK_INT >= 17 && ((Activity)context).isDestroyed()) {
            return null;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)title);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        View baseView = LayoutInflater.from((Context)context).inflate(R.layout.layout_dialog, null);
        ((TextView)baseView.findViewById(R.id.dialog_title)).setText((CharSequence)title);
        ((TextView)baseView.findViewById(R.id.dialog_cancel_btn)).setText((CharSequence)cancel);
        ((TextView)baseView.findViewById(R.id.dialog_sure_btn)).setText((CharSequence)sure);
        final EditText editText = (EditText)baseView.findViewById(R.id.dialog_editor);
        baseView.findViewById(R.id.dialog_sure_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SoftKeyBoardUtil.hideKeyBoard(editText);
                if (listener != null) {
                    listener.sure(editText.getText().toString());
                }
                dialog.dismiss();
                if (autoDismiss) {
                    dialog.dismiss();
                }
            }
        });
        baseView.findViewById(R.id.dialog_cancel_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SoftKeyBoardUtil.hideKeyBoard(editText);
                if (listener != null) {
                    listener.cancel();
                }
                dialog.dismiss();
            }
        });
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = ScreenUtil.getPxByDp(320.0f);
        lp.height = -2;
        dialog.getWindow().setAttributes(lp);
        dialog.setContentView(baseView);
        dialog.getWindow().clearFlags(131072);
        return dialog;
    }

    public static final AlertDialog buildEnsureDialog(Context context, String title, String content, String cancel, String sure, final EnsureListener listener) {
        if (context instanceof Activity && ((Activity)context).isDestroyed()) {
            return null;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)title);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        View baseView = LayoutInflater.from((Context)context).inflate(R.layout.layout_ensure_dialog, null);
        ((TextView)baseView.findViewById(R.id.dialog_title)).setText((CharSequence)title);
        ((TextView)baseView.findViewById(R.id.dialog_cancel_btn)).setText((CharSequence)cancel);
        ((TextView)baseView.findViewById(R.id.dialog_sure_btn)).setText((CharSequence)sure);
        if (!TextUtils.isEmpty((CharSequence)content)) {
            ((TextView)baseView.findViewById(R.id.dialog_content)).setText((CharSequence)content);
        } else {
            baseView.findViewById(R.id.dialog_content).setVisibility(8);
        }
        baseView.findViewById(R.id.dialog_sure_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.sure(null);
                }
                dialog.dismiss();
            }
        });
        baseView.findViewById(R.id.dialog_cancel_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.cancel();
                }
                dialog.dismiss();
            }
        });
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = ScreenUtil.getPxByDp(320.0f);
        lp.height = -2;
        dialog.getWindow().setAttributes(lp);
        dialog.setContentView(baseView);
        dialog.getWindow().clearFlags(131072);
        return dialog;
    }

    public static PopupWindow popupWindow(View windowView, View parent, int x, int y) {
        PopupWindow popup = new PopupWindow(windowView, -2, -2);
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        popup.setBackgroundDrawable((Drawable)new ColorDrawable(-1360073216));
        popup.showAtLocation(windowView, 49, x, y);
        return popup;
    }

    private static int[] calculatePopWindowPos(View windowView, View parentView, float x, float y) {
        int[] windowPos = new int[2];
        int[] anchorLoc = new int[]{parentView.getWidth(), parentView.getHeight()};
        int addHeight = 0;
        windowView.measure(0, 0);
        int windowHeight = ScreenUtil.getPxByDp(150.0f);
        int windowWidth = windowView.getMeasuredWidth();
        windowPos[1] = (float)anchorLoc[1] - y < (float)windowHeight ? (int)y + addHeight - windowHeight : (int)y + addHeight;
        windowPos[0] = (float)anchorLoc[0] - x < (float)windowWidth ? (int)x - windowWidth : (int)x;
        return windowPos;
    }

    public static interface EnsureListener {
        public void sure(Object var1);

        public void cancel();
    }
}

