/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.lang.reflect.Method;

public class ScreenUtil {
    private static final String TAG = ScreenUtil.class.getSimpleName();
    private static int navigationBarHeight = 0;
    private static int SOFT_INPUT_HEIGHT = 0;

    public static boolean checkNavigationBarShow(@NonNull Context context, @NonNull Window window) {
        boolean show;
        Display display = window.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        display.getRealSize(point);
        View decorView = window.getDecorView();
        Configuration conf = context.getResources().getConfiguration();
        if (2 == conf.orientation) {
            View contentView = decorView.findViewById(0x1020002);
            show = point.x != contentView.getWidth();
        } else {
            Rect rect = new Rect();
            decorView.getWindowVisibleDisplayFrame(rect);
            show = rect.bottom != point.y;
        }
        return show;
    }

    public static int getNavigationBarHeight() {
        int height;
        if (navigationBarHeight != 0) {
            return navigationBarHeight;
        }
        Resources resources = TUIKit.getAppContext().getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        navigationBarHeight = height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        DisplayMetrics dm = TUIKit.getAppContext().getResources().getDisplayMetrics();
        size[0] = dm.widthPixels;
        size[1] = dm.heightPixels;
        return size;
    }

    public static int getStatusBarHeight() {
        int result = 0;
        int resourceId = TUIKit.getAppContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = TUIKit.getAppContext().getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        return metric.heightPixels;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        return metric.widthPixels;
    }

    public static int getPxByDp(float dp) {
        float scale = TUIKit.getAppContext().getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public static int getDpi(Context context) {
        int dpi = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, displayMetrics);
            dpi = displayMetrics.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    public static int getBottomStatusHeight(Context context) {
        if (SOFT_INPUT_HEIGHT > 0) {
            return SOFT_INPUT_HEIGHT;
        }
        int totalHeight = ScreenUtil.getDpi(context);
        int contentHeight = ScreenUtil.getScreenHeight(context);
        SOFT_INPUT_HEIGHT = totalHeight - contentHeight;
        return SOFT_INPUT_HEIGHT;
    }

    public static int[] scaledSize(int containerWidth, int containerHeight, int realWidth, int realHeight) {
        TUIKitLog.i(TAG, "scaledSize  containerWidth: " + containerWidth + " containerHeight: " + containerHeight + " realWidth: " + realWidth + " realHeight: " + realHeight);
        float deviceRate = (float)containerWidth / (float)containerHeight;
        float rate = (float)realWidth / (float)realHeight;
        int width = 0;
        int height = 0;
        if (rate < deviceRate) {
            height = containerHeight;
            width = (int)((float)containerHeight * rate);
        } else {
            width = containerWidth;
            height = (int)((float)containerWidth / rate);
        }
        return new int[]{width, height};
    }

    public static int dip2px(float dpValue) {
        float scale = TUIKit.getAppContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

